/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import com.trs.infra.I18NMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;

public class NewsComment {
    private int m_iNewsID;
    private int m_iSiteID;
    private int m_iChannelID;
    private int m_iLimitCode;
    private String m_sNewsTitle;
    private String m_sDataWithSign;
    private int m_nTopicId;
    private String m_sTopicTitle;
    private String m_sAdditionalData;

    public NewsComment() {
        this.m_iNewsID = 0;
        this.m_iSiteID = 0;
        this.m_iChannelID = 0;
        this.m_iLimitCode = 0;
        this.m_sNewsTitle = null;
        this.m_nTopicId = 0;
        this.m_sTopicTitle = null;
        this.m_sDataWithSign = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewsComment(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            byte[] byArray = string.getBytes("ISO8859_1");
            SignUtil signUtil = SignUtil.getVerify();
            byArray = signUtil.decodeRadix64(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            this.m_iNewsID = ((DataInputStream)filterInputStream).readInt();
            this.m_iSiteID = ((DataInputStream)filterInputStream).readInt();
            this.m_iChannelID = ((DataInputStream)filterInputStream).readInt();
            this.m_iLimitCode = ((DataInputStream)filterInputStream).readInt();
            this.m_sNewsTitle = ((DataInputStream)filterInputStream).readUTF();
            this.m_nTopicId = ((DataInputStream)filterInputStream).readInt();
            this.m_sTopicTitle = ((DataInputStream)filterInputStream).readUTF();
            this.m_sAdditionalData = ((DataInputStream)filterInputStream).readUTF();
            if (!signUtil.verify(byArray, ((DataInputStream)filterInputStream).readInt())) {
                throw new Exception("sign error");
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_iSiteID <= 0) {
                throw new Exception("setSiteId must call");
            }
            if (this.m_iChannelID <= 0) {
                throw new Exception("setChannelId must call");
            }
            if (this.m_sNewsTitle == null) {
                throw new Exception("setNewsTitle must call");
            }
            if (this.m_sTopicTitle == null) {
                this.m_sTopicTitle = "";
            }
            if (this.m_sAdditionalData == null) {
                this.m_sAdditionalData = "";
            }
            SignUtil signUtil = SignUtil.getSign();
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(512);
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_iNewsID);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_iSiteID);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_iChannelID);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_iLimitCode);
                ((DataOutputStream)filterOutputStream).writeUTF(this.m_sNewsTitle);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_nTopicId);
                ((DataOutputStream)filterOutputStream).writeUTF(this.m_sTopicTitle);
                ((DataOutputStream)filterOutputStream).writeUTF(this.m_sAdditionalData);
                ((DataOutputStream)filterOutputStream).flush();
                byte[] byArray = signUtil.sign(byteArrayOutputStream.toByteArray());
                ((DataOutputStream)filterOutputStream).writeInt(byArray.length);
                filterOutputStream.write(byArray);
                ((DataOutputStream)filterOutputStream).flush();
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_sDataWithSign = signUtil.encodeRadix64(byteArrayOutputStream.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public static void main(String[] stringArray) {
        try {
            NewsComment newsComment = new NewsComment();
            newsComment.setNewsId(1);
            newsComment.setSiteId(1);
            newsComment.setChannelId(1);
            newsComment.setLimit(1);
            newsComment.setNewsTitle(I18NMessage.get(NewsComment.class, "NewsComment.label1", "\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5"));
            newsComment.setAdditionalData("5;JS;TIME");
            String string = newsComment.getDataWithSign();
            System.out.println(string);
            NewsComment newsComment2 = new NewsComment("AAACZQAAAAEAAAAJAAAAAQAv5bm_5bee5byA5aeL56uL6aG556CU56m25a2m55Sf572R57uc6K-t6KiAYWFhZWUAAAAAAAAACTU7SlM7VElNRQAAAC4wLAIUJO1Jv44ZpJvjNJATq_8cgUyoaC8CFA7vOM4EDptmopykvACXk0AuN6oy");
            System.out.println(newsComment);
            System.out.println(newsComment2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setChannelId(int n) {
        this.m_iChannelID = n;
        this.m_sDataWithSign = null;
    }

    public void setLimit(int n) {
        this.m_iLimitCode = n;
        this.m_sDataWithSign = null;
    }

    public void setNewsId(int n) {
        this.m_iNewsID = n;
        this.m_sDataWithSign = null;
    }

    public void setNewsTitle(String string) {
        this.m_sNewsTitle = string;
        this.m_sDataWithSign = null;
    }

    public void setSiteId(int n) {
        this.m_iSiteID = n;
        this.m_sDataWithSign = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("SiteID:");
        stringBuffer.append(this.m_iSiteID);
        stringBuffer.append(",ChannelID:");
        stringBuffer.append(this.m_iChannelID);
        stringBuffer.append(",NewsID:");
        stringBuffer.append(this.m_iNewsID);
        stringBuffer.append(",Limit:");
        stringBuffer.append(this.m_iLimitCode);
        stringBuffer.append(",NewsTitle:");
        stringBuffer.append(this.m_sNewsTitle);
        stringBuffer.append(",IsTopic?:");
        stringBuffer.append(this.m_nTopicId);
        stringBuffer.append(",TopicTitle:");
        stringBuffer.append(this.m_sTopicTitle);
        stringBuffer.append(",AdditionalData:");
        stringBuffer.append(this.m_sAdditionalData);
        return stringBuffer.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int n) {
        this.m_nTopicId = n;
    }

    public String getTopicTitle() {
        return this.m_sTopicTitle;
    }

    public void setTopicTitle(String string) {
        this.m_sTopicTitle = string;
    }

    public String getAdditionalData() {
        return this.m_sAdditionalData;
    }

    public void setAdditionalData(String string) {
        this.m_sAdditionalData = string;
    }

    public static boolean isValidContentType(String string) {
        return (string = string.toUpperCase()).equals("JS") || string.equals("XML") || string.equals("TEXT");
    }

    public static boolean isValidTopRange(String string) {
        return (string = string.toUpperCase()).equals("TIME") || string.equals("HIT");
    }

    public class CommentEmitEnum {
        public static final String TYPE_JS = "JS";
        public static final String TYPE_XML = "XML";
        public static final String TYPE_TEXT = "TEXT";
        public static final String TYPE_DEFAULT = "JS";
        public static final String RANGE_TIME = "TIME";
        public static final String RANGE_HIT = "HIT";
        public static final String RANGE_DEFAULT = "TIME";
        public static final int STYLE_IPDISPLAY_COMPLETE = 0;
        public static final int STYLE_IPDISPLAY_HIDDENLAST = 1;
        public static final int STYLE_IPDISPLAY_HIDDENALL = 2;
        public static final int STYLE_IPDISPLAY_DEFAULT = 1;
    }
}

