/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Management {
    private int m_iSiteID;
    private String m_sSiteName;
    private int m_iChannelID;
    private String m_sChannelName;
    private int m_iNewsID;
    private String m_sNewsTitle;
    private int m_iUserID;
    private String m_sUserName;
    private String m_sDataWithSign;
    private int m_nTopicId;
    private String m_sTopicTitle;

    public Management() {
    }

    public Management(String string) throws Exception {
        byte[] byArray = string.getBytes("ISO8859_1");
        SignUtil signUtil = SignUtil.getVerify();
        byArray = signUtil.decodeRadix64(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.m_iUserID = dataInputStream.readInt();
        this.m_iSiteID = dataInputStream.readInt();
        this.m_iChannelID = dataInputStream.readInt();
        this.m_iNewsID = dataInputStream.readInt();
        this.m_sUserName = dataInputStream.readUTF();
        this.m_sSiteName = dataInputStream.readUTF();
        this.m_sChannelName = dataInputStream.readUTF();
        this.m_sNewsTitle = dataInputStream.readUTF();
        this.m_nTopicId = dataInputStream.readInt();
        this.m_sTopicTitle = dataInputStream.readUTF();
        if (!signUtil.verify(byArray, dataInputStream.readInt())) {
            throw new Exception("sign error");
        }
    }

    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_iUserID <= 0 || this.m_sUserName == null) {
                throw new Exception("setUser must call");
            }
            if (this.m_iSiteID <= 0 || this.m_sSiteName == null) {
                throw new Exception("setSite must call");
            }
            if (this.m_sChannelName == null) {
                this.m_sChannelName = "";
            }
            if (this.m_sNewsTitle == null) {
                this.m_sNewsTitle = "";
            }
            if (this.m_sTopicTitle == null) {
                this.m_sTopicTitle = "";
            }
            SignUtil signUtil = SignUtil.getSign();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.m_iUserID);
            dataOutputStream.writeInt(this.m_iSiteID);
            dataOutputStream.writeInt(this.m_iChannelID);
            dataOutputStream.writeInt(this.m_iNewsID);
            dataOutputStream.writeUTF(this.m_sUserName);
            dataOutputStream.writeUTF(this.m_sSiteName);
            dataOutputStream.writeUTF(this.m_sChannelName);
            dataOutputStream.writeUTF(this.m_sNewsTitle);
            dataOutputStream.writeInt(this.m_nTopicId);
            dataOutputStream.writeUTF(this.m_sTopicTitle);
            dataOutputStream.flush();
            byte[] byArray = signUtil.sign(byteArrayOutputStream.toByteArray());
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            this.m_sDataWithSign = signUtil.encodeRadix64(byteArrayOutputStream.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public int getNewsID() {
        return this.m_iNewsID;
    }

    public String getNewsTitle() {
        return this.m_sNewsTitle;
    }

    public void setNewsId(int n) {
        this.setNews(n, null);
    }

    public void setNews(int n, String string) {
        this.m_iNewsID = n;
        this.m_sNewsTitle = string;
        this.m_sDataWithSign = null;
    }

    public int getChannelID() {
        return this.m_iChannelID;
    }

    public String getChannelName() {
        return this.m_sChannelName;
    }

    public void setChannel(int n, String string) {
        this.m_iChannelID = n;
        this.m_sChannelName = string;
        this.m_sDataWithSign = null;
    }

    public int getSiteID() {
        return this.m_iSiteID;
    }

    public String getSiteName() {
        return this.m_sSiteName;
    }

    public void setSite(int n, String string) {
        this.m_iSiteID = n;
        this.m_sSiteName = string;
        this.m_sDataWithSign = null;
    }

    public int getUserID() {
        return this.m_iUserID;
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public void setUser(int n, String string) {
        this.m_iUserID = n;
        this.m_sUserName = string;
        this.m_sDataWithSign = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("User:");
        stringBuffer.append(this.m_iUserID);
        stringBuffer.append('/');
        stringBuffer.append(this.m_sUserName);
        stringBuffer.append(",Site:");
        stringBuffer.append(this.m_iSiteID);
        stringBuffer.append('/');
        stringBuffer.append(this.m_sSiteName);
        stringBuffer.append(",Channel:");
        stringBuffer.append(this.m_iChannelID);
        stringBuffer.append('/');
        stringBuffer.append(this.m_sChannelName);
        stringBuffer.append(",NewsID:");
        stringBuffer.append(this.m_iNewsID);
        stringBuffer.append('/');
        stringBuffer.append(this.m_sNewsTitle);
        return stringBuffer.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int n) {
        this.m_nTopicId = n;
    }

    public String getTopicTitle() {
        return this.m_sTopicTitle;
    }

    public void setTopicTitle(String string) {
        this.m_sTopicTitle = string;
    }
}

