/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.ckm;

import com.trs.DreamFactory;
import com.trs.ckm.soap.ABSHold;
import com.trs.ckm.soap.ABSResult;
import com.trs.ckm.soap.CkmSoapException;
import com.trs.ckm.soap.CollErrorInfoDetail;
import com.trs.ckm.soap.RevDetail;
import com.trs.ckm.soap.RevHold;
import com.trs.ckm.soap.RuleCATField;
import com.trs.ckm.soap.TrsCkmSoapClient;
import com.trs.cms.auth.persistent.User;
import com.trs.components.ckm.ICKMServer;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TRSCKMServer
extends BaseServer
implements ICKMServer {
    private static Logger logger = Logger.getLogger(TRSCKMServer.class);
    public static final String KEY_CKM_SERVER = "CKM_SERVER";
    public static final String KEY_CKM_PORT = "CKM_PORT";
    public static final String KEY_CKM_USERNAME = "CKM_USERNAME";
    public static final String KEY_CKM_PASSWORD = "CKM_PASSWORD";
    public static final String KEY_CKM_ENABLE_SIMSEARCH = "CKM_ENABLE_SIMSEARCH";
    public static final String KEY_CKM_ENABLE_EXTRACT = "CKM_ENABLE_EXTRACT";
    public static final String KEY_CKM_ENABLE_AUTOCHECK = "CKM_ENABLE_AUTOCHECK";
    public static final String KEY_CKM_HAS_OPEN = "CKM_HAS_OPEN";
    private int m_nKeywordNum = 10;
    private int m_nAbsLenPercent = 50;
    private ConfigServer m_oConfigServer = ConfigServer.createInstance();
    private final String SIM_MODEL_WCM52 = "TRSWCM52";
    private TrsCkmSoapClient m_oCKMSoapClient = null;
    private static ICKMServer s_oCKMServer = null;

    public Reports validateCKMServer(String string, String string2, String string3, String string4) {
        Reports reports = new Reports(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label1", "\u6821\u9a8cCKM\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38"));
        if (string == null || string2 == null || string3 == null || string4 == null) {
            reports.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label2", "\u53c2\u6570\u65e0\u6548\uff01"), null);
            return reports;
        }
        TrsCkmSoapClient trsCkmSoapClient = new TrsCkmSoapClient();
        trsCkmSoapClient.SetKeepAlive(true);
        trsCkmSoapClient.SetServer("http://" + string + ":" + string2, string3, string4);
        ABSHold aBSHold = new ABSHold(300, 50);
        try {
            trsCkmSoapClient.ABSext("test", aBSHold);
            reports.addSucessedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label3", "\u6821\u9a8c\u6210\u529f"));
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label4", "CKM\u670d\u52a1\u5668[http://") + string + ":" + string2 + I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label5", "]\u6821\u9a8c\u5931\u8d25\uff01"), exception);
        }
        return reports;
    }

    public void setCKMServer(String string, String string2, String string3, String string4) {
        try {
            this.m_oConfigServer.updateConfigValue(KEY_CKM_SERVER, string);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_PORT, string2);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_USERNAME, string3);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_PASSWORD, string4);
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label6", "\u66f4\u65b0CKMServer\u7684\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)exception);
        }
        if (!this.isStarted()) {
            this.startup();
        }
    }

    public void enableCKMService(boolean bl, boolean bl2, boolean bl3) {
        try {
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_SIMSEARCH, bl ? "true" : "false");
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_EXTRACT, bl2 ? "true" : "false");
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_AUTOCHECK, bl3 ? "true" : "false");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label6", "\u66f4\u65b0CKMServer\u7684\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)exception);
        }
        try {
            String string = this.m_oConfigServer.getInitProperty("WCM_PATH");
            if (string == null) {
                logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label7", "WCM_PATH\u8bbe\u7f6e\u9519\u8bef\uff01"));
                return;
            }
            string = CMyString.setStrEndWith(string, File.separatorChar);
            String string2 = string + "html_edit/js/trsckm_config.js";
            String string3 = "config.AutoExtract \t= " + (bl2 ? "true" : "false") + "\n";
            string3 = string3 + "config.AutoCheck \t= " + (bl3 ? "true" : "false") + "\n";
            CMyFile.writeFile(string2, string3);
            String string4 = string + "js/validator/CWCMCKMDocumentSimValidator_config.js";
            String string5 = "var WCMCKMSimSearchConfig = new Object();\n";
            string5 = string5 + "WCMCKMSimSearchConfig.enable \t= " + (bl ? "true" : "false") + "\n";
            CMyFile.writeFile(string4, string5);
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label8", "\u540c\u6b65\u66f4\u65b0\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01"), (Throwable)exception);
        }
    }

    public static ICKMServer getInstance() {
        if (s_oCKMServer == null) {
            s_oCKMServer = (ICKMServer)DreamFactory.createObjectById("ICKMServer");
        }
        try {
            if (s_oCKMServer.isNeedStartup()) {
                s_oCKMServer.startup();
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label9", "\u542f\u52a8CKM Server\u5931\u8d25\uff01"), (Throwable)exception);
        }
        return s_oCKMServer;
    }

    public String[] extractAbstractAndKeywords(String string) throws WCMException {
        if (this.m_oCKMSoapClient == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"));
        }
        try {
            ABSHold aBSHold = new ABSHold(this.m_nKeywordNum, this.m_nAbsLenPercent);
            ABSResult aBSResult = this.m_oCKMSoapClient.ABSext(string, aBSHold);
            if (aBSResult == null) {
                logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label11", "CKM \u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff01"));
                return null;
            }
            return new String[]{aBSResult.getabs(), aBSResult.getwordlist()};
        }
        catch (CkmSoapException ckmSoapException) {
            throw new WCMException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"), ckmSoapException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Documents simSearch(int n, String string) {
        RevDetail[] revDetailArray;
        User user = User.getSystem();
        if (CMyString.isEmpty(string)) {
            return new Documents(user);
        }
        long l = 0L;
        try {
            RevHold revHold = new RevHold(0, 0.8f);
            if (logger.isDebugEnabled()) {
                l = System.currentTimeMillis();
                logger.debug((Object)"simsearch begin...");
            }
            if ((revDetailArray = this.m_oCKMSoapClient.SimRetrieveByText("TRSWCM52", revHold, string)) == null || revDetailArray.length == 0) {
                Documents documents = new Documents(user);
                return documents;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("simsearch end...,time used(ms):" + (System.currentTimeMillis() - l)));
            }
            HashSet<String> hashSet = new HashSet<String>(revDetailArray.length);
            int n2 = revDetailArray.length;
            for (int i = 0; i < n2; ++i) {
                hashSet.add(revDetailArray[i].getid());
            }
            hashSet.remove(String.valueOf(n));
            if (hashSet.isEmpty()) {
                Documents documents = new Documents(user);
                return documents;
            }
            StringBuffer stringBuffer = new StringBuffer(128);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(',').append(iterator.next());
            }
            hashSet.clear();
            Documents documents = Documents.findByIds(user, stringBuffer.toString());
            return documents;
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label12", "\u76f8\u4f3c\u6027\u68c0\u7d22\u5931\u8d25\uff01"), throwable);
            revDetailArray = Documents.createNewInstance(user);
            return revDetailArray;
        }
        finally {
            long l2;
            long l3;
            if (logger.isDebugEnabled() && (l3 = (l2 = System.currentTimeMillis()) - l) > 10000L) {
                logger.debug((Object)("sim search total time(s):" + l3 / 1000L));
            }
        }
    }

    public CollErrorInfoDetail[] collateText(String string) throws WCMException {
        if (this.m_oCKMSoapClient == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"));
        }
        try {
            CollErrorInfoDetail[] collErrorInfoDetailArray = this.m_oCKMSoapClient.CollationText(string);
            return collErrorInfoDetailArray;
        }
        catch (CkmSoapException ckmSoapException) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label11", "CKM \u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)ckmSoapException);
            throw new WCMException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"), ckmSoapException);
        }
    }

    public void updateSimIndex(Document document) {
        try {
            String string = document.getContent();
            if (CMyString.isEmpty(string)) {
                return;
            }
            this.m_oCKMSoapClient.SimUpdateIndex("TRSWCM52", document.getKey().toString(), document.getContent());
        }
        catch (Exception exception) {
            logger.error((Object)("update " + document + " sim index error!"), (Throwable)exception);
        }
    }

    public void updateSimIndex(int n, String string) {
        if (CMyString.isEmpty(string)) {
            return;
        }
        try {
            this.m_oCKMSoapClient.SimUpdateIndex("TRSWCM52", String.valueOf(n), string);
        }
        catch (Exception exception) {
            logger.error((Object)("update [id=" + n + "] sim index error!"), (Throwable)exception);
        }
    }

    public void deleteSimIndex(Document document) {
        try {
            this.m_oCKMSoapClient.SimDeleteIndexByID("TRSWCM52", document.getKey().toString());
        }
        catch (Exception exception) {
            logger.error((Object)("update " + document + " sim index error!"), (Throwable)exception);
        }
    }

    protected void doShutdown() {
    }

    protected boolean doStart() {
        if (!this.isOpenCKMServer()) {
            logger.info((Object)"CKMServer is not open by AdminUser!");
            return false;
        }
        if (this.validateCKMServer().getSucessedReporterAt(0) == null) {
            logger.error((Object)"Validate CKM Error!");
            return false;
        }
        this.m_oCKMSoapClient = new TrsCkmSoapClient();
        this.m_oCKMSoapClient.SetKeepAlive(true);
        this.m_oCKMSoapClient.SetServer("http://" + this.getCKMServerIP() + ":" + this.getCKMServerPort(), this.getCKMServerUserName(), this.getCKMServerPassword());
        if (this.isEnableSimSearch()) {
            this.initSimDB();
        }
        try {
            String string = this.m_oConfigServer.getSysConfigValue("CKM_KEYWORDNUM", "10");
            this.m_nKeywordNum = Integer.parseInt(string);
            string = this.m_oConfigServer.getSysConfigValue("CKM_ABSLENPERCENT", "50");
            this.m_nAbsLenPercent = Integer.parseInt(string);
            if (this.m_nAbsLenPercent > 100) {
                this.m_nAbsLenPercent = 50;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public TrsCkmSoapClient getSoapClient() throws WCMException {
        if (!this.isOpenCKMServer()) {
            logger.debug((Object)"\u6ca1\u6709\u542f\u52a8\u667a\u80fd\u77e5\u8bc6\u670d\u52a1\uff01\u5efa\u8bae\u91c7\u8d2d\u4ee5\u63d0\u5347\u77e5\u8bc6\u5e93\u7684\u4ef7\u503c\uff01");
            return null;
        }
        if (this.m_oCKMSoapClient == null) {
            throw new WCMException("\u83b7\u53d6CKM\u63a5\u53e3\u5931\u8d25\uff0cCKMSoapClient\u6ca1\u6709\u542f\u52a8");
        }
        return this.m_oCKMSoapClient;
    }

    private void initSimDB() {
        final TrsCkmSoapClient trsCkmSoapClient = this.m_oCKMSoapClient;
        new Thread(){

            public void run() {
                try {
                    trsCkmSoapClient.SimDropModel("TRSWCM52");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    trsCkmSoapClient.SimCreateModel("TRSWCM52");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    User user = User.getSystem();
                    CMyDateTime cMyDateTime = CMyDateTime.now().dateAdd(2, -3);
                    String string = "DocStatus>0 and DocChannel>=0 and DocType in(20,10) and CRTIME>=" + DBManager.getDBManager().getDBType().sqlDateTime(cMyDateTime.toString(), "YYYY-MM-DD HH24:MI:SS");
                    String string2 = "DocId,DocChannel,DocTitle,DocContent";
                    WCMFilter wCMFilter = new WCMFilter("", string, "", string2);
                    Documents documents = Documents.openWCMObjs(user, wCMFilter);
                    int n = documents.size();
                    for (int i = 0; i < n; ++i) {
                        Document document = (Document)documents.getAt(i);
                        if (document == null) continue;
                        trsCkmSoapClient.SimUpdateIndex("TRSWCM52", String.valueOf(document.getId()), document.getContent());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Reports validateCKMServer() {
        try {
            String string = this.m_oConfigServer.getSysConfigValue(KEY_CKM_SERVER, "localhost");
            String string2 = this.m_oConfigServer.getSysConfigValue(KEY_CKM_PORT, "8000");
            String string3 = this.m_oConfigServer.getSysConfigValue(KEY_CKM_USERNAME, "admin");
            String string4 = this.m_oConfigServer.getSysConfigValue(KEY_CKM_PASSWORD, "admin");
            return this.validateCKMServer(string, string2, string3, string4);
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label13", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25"), (Throwable)exception);
            Reports reports = new Reports(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label14", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25!"));
            reports.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label13", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25"), exception);
            return reports;
        }
    }

    public String getCKMServerIP() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_SERVER, "localhost");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label15", "\u83b7\u53d6CKMServer\u7684IP\u5931\u8d25"), (Throwable)exception);
            return null;
        }
    }

    public String getCKMServerPort() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_PORT, "8000");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label16", "\u83b7\u53d6CKMServer\u7684Port\u5931\u8d25"), (Throwable)exception);
            return null;
        }
    }

    public String getCKMServerUserName() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_USERNAME, "admin");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label17", "\u83b7\u53d6CKMServer\u7684User\u5931\u8d25"), (Throwable)exception);
            return null;
        }
    }

    public String getCKMServerPassword() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_PASSWORD, "admin");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)exception);
            return null;
        }
    }

    public boolean isEnableSimSearch() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_SIMSEARCH, "false"));
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)exception);
            return false;
        }
    }

    public boolean isEnableAutoExtract() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_EXTRACT, "false"));
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)exception);
            return false;
        }
    }

    public boolean isEnableAutoCheck() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_AUTOCHECK, "false"));
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)exception);
            return false;
        }
    }

    public boolean isNeedStartup() {
        return !this.isStarted() && (this.isEnableAutoCheck() || this.isEnableAutoExtract() || this.isEnableSimSearch());
    }

    public boolean isOpenCKMServer() {
        return this.isEnableSimSearch() || this.isEnableAutoCheck() || this.isEnableAutoExtract();
    }

    private String getCKMModelName() {
        try {
            return this.m_oConfigServer.getSysConfigValue("TRS_CKM_MODELNAME", "demo");
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684TRS_CKM_MODELNAME\u5931\u8d25"), (Throwable)exception);
            return null;
        }
    }

    public String[] pySearch(String string) throws WCMException {
        TrsCkmSoapClient trsCkmSoapClient = this.getSoapClient();
        if (trsCkmSoapClient != null) {
            try {
                return trsCkmSoapClient.PySearch(string, this.getCKMModelName(), 0);
            }
            catch (CkmSoapException ckmSoapException) {
                throw new WCMException(0, "\u62fc\u97f3\u68c0\u7d22\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + ckmSoapException.getMessage() + "]");
            }
        }
        return null;
    }

    public String[] dySearch(String string) throws WCMException {
        TrsCkmSoapClient trsCkmSoapClient = this.getSoapClient();
        if (trsCkmSoapClient != null) {
            try {
                return trsCkmSoapClient.DySearch(string, this.getCKMModelName(), 0);
            }
            catch (CkmSoapException ckmSoapException) {
                throw new WCMException(0, "\u77ed\u8bed\u68c0\u7d22\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + ckmSoapException.getMessage() + "]");
            }
        }
        return null;
    }

    public int doRuleCATUploadModel(String string, int n, String string2) throws WCMException {
        TrsCkmSoapClient trsCkmSoapClient = this.getSoapClient();
        if (trsCkmSoapClient != null) {
            try {
                return trsCkmSoapClient.RuleCATUploadModel(string, n, string2);
            }
            catch (CkmSoapException ckmSoapException) {
                throw new WCMException(0, "\u4e0a\u4f20\u89c4\u5219\u5206\u7c7b\u6a21\u677f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + ckmSoapException.getMessage() + "]");
            }
        }
        return 0;
    }

    public String[] doRuleCATClassify(String string, String[] stringArray, String[] stringArray2) throws WCMException {
        TrsCkmSoapClient trsCkmSoapClient = this.getSoapClient();
        if (stringArray == null || stringArray2 == null) {
            return null;
        }
        if (stringArray.length != stringArray2.length) {
            return null;
        }
        if (trsCkmSoapClient != null) {
            RuleCATField[] ruleCATFieldArray = new RuleCATField[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                RuleCATField ruleCATField;
                ruleCATFieldArray[i] = ruleCATField = new RuleCATField(stringArray[i], stringArray2[i]);
            }
            try {
                if (logger.isDebugEnabled()) {
                    System.out.println(ruleCATFieldArray.length + ":" + string + ":" + stringArray[0] + ":" + stringArray2[0]);
                }
                String string2 = trsCkmSoapClient.RuleCATClassifyText(string, ruleCATFieldArray);
                if (logger.isDebugEnabled()) {
                    System.out.println("sClassifyResult:" + string2);
                }
                if (string2 != null) {
                    return CMyString.split(string2, ";");
                }
                return null;
            }
            catch (CkmSoapException ckmSoapException) {
                throw new WCMException(0, "\u8c03\u7528CKM\u89c4\u5219\u5206\u7c7b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + ckmSoapException.getMessage() + "]");
            }
        }
        return null;
    }
}

