/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.ckm;

import com.trs.components.ckm.TRSCKMServer;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class DocumentLCListenerForSIMSearch
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForSIMSearch.class);

    public void notifyOnAddObj(BaseObj baseObj) {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document document = (Document)baseObj;
        if (document.getType() == 20 || document.getType() == 10) {
            TRSCKMServer.getInstance().updateSimIndex(document);
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document document = (Document)baseObj;
        if (document.getType() == 20 || document.getType() == 10) {
            TRSCKMServer.getInstance().deleteSimIndex(document);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document document = (Document)baseObj;
        if (document.getType() == 20 || document.getType() == 10) {
            if (!document.isChangeProperty("DOCCONTENT")) {
                return;
            }
            TRSCKMServer.getInstance().updateSimIndex(document.getId(), document.getNewPropertyAsString("DOCCONTENT"));
        }
    }
}

