/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.handlers;

import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IConditionHandler;
import com.trs.cms.process.engine.handlers.ConditionHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import org.apache.log4j.Logger;

public class OverTimeHandler
implements IConditionHandler {
    private static Logger logger = Logger.getLogger(OverTimeHandler.class);
    private static final int DATE_FIELD_WORKTIME = 818420062;

    public boolean isAccordWith(ExecuteContext executeContext, FlowCondition flowCondition) {
        int n = flowCondition.getParamName().toUpperCase().hashCode();
        int n2 = 0;
        try {
            n2 = Integer.parseInt(flowCondition.getUnitValue());
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)I18NMessage.get(OverTimeHandler.class, "OverTimeHandler.label1", "\u6307\u5b9a\u6bd4\u8f83\u65f6\u95f4\u5355\u4f4d\u6709\u8bef\uff0c\u4e0d\u662f\u6574\u578b\u6570\uff01"), (Throwable)numberFormatException);
            return false;
        }
        int n3 = flowCondition.getRelationOperator().toUpperCase().hashCode();
        CMyDateTime cMyDateTime = CMyDateTime.now();
        CMyDateTime cMyDateTime2 = this.getCompareDate(executeContext, n);
        if (cMyDateTime2 == null || cMyDateTime2.isNull()) {
            logger.error((Object)I18NMessage.get(OverTimeHandler.class, "OverTimeHandler.label2", "\u6ca1\u6709\u83b7\u53d6\u5230\u6307\u5b9a\u7684\u65f6\u95f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6bd4\u8f83\uff01"));
            return false;
        }
        switch (n3) {
            case 60: 
            case 62: 
            case 1921: 
            case 1983: {
                long l = 0L;
                try {
                    l = Long.parseLong(flowCondition.getParamValue());
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)I18NMessage.get(OverTimeHandler.class, "OverTimeHandler.label3", "\u6307\u5b9a\u6bd4\u8f83\u7684\u65f6\u95f4\u6709\u8bef\uff0c\u4e0d\u662f\u6574\u578b\u6570\uff01"), (Throwable)numberFormatException);
                    return false;
                }
                long l2 = 0L;
                try {
                    l2 = cMyDateTime.dateDiff(n2, cMyDateTime2);
                }
                catch (Exception exception) {
                    logger.error((Object)I18NMessage.get(OverTimeHandler.class, "OverTimeHandler.label4", "\u6bd4\u8f83\u7684\u65f6\u95f4\u914d\u7f6e\u8bbe\u7f6e\u7684\u53ef\u80fd\u6709\u8bef\uff0c\u5bfc\u81f4\u4e0d\u80fd\u8ba1\u7b97\u51fa\u65f6\u95f4\u5dee\uff01"), (Throwable)exception);
                    return false;
                }
                return ConditionHelper.compare(l2, l, n3);
            }
        }
        return false;
    }

    private CMyDateTime getCompareDate(ExecuteContext executeContext, int n) {
        CMyDateTime cMyDateTime = null;
        switch (n) {
            case 818420062: {
                cMyDateTime = executeContext.getCurrFlowDoc().getPostTime();
                break;
            }
        }
        return cMyDateTime;
    }

    public static void main(String[] stringArray) {
        System.out.println("WorkTime".hashCode());
        System.out.println("WorkTime".toUpperCase().hashCode());
        System.out.println(818420062);
    }
}

