/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.creators;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.engine.AbstractToUsersCreator;
import com.trs.cms.process.engine.FlowContext;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class GroupMembersAsToUsersCreator
extends AbstractToUsersCreator {
    protected static Logger logger = Logger.getLogger(GroupMembersAsToUsersCreator.class);

    public Users createToUsers(FlowContext flowContext, ToUsersCreatorConfig toUsersCreatorConfig) {
        try {
            IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
            User user = flowContext.getPostUser();
            logger.debug((Object)("postUser:" + user));
            Groups groups = iDepartmentMgr.getDeptGroups(user);
            logger.debug((Object)("groupsDept:" + groups));
            if (groups == null || groups.isEmpty()) {
                return null;
            }
            WCMFilter wCMFilter = new WCMFilter("", "", "UserName");
            StringBuffer stringBuffer = new StringBuffer(20 + groups.size() * 2);
            stringBuffer.append("GroupId in(");
            int n = groups.size();
            for (int i = 0; i < n; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                wCMFilter.addSearchValues(group.getId());
                stringBuffer.append("?,");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append(")");
            String string = "UserId in(select UserId from WCMGrpUser where " + stringBuffer + ") and isdeleted = 0";
            wCMFilter.setWhere(string);
            logger.debug((Object)("Where of query dept users:" + string));
            return Users.openWCMObjs(null, wCMFilter);
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(GroupMembersAsToUsersCreator.class, "GroupMembersAsToUsersCreator.label1", "\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7684\u90e8\u95e8\u5931\u8d25\uff01"), throwable);
            return null;
        }
    }

    public boolean isRangedFromGroup() {
        return false;
    }

    public Group getGroupRange(FlowContext flowContext, ToUsersCreatorConfig toUsersCreatorConfig) throws WCMException {
        return null;
    }
}

