/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.definition.FlowActions;
import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.definition.FlowConditions;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.IConditionHandler;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class RuleExecuteHelper {
    private static Logger logger = Logger.getLogger(RuleExecuteHelper.class);

    public static void executeRules(ExecuteContext executeContext, FlowRule[] flowRuleArray) throws WCMException {
        if (flowRuleArray == null || flowRuleArray.length == 0) {
            return;
        }
        for (int i = 0; i < flowRuleArray.length; ++i) {
            Object object;
            FlowRule flowRule = flowRuleArray[i];
            boolean bl = true;
            FlowConditions flowConditions = flowRule.getConditions(null);
            int n = flowConditions.size();
            for (int j = 0; j < n; ++j) {
                FlowCondition flowCondition = (FlowCondition)flowConditions.getAt(j);
                if (flowCondition == null) continue;
                boolean bl2 = false;
                object = null;
                try {
                    object = (IConditionHandler)Class.forName(flowCondition.getHandler()).newInstance();
                    bl2 = object.isAccordWith(executeContext, flowCondition);
                }
                catch (Throwable throwable) {
                    logger.warn((Object)I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label1", "\u6307\u5b9a\u7684Handler\u5b9e\u4f8b\u5316\u6216\u8005\u5224\u65ad\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01"), throwable);
                }
                if (bl2) {
                    if (flowCondition.isAndOperator()) continue;
                    bl = true;
                    break;
                }
                if (!flowCondition.isAndOperator()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            FlowActions flowActions = flowRule.getActions(null);
            int n2 = flowActions.size();
            for (n = 0; n < n2; ++n) {
                FlowAction flowAction = (FlowAction)flowActions.getAt(n);
                if (flowAction == null) continue;
                object = null;
                try {
                    object = (IActionHandler)Class.forName(flowAction.getHandler()).newInstance();
                }
                catch (Throwable throwable) {
                    logger.warn((Object)(I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label2", "\u6307\u5b9a\u7684Handler[") + flowAction.getHandler() + I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label3", "]\u5b9e\u4f8b\u5316\u6709\u8bef\uff01")), throwable);
                    continue;
                }
                try {
                    object.execute(executeContext, flowAction);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn((Object)("Handler[" + flowAction.getHandler() + I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label4", "]\u6267\u884c\u5931\u8d25\uff01")), throwable);
                }
            }
        }
    }
}

