/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FlowNextBranchInfo {
    private static Logger logger = Logger.getLogger(FlowNextBranchInfo.class);
    private FlowDoc m_oCurrFlowDoc = null;
    private User m_currUser = null;
    private int m_nNextNodeId = 0;
    private Users m_oToUsers = null;
    private Users m_oUsersPassed = null;
    private String m_sNotifyTypes = null;
    private Status m_oChangeStatus = null;
    private FlowConfigServer m_oFlowConfigServer = null;
    private FlowContext m_oCurrFlowContext = null;
    private boolean m_bResubmit = false;
    private Group m_oGroupRange = null;

    public FlowNextBranchInfo(User user, FlowDoc flowDoc, int n, boolean bl) throws WCMException {
        this.m_bResubmit = bl;
        try {
            this.m_oFlowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(FlowNextBranchInfo.class, "FlowNextBranchInfo.label1", "\u521b\u5efa\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25\uff01"), throwable);
        }
        this.m_oCurrFlowDoc = flowDoc;
        this.m_nNextNodeId = n;
        this.m_currUser = user;
        this.makeInfo();
    }

    private void makeInfo() throws WCMException {
        FlowDoc flowDoc;
        Object object;
        Cloneable cloneable;
        if (this.m_oCurrFlowDoc.getWorkModal() == 1) {
            if (this.m_bResubmit) {
                FlowNode flowNode = this.m_oCurrFlowDoc.getNode();
                this.m_oToUsers = this.getDealers(flowNode);
                WCMFilter wCMFilter = new WCMFilter("", "exists(select WCMFlowDoc.ToUserId from WCMFlowDoc where WCMFlowDoc.Worked=1 and WCMFlowDoc.ParentId=? and WCMFlowDoc.ToUserId=WCMUser.UserId)", "");
                wCMFilter.addSearchValues(this.m_oCurrFlowDoc.getId());
                this.m_oUsersPassed = Users.openWCMObjs(null, wCMFilter);
                FlowNodeBranch flowNodeBranch = this.m_oCurrFlowDoc.getPreNode().getBranchTo(this.m_currUser, flowNode);
                this.m_oChangeStatus = flowNodeBranch.getStatus();
                this.m_sNotifyTypes = flowNodeBranch.getNotifyTypes();
                return;
            }
            cloneable = new WCMFilter("", "ParentId=? and FlowDocId<>?", "");
            ((WCMFilter)cloneable).addSearchValues(this.m_oCurrFlowDoc.getParentId());
            ((WCMFilter)cloneable).addSearchValues(this.m_oCurrFlowDoc.getId());
            object = FlowDocs.openWCMObjs(this.m_currUser, (WCMFilter)cloneable);
            this.m_oToUsers = new Users(this.m_currUser, ((BaseObjs)object).size(), 1);
            this.m_oUsersPassed = new Users(this.m_currUser, ((BaseObjs)object).size(), 1);
            int n = ((BaseObjs)object).size();
            for (int i = 0; i < n; ++i) {
                User user;
                flowDoc = (FlowDoc)((BaseObjs)object).getAt(i);
                if (flowDoc == null || (user = flowDoc.getToUser()) == null) continue;
                if (flowDoc.isWorked()) {
                    this.m_oUsersPassed.addElement(user);
                    continue;
                }
                this.m_oToUsers.addElement(user);
            }
            if (!this.m_oToUsers.isEmpty()) {
                return;
            }
        }
        cloneable = this.m_oCurrFlowDoc.getNode();
        object = null;
        object = this.m_oCurrFlowDoc.getFlag() == 2 ? this.m_oCurrFlowDoc.getPreNode() : this.findNodeById(this.m_nNextNodeId);
        if (this.m_bResubmit) {
            cloneable = this.m_oCurrFlowDoc.getPreNode();
        }
        FlowNodeBranch flowNodeBranch = ((FlowNode)cloneable).getBranchTo(this.m_currUser, (FlowNode)object);
        if (this.m_oCurrFlowDoc.getFlag() == 2) {
            this.m_oToUsers = new Users(this.m_currUser, 1, 1);
            FlowDoc flowDoc2 = this.m_oCurrFlowDoc.getPreFlowDoc();
            if (flowDoc2 == null || flowDoc2.getWorkModal() != 1 || flowDoc2.getParentId() == 0) {
                this.m_oToUsers.addElement(this.m_oCurrFlowDoc.getPostUser());
            } else {
                flowDoc = flowDoc2.getParent();
                if (flowDoc != null) {
                    this.m_oToUsers = flowDoc.getToUsers(null);
                } else {
                    this.m_oToUsers.addElement(this.m_oCurrFlowDoc.getPostUser());
                }
            }
        } else {
            this.m_oToUsers = this.getDealers((FlowNode)object);
            this.m_oGroupRange = this.getRangedGroup((FlowNode)object);
        }
        if (flowNodeBranch != null) {
            this.m_oChangeStatus = flowNodeBranch.getStatus();
            this.m_sNotifyTypes = flowNodeBranch.getNotifyTypes();
        }
    }

    private FlowNode findNodeById(int n) throws WCMException {
        FlowNode flowNode = FlowNode.findById(n);
        if (flowNode == null) {
            throw new WCMException(I18NMessage.get(FlowNextBranchInfo.class, "FlowNextBranchInfo.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8282\u70b9\uff01[ID=") + n + "]");
        }
        return flowNode;
    }

    public Status getChangeStatus() {
        return this.m_oChangeStatus;
    }

    public void setChangeStatus(Status status) {
        this.m_oChangeStatus = status;
    }

    public Users getToUsers() {
        return this.m_oToUsers;
    }

    public void setToUsers(Users users) {
        this.m_oToUsers = users;
    }

    public String getNotifyTypes() {
        return this.m_sNotifyTypes;
    }

    public void setNotifyTypes(String string) {
        this.m_sNotifyTypes = string;
    }

    public Users getUsersPassed() {
        return this.m_oUsersPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Users getDealers(FlowNode flowNode) throws WCMException {
        if (flowNode == null) {
            return new Users(null);
        }
        FlowContext flowContext = this.getCurrFlowContext();
        FlowNode flowNode2 = flowContext.getNextNode();
        flowContext.setNextNode(flowNode);
        try {
            Object object;
            String string = flowNode.getPropertyAsString("ToUsersCreator");
            String string2 = flowNode.getPropertyAsString("ToUsersCreatorParams");
            if (!CMyString.isEmpty(string) && (object = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(string, string2)) != null) {
                Users users;
                Users users2 = users = ((ToUsersCreatorConfig)object).getToUsers(flowContext);
                return users2;
            }
            Object object2 = object = flowNode.getOperUsers(null, true);
            return object2;
        }
        finally {
            flowContext.setNextNode(flowNode2);
        }
    }

    private Group getRangedGroup(FlowNode flowNode) throws WCMException {
        ToUsersCreatorConfig toUsersCreatorConfig;
        if (flowNode == null) {
            return null;
        }
        Group group = null;
        String string = flowNode.getPropertyAsString("ToUsersCreator");
        if (!CMyString.isEmpty(string) && (toUsersCreatorConfig = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(string)) != null) {
            group = toUsersCreatorConfig.getGroupRange(this.getCurrFlowContext());
        }
        return group;
    }

    public FlowContext getCurrFlowContext() throws WCMException {
        if (this.m_oCurrFlowContext == null) {
            this.m_oCurrFlowContext = new FlowContext(this.m_currUser, this.m_oCurrFlowDoc.getFlowContent());
        }
        return this.m_oCurrFlowContext;
    }

    public void setCurrFlowContext(FlowContext flowContext) {
        this.m_oCurrFlowContext = flowContext;
    }

    public boolean isResubmit() {
        return this.m_bResubmit;
    }

    public void setResubmit(boolean bl) {
        this.m_bResubmit = bl;
    }

    public Group getGroupRange() {
        return this.m_oGroupRange;
    }

    public void setGroupRange(Group group) {
        this.m_oGroupRange = group;
    }
}

