/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class FlowDocs
extends CMSBaseObjs {
    public FlowDocs(User user) {
        super(user);
    }

    public FlowDocs(User user, int n, int n2) {
        super(user, n, n2);
    }

    protected String getDbTableName() {
        return "WCMFLOWDOC";
    }

    public String getIdFieldName() {
        return "FLOWDOCID";
    }

    public Class getElementClass() {
        return FlowDoc.class;
    }

    public BaseObjs newInstance() throws Exception {
        return new FlowDocs(this.currUser);
    }

    public static final FlowDocs findByIds(User user, String string) {
        FlowDocs flowDocs = FlowDocs.createNewInstance(user);
        if (string == null || string.length() <= 0) {
            return flowDocs;
        }
        flowDocs.addElement(string);
        return flowDocs;
    }

    public static final FlowDocs findByIdsOfDealer(User user, String string, User user2) throws WCMException {
        if (user2 == null) {
            throw new WCMException(I18NMessage.get(FlowDocs.class, "FlowDocs.label1", "\u6ca1\u6709\u6307\u5b9a\u5904\u7406\u4eba\uff01"));
        }
        FlowDocs flowDocs = FlowDocs.findByIds(user, string);
        for (int i = flowDocs.size() - 1; i >= 0; --i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc != null && flowDoc.getToUserId() == user2.getId()) continue;
            flowDocs.removeAt(i, false);
        }
        return flowDocs;
    }

    public static final FlowDocs findByIdsOfPoster(User user, String string, User user2) throws WCMException {
        if (user2 == null) {
            throw new WCMException(I18NMessage.get(FlowDocs.class, "FlowDocs.label1", "\u6ca1\u6709\u6307\u5b9a\u5904\u7406\u4eba\uff01"));
        }
        FlowDocs flowDocs = FlowDocs.findByIds(user, string);
        for (int i = flowDocs.size() - 1; i >= 0; --i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc != null && user2.getName().equalsIgnoreCase(flowDoc.getPostUserName())) continue;
            flowDocs.removeAt(i, false);
        }
        return flowDocs;
    }

    public static final FlowDocs findOfContent(User user, int n, int n2, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ObjType=? and ObjId=?", "");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.addSearchValues(n2);
        wCMFilter2.mergeWith(wCMFilter);
        return FlowDocs.openWCMObjs(user, wCMFilter2);
    }

    public static final FlowDocs openWCMObjs(User user, WCMFilter wCMFilter) throws WCMException {
        FlowDocs flowDocs = FlowDocs.createNewInstance(user);
        flowDocs.open(wCMFilter);
        return flowDocs;
    }

    public static FlowDocs createNewInstance(User user) {
        return new FlowDocs(user);
    }
}

