/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowDocBaks;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FlowDoc
extends CMSObj {
    private static Logger logger = Logger.getLogger(FlowDoc.class);
    public static final int OBJ_TYPE = 405;
    public static final String DB_TABLE_NAME = "WCMFLOWDOC";
    public static final String DB_ID_NAME = "FLOWDOCID";
    private IFlowContent m_oCurrContent = null;
    private static final int[] OPERATIONS_SYSTEM = new int[]{2, 6, 7, 8, 4, 18, 13};

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 405;
    }

    public int getNodeId() {
        return this.getPropertyAsInt("NODEID", 0);
    }

    public FlowNode getNode() throws WCMException {
        return FlowNode.findById(this.getNodeId());
    }

    public boolean setNode(int n) throws WCMException {
        return this.setProperty("NODEID", n);
    }

    public boolean setNode(FlowNode flowNode) throws WCMException {
        if (flowNode == null || !flowNode.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label1", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowDoc.setNode\uff09"));
        }
        return this.setProperty("NODEID", flowNode.getId());
    }

    public int getToUserId() {
        return this.getPropertyAsInt("ToUserId", 0);
    }

    public User getToUser() throws WCMException {
        return User.findById(this.getToUserId());
    }

    public String getToUserNames() throws WCMException {
        if (this.getToUserId() > 0) {
            User user = this.getToUser();
            if (user == null) {
                return I18NMessage.get(FlowDoc.class, "FlowDoc.label2", "\u672a\u77e5[") + this.getToUserId() + "]";
            }
            return user.getName();
        }
        if (this.getToUserIds() == "") {
            return "";
        }
        Users users = this.getToUsers(null);
        StringBuffer stringBuffer = null;
        int n = users.size();
        for (int i = 0; i < n; ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n * 7);
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(user.getName());
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean setToUser(int n) throws WCMException {
        return this.setToUser(User.findById(n));
    }

    public boolean setToUser(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label3", "\u65e0\u6548\u7684\u63a5\u6536\u8005\uff01"));
        }
        return this.setProperty("ToUserId", user.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setContentType(int n) throws WCMException {
        return this.setProperty("OBJTYPE", n);
    }

    public int getContentId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setContentId(int n) throws WCMException {
        return this.setProperty("OBJID", n);
    }

    public IFlowContent getFlowContent() throws WCMException {
        if (this.m_oCurrContent == null) {
            this.m_oCurrContent = FlowContentHelper.createFlowContent(this.getContentType(), this.getContentId());
            FlowNode flowNode = this.getNode();
            if (flowNode != null) {
                if (this.m_oCurrContent == null) {
                    return null;
                }
                this.m_oCurrContent.setFlow(flowNode.getFlow());
            }
        }
        this.m_oCurrContent.setFlowDoc(this);
        return this.m_oCurrContent;
    }

    public boolean setFlowContent(int n, int n2) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label4", "\u4e0d\u5141\u8bb8\u4fee\u6539\u5c5e\u6027Doc\uff08FlowDoc.setDoc\uff09"));
        }
        return this.setContentType(n) && this.setContentId(n2);
    }

    public boolean setFlowContent(IFlowContent iFlowContent) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label5", "\u65e0\u6548\u7684\u6d41\u8f6c\u5185\u5bb9(FlowDoc.setDoc)"));
        }
        return this.setFlowContent(iFlowContent.getContentType(), iFlowContent.getSubinstanceId());
    }

    public int getFlag() {
        return this.getPropertyAsInt("FLAG", 0);
    }

    public String getFlagDesc() {
        int n = this.getFlag();
        for (int i = 0; i < OPERATIONS_SYSTEM.length; ++i) {
            if (n != OPERATIONS_SYSTEM[i]) continue;
            return ProcessConstants.getFlagDesc(n);
        }
        try {
            String string;
            FlowNodeBranch flowNodeBranch = this.getBranchComeFrom(null);
            if (flowNodeBranch != null && !CMyString.isEmpty(string = flowNodeBranch.getName())) {
                return string;
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(FlowDoc.class, "FlowDoc.label6", "\u83b7\u53d6\u5206\u652f\u53d1\u751f\u5f02\u5e38"), (Throwable)exception);
            return I18NMessage.get(FlowDoc.class, "FlowDoc.label6", "\u83b7\u53d6\u5206\u652f\u53d1\u751f\u5f02\u5e38");
        }
        return ProcessConstants.getFlagDesc(n);
    }

    public boolean setFlag(int n) throws WCMException {
        return this.setProperty("FLAG", n);
    }

    public int getWorkModal() {
        return this.getPropertyAsInt("WorkModal", 0);
    }

    public String getWorkModalDesc() {
        return ProcessConstants.getWorkModalDesc(this.getWorkModal());
    }

    public boolean setWorkModal(int n) throws WCMException {
        return this.setProperty("WorkModal", n);
    }

    public boolean isWorked() {
        return this.getPropertyAsBoolean("Worked", false);
    }

    public boolean setWorked(boolean bl) throws WCMException {
        if (bl && !this.isWorked()) {
            this.setProperty("WorkTime", CMyDateTime.now());
        }
        return this.setProperty("Worked", bl);
    }

    public int getPreFlowDocId() {
        return this.getPropertyAsInt("PreFlowDocId", 0);
    }

    public FlowDoc getPreFlowDoc() throws WCMException {
        int n = this.getPreFlowDocId();
        if (n == 0) {
            return null;
        }
        return FlowDoc.findById(n);
    }

    public boolean setPreFlowDoc(int n) throws WCMException {
        return this.setProperty("PreFlowDocId", n);
    }

    public int getParentId() {
        return this.getPropertyAsInt("ParentId", 0);
    }

    public FlowDoc getParent() throws WCMException {
        int n = this.getParentId();
        if (n == 0) {
            return this;
        }
        return FlowDoc.findById(n);
    }

    public boolean setParent(int n) throws WCMException {
        return this.setProperty("ParentId", n);
    }

    public String getPostUserName() {
        return (String)this.getProperty("POSTUSER");
    }

    public String getPostUserTrueName() {
        String string = (String)this.getProperty("POSTUSER");
        User user = User.findByName(string);
        String string2 = string;
        if (user != null) {
            string2 = user.getTrueName();
        }
        if (string2 != null && !string2.equals("")) {
            string = string2;
        }
        return string;
    }

    public String getRealPostUserNames() {
        String string = this.getPropertyAsString("TogetherUsers");
        if (string != null && (string = string.trim()).length() > 0) {
            return string;
        }
        return this.getPostUserName();
    }

    public User getPostUser() {
        return User.findByName(this.getPostUserName());
    }

    public boolean setPostUser(String string) throws WCMException {
        return this.setPostUser(User.findByName(string));
    }

    public boolean setPostUser(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label7", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61\uff08FlowDoc.setPostUser\uff09"));
        }
        return this.setProperty("POSTUSER", user.getName());
    }

    public CMyDateTime getPostTime() {
        return (CMyDateTime)this.getProperty("POSTTIME");
    }

    public boolean setPostTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("POSTTIME", cMyDateTime);
    }

    public String getPostDesc() {
        return (String)this.getProperty("POSTDESC");
    }

    public boolean setPostDesc(String string) throws WCMException {
        return this.setProperty("POSTDESC", string);
    }

    public String getToUserIds() {
        String string = this.getPropertyAsString("TOUSERS");
        return string == null ? "" : string;
    }

    public Users getToUsers(User user) throws WCMException {
        String string = this.getToUserIds();
        if (CMyString.isEmpty(string)) {
            string = String.valueOf(this.getToUserId());
        }
        return Users.findByIds(user, string);
    }

    public boolean setToUsers(String string) throws WCMException {
        if (string == null) {
            string = "";
        } else if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                try {
                    Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label8", "\u65e0\u6548\u7684\u7528\u6237\uff1a") + string2 + "\uff08FlowDoc.setToUsers\uff09");
                }
            }
        }
        return this.setProperty("TOUSERS", string);
    }

    public boolean addToUser(int n) throws WCMException {
        return this.addToUser(User.findById(n));
    }

    public boolean addToUser(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label9", "\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a\uff08FlowDoc.addToUser\uff09"));
        }
        try {
            String string = String.valueOf(user.getId());
            String string2 = "";
            string2 = this.isAddMode() ? (String)this.getProperty("TOUSERS") : (String)this.getNewProperty("TOUSERS");
            if (string2 == null) {
                string2 = this.getToUserIds();
            }
            if (("," + string2 + ",").indexOf("," + string + ",") >= 0) {
                return false;
            }
            return this.setProperty("TOUSERS", (string2.length() == 0 ? "" : string2 + ",") + string);
        }
        catch (WCMException wCMException) {
            throw wCMException;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label10", "\u6dfb\u52a0\u9012\u9001\u7528\u6237\u5931\u8d25\uff08FlowDoc.addToUser\uff09"), exception);
        }
    }

    public int getPreNodeId() {
        return this.getPropertyAsInt("PRENODEID", 0);
    }

    public FlowNode getPreNode() throws WCMException {
        return FlowNode.findById(this.getPreNodeId());
    }

    public boolean setPreNode(int n) throws WCMException {
        return this.setProperty("PRENODEID", n);
    }

    public boolean setPreNode(FlowNode flowNode) throws WCMException {
        if (flowNode != null && !flowNode.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label11", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowDoc.setPreNode\uff09"));
        }
        int n = flowNode == null ? 0 : flowNode.getId();
        return this.setProperty("PRENODEID", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label12", "\u5c5e\u6027OBJTYPE\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
            if (this.getProperty("OBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label13", "\u5c5e\u6027OBJID\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
            if (this.getProperty("NODEID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label14", "\u5c5e\u6027NodeId\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode()) {
            this.setCrTime();
            this.setPostTime(CMyDateTime.now());
            super.insert(user);
        }
    }

    public FlowDoc getPrevious(User user, boolean bl) throws WCMException {
        try {
            int n = bl && this.getFlag() == 2 ? this.getNodeId() : this.getPreNodeId();
            if (n <= 0) {
                return null;
            }
            String string = "ObjType=" + this.getContentType() + " and Objid=" + this.getContentId() + " and NODEID=" + n;
            FlowDocBaks flowDocBaks = new FlowDocBaks(user);
            flowDocBaks.open(new WCMFilter("", string, "FLOWDOCID desc"));
            return flowDocBaks.isEmpty() ? null : (FlowDoc)flowDocBaks.getAt(0);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label15", "\u53d6\u524d\u4e00\u4e2a\u6d41\u8f6c\u7ecf\u8fc7\u7684FlowDoc\u5bf9\u8c61\u5931\u8d25\uff08FlowDoc.getPrevious\uff09"), exception);
        }
    }

    public FlowNodeBranch getBranchComeFrom(User user) throws WCMException {
        try {
            FlowNode flowNode = this.getPreNode();
            if (flowNode == null) {
                return null;
            }
            FlowNode flowNode2 = this.getNode();
            if (flowNode2 == null) {
                return null;
            }
            return flowNode.getBranchTo(user, flowNode2);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label16", "\u83b7\u53d6\u7ecf\u8fc7\u7684\u5206\u652f\u5931\u8d25\uff08FlowDoc.getBranchComeFrom\uff09"), exception);
        }
    }

    public boolean isReceived() {
        CMyDateTime cMyDateTime = this.getPropertyAsDateTime("ReceiveTime");
        return cMyDateTime != null && !cMyDateTime.isNull();
    }

    public boolean setReceiveTime() throws WCMException {
        return this.setProperty("ReceiveTime", CMyDateTime.now());
    }

    public CMyDateTime getReceiveTime() {
        return this.getPropertyAsDateTime("ReceiveTime");
    }

    public boolean setAcceptTime() throws WCMException {
        return this.setProperty("AcceptTime", CMyDateTime.now());
    }

    public CMyDateTime getAcceptTime() {
        return this.getPropertyAsDateTime("AcceptTime");
    }

    public boolean isAccepted() {
        return this.getPropertyAsBoolean("Accepted", false);
    }

    public boolean setAccepted() throws WCMException {
        if (this.isAccepted()) {
            return false;
        }
        this.setProperty("Accepted", true);
        this.setAcceptTime();
        return true;
    }

    public static final FlowDoc findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FlowDoc)BaseObj.findById(FlowDoc.class, n);
    }

    public static final FlowDoc createNewInstance() throws WCMException {
        return (FlowDoc)BaseObj.createNewInstance(FlowDoc.class);
    }

    public static final FlowDoc findByKey(Object object) throws WCMException {
        return (FlowDoc)BaseObj.findByKey(FlowDoc.class, object);
    }

    public boolean setContent(int n, int n2) throws WCMException {
        return this.setContentType(n) && this.setContentId(n2);
    }

    public FlowDocs getChildren(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ParentId=?", "");
        wCMFilter2.addSearchValues(this.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return FlowDocs.openWCMObjs(user, wCMFilter2);
    }

    public void setContent(IFlowContent iFlowContent) throws WCMException {
        if (iFlowContent == null) {
            return;
        }
        this.setContent(iFlowContent.getType(), iFlowContent.getId());
    }

    public boolean setPreFlowDoc(FlowDoc flowDoc) throws WCMException {
        if (flowDoc == null) {
            return this.setPreFlowDoc(0);
        }
        return this.setPreFlowDoc(flowDoc.getId());
    }

    public long getSerialNum() {
        return this.getPropertyAsLong("SerialNum", 0L);
    }

    public boolean setSerialNum(long l) throws WCMException {
        return this.setProperty("SerialNum", l);
    }

    public long getBranchSerialNum() {
        return this.getPropertyAsLong("BranchSerialNum", 0L);
    }

    public boolean setBranchSerialNum(long l) throws WCMException {
        return this.setProperty("BranchSerialNum", l);
    }

    public String getToUserTrueNames() throws WCMException {
        if (this.getToUserId() > 0) {
            User user = this.getToUser();
            if (user == null) {
                return "\u672a\u77e5[" + this.getToUserId() + "]";
            }
            String string = user.getName();
            String string2 = user.getTrueName();
            if (string2 != null && !"".equals(string2)) {
                return string2;
            }
            return string;
        }
        if (this.getToUserIds() == "") {
            return "";
        }
        Users users = this.getToUsers(null);
        StringBuffer stringBuffer = null;
        int n = users.size();
        for (int i = 0; i < n; ++i) {
            User user = (User)users.getAt(i);
            if (user == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n * 7);
            } else {
                stringBuffer.append(',');
            }
            String string = user.getName();
            String string3 = user.getTrueName();
            if (string3 != null && !"".equals(string3)) {
                string = string3;
            }
            stringBuffer.append(string);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean setObjDeleted(boolean bl) throws WCMException {
        return this.setProperty("ISOBJDELETED", bl);
    }

    public boolean isObjDeleted() {
        return this.getPropertyAsBoolean("ISOBJDELETED", false);
    }
}

