/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.FlowRules;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FlowRuleCacheServerImpl
extends BaseServer
implements IFlowRuleCacheServer {
    private Map m_oHostRuleCache = null;

    public FlowRuleCacheServerImpl() {
        this.m_sAppName = I18NMessage.get(FlowRuleCacheServerImpl.class, "FlowRuleCacheServerImpl.label1", "\u5de5\u4f5c\u6d41\u89c4\u5219\u7f13\u5b58\u670d\u52a1\u5668");
    }

    protected void doShutdown() {
        if (this.m_oHostRuleCache == null) {
            return;
        }
        this.m_oHostRuleCache.clear();
        this.m_oHostRuleCache = null;
    }

    protected boolean doStart() throws WCMException {
        if (this.m_oHostRuleCache != null) {
            return true;
        }
        FlowRules flowRules = FlowRules.openWCMObjs(null, new WCMFilter("", "", "RuleOrder Desc"));
        this.m_oHostRuleCache = new HashMap(flowRules.size());
        int n = flowRules.size();
        for (int i = 0; i < n; ++i) {
            FlowRule flowRule = (FlowRule)flowRules.getAt(i);
            if (flowRule == null) continue;
            flowRule.getConditions(null);
            flowRule.getActions(null);
            this.putRuleInCache(flowRule);
        }
        return true;
    }

    private void putRuleInCache(FlowRule flowRule) {
        this.putRuleInHostCache(flowRule);
    }

    public FlowRule[] getRules(FlowNode flowNode, int n) {
        if (this.m_oHostRuleCache == null) {
            this.startup();
        }
        if (flowNode == null) {
            return null;
        }
        String string = flowNode.getWCMType() + "." + flowNode.getId() + "." + n;
        ArrayList arrayList = (ArrayList)this.m_oHostRuleCache.get(string);
        if (arrayList == null) {
            return null;
        }
        FlowRule[] flowRuleArray = new FlowRule[arrayList.size()];
        return arrayList.toArray(flowRuleArray);
    }

    private void putRuleInHostCache(FlowRule flowRule) {
        String string;
        ArrayList<FlowRule> arrayList;
        if (this.m_oHostRuleCache == null) {
            this.startup();
        }
        if ((arrayList = (ArrayList<FlowRule>)this.m_oHostRuleCache.get(string = flowRule.getHostType() + "." + flowRule.getHostId() + "." + flowRule.getType())) == null) {
            arrayList = new ArrayList<FlowRule>();
            this.m_oHostRuleCache.put(string, arrayList);
        }
        arrayList.add(flowRule);
    }

    private void removeRuleCacheOfHost(BaseObj baseObj) {
        if (this.m_oHostRuleCache == null) {
            this.startup();
        }
        for (int i = 0; i < ProcessConstants.RULE_TRIGGERS.length; ++i) {
            int n = ProcessConstants.RULE_TRIGGERS[i];
            String string = baseObj.getWCMType() + "." + baseObj.getId() + "." + n;
            ArrayList arrayList = (ArrayList)this.m_oHostRuleCache.get(string);
            if (arrayList == null) continue;
            this.m_oHostRuleCache.remove(string);
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                FlowRule flowRule = (FlowRule)arrayList.get(j);
                if (flowRule == null) continue;
                flowRule.clearCache();
            }
            arrayList.clear();
        }
    }

    public void reloadRuleCache(BaseObj baseObj) throws WCMException {
        this.removeRuleCache(baseObj);
        WCMFilter wCMFilter = new WCMFilter("", "HostType=? and HostId=?", "RuleOrder Desc");
        wCMFilter.addSearchValues(403);
        wCMFilter.addSearchValues(baseObj.getId());
        FlowRules flowRules = FlowRules.openWCMObjs(null, wCMFilter);
        int n = flowRules.size();
        for (int i = 0; i < n; ++i) {
            FlowRule flowRule = (FlowRule)flowRules.getAt(i);
            if (flowRule == null) continue;
            flowRule.getConditions(null);
            flowRule.getActions(null);
            this.putRuleInCache(flowRule);
        }
    }

    public void removeRuleCache(BaseObj baseObj) {
        this.removeRuleCacheOfHost(baseObj);
    }

    public FlowRule[] getRules(int n, int n2, int n3) throws WCMException {
        String string;
        ArrayList arrayList;
        if (this.m_oHostRuleCache == null) {
            this.startup();
        }
        if ((arrayList = (ArrayList)this.m_oHostRuleCache.get(string = n + "." + n2 + "." + n3)) == null) {
            return null;
        }
        FlowRule[] flowRuleArray = new FlowRule[arrayList.size()];
        return arrayList.toArray(flowRuleArray);
    }
}

