/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.OptMarkParseException;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FlowOptMarkEnumParser {
    private static Logger logger = Logger.getLogger(FlowOptMarkEnumParser.class);

    private FlowOptMarkEnumParser() {
    }

    public static String getFlowOptMarkEnum(Flow flow) throws WCMException {
        Object object;
        if (flow == null) {
            return null;
        }
        FlowNode flowNode = flow.getStartNode();
        FlowNode flowNode2 = flow.getEndNode();
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(flowNode.getName()).append(",");
        try {
            object = new ArrayList(4);
            stringBuffer.append(FlowOptMarkEnumParser.arrangeOptMarkEnum(flowNode, object)).append(",");
            object.clear();
            object = null;
        }
        catch (OptMarkParseException optMarkParseException) {
            logger.warn((Object)(I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label1", "\u89e3\u6790\u5de5\u4f5c\u6d41\u7684\u64cd\u4f5c\u6807\u7b7e\u65f6[ID=") + flow.getId() + " " + flow.getName() + I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label2", "]\u51fa\u73b0\u95ee\u9898\u3002") + optMarkParseException.getMessage()));
            return null;
        }
        stringBuffer.append(flowNode2.getName());
        stringBuffer.append("}");
        object = stringBuffer.toString();
        stringBuffer.setLength(0);
        return object;
    }

    private static String arrangeOptMarkEnum(FlowNode flowNode, List list) throws WCMException {
        if (flowNode == null || flowNode.isEndNode()) {
            return null;
        }
        if (list.contains(flowNode.getName())) {
            return null;
        }
        list.add(flowNode.getName());
        FlowNodeBranchs flowNodeBranchs = flowNode.getBranchs(FlowOptMarkEnumParser.getLoginUser());
        int n = flowNodeBranchs.size();
        if (n == 0) {
            throw new OptMarkParseException(I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label3", "\u8282\u70b9[") + flowNode.getName() + I18NMessage.get(FlowOptMarkEnumParser.class, "FlowOptMarkEnumParser.label4", "]\u6ca1\u6709\u5b9a\u4e49\u4efb\u4f55\u652f\u8def\uff01"));
        }
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            FlowNodeBranch flowNodeBranch = (FlowNodeBranch)flowNodeBranchs.getAt(i);
            FlowNode flowNode2 = flowNodeBranch.getNode();
            String string2 = "";
            if (!flowNodeBranch.isOperationMarkEnable()) {
                string2 = FlowOptMarkEnumParser.arrangeOptMarkEnum(flowNodeBranch.getNextNode(FlowOptMarkEnumParser.getLoginUser()), list);
            } else {
                string2 = flowNodeBranch.getOperationMark();
                if (flowNode2 != null) {
                    FlowNode flowNode3 = flowNodeBranch.getNextNode(FlowOptMarkEnumParser.getLoginUser());
                    String string3 = null;
                    if (flowNode3 != null && (string3 = FlowOptMarkEnumParser.arrangeOptMarkEnum(flowNode3, list)) != null) {
                        string2 = string2 + (string2 == null ? string3 : "," + string3);
                    }
                }
            }
            if (CMyString.isEmpty(string2)) continue;
            if (n > 1) {
                string2 = "{" + string2 + "}";
            }
            arrayList.add(string2);
        }
        string = n == 1 ? CMyString.join(arrayList, ",") : "[" + CMyString.join(arrayList, ",") + "]";
        return string;
    }

    private static User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

