/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyBitsValue;

public class FlowNodeBranch
extends CMSObj {
    public static final int OBJ_TYPE = 404;
    public static final String DB_TABLE_NAME = "WCMFLOWBRANCH";
    public static final String DB_ID_NAME = "BRANCHID";
    private FlowNode nextNode = null;
    private boolean bNextNodeLoaded = false;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 404;
    }

    public int getNodeId() {
        return this.getPropertyAsInt("NODEID", 0);
    }

    public FlowNode getNode() throws WCMException {
        return FlowNode.findById(this.getNodeId());
    }

    public boolean setNode(FlowNode flowNode) throws WCMException {
        if (flowNode == null || flowNode.getId() <= 0) {
            throw new WCMException(1100, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label1", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowNodeBranch.setNode\uff09"));
        }
        return this.setNode(flowNode.getId());
    }

    public boolean setNode(int n) throws WCMException {
        return this.setProperty("NodeId", n);
    }

    public String getNextNodeName() {
        return (String)this.getProperty("NextName");
    }

    public boolean setNextNodeName(String string) throws WCMException {
        return this.setPropertyWithString("NextName", string);
    }

    public int getStatusId() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    public Status getStatus() throws WCMException {
        return Status.findById(this.getStatusId());
    }

    public boolean setStatus(int n) throws WCMException {
        Status status = Status.findById(n);
        return this.setStatus(status);
    }

    public boolean setStatus(Status status) throws WCMException {
        if (status == null || !status.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label2", "\u65e0\u6548\u7684Status\u5bf9\u8c61\uff08FlowNodeBranch.setStatus\uff09"));
        }
        return this.setProperty("STATUS", status.getId());
    }

    public int getNotify() {
        return this.getPropertyAsInt("NOTIFY", 0);
    }

    public String getNotifyTypes() {
        return this.convertToMsgTypes(this.getNotify());
    }

    public boolean setNotify(long l) throws WCMException {
        return this.setProperty("NOTIFY", new Long(l).intValue());
    }

    public boolean isNotifyBy(int n) {
        return CMyBitsValue.getBit(this.getNotify(), n);
    }

    public boolean setNotifyBy(int n, boolean bl) throws WCMException {
        Number number = (Number)this.getNewProperty("NOTIFY");
        long l = number != null ? number.intValue() : this.getNotify();
        l = CMyBitsValue.setBit(l, n, bl);
        return this.setNotify(l);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("NODEID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label3", "\u5c5e\u6027NodeId\u6ca1\u6709\u8bbe\u7f6e(FlowNodeBranch.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FlowNodeBranch.class, "FlowNodeBranch.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FlowNodeBranch.isValid)"));
        }
        return true;
    }

    public synchronized void update(User user) throws WCMException {
        String string;
        boolean bl = false;
        String string2 = (String)this.getNewProperty("NEXTNAME");
        if (string2 != null && string2.compareTo(string = this.getNextNodeName()) != 0) {
            bl = true;
        }
        super.update(user);
        if (bl && this.bNextNodeLoaded) {
            this.bNextNodeLoaded = false;
            this.nextNode = null;
        }
    }

    public synchronized FlowNode getNextNode(User user) throws WCMException {
        if (!this.bNextNodeLoaded) {
            FlowNode flowNode = this.getNode();
            IFlowServer iFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            this.nextNode = flowNode != null && iFlowServer != null ? FlowNode.findByName(flowNode.getFlowId(), this.getNextNodeName()) : null;
            this.bNextNodeLoaded = true;
        }
        return this.nextNode;
    }

    private String convertToMsgTypes(int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (CMyBitsValue.getBitOfInt(n, 1)) {
            stringBuffer.append(',').append("Email");
        }
        if (CMyBitsValue.getBitOfInt(n, 2)) {
            stringBuffer.append(',').append("SMS");
        }
        if (CMyBitsValue.getBitOfInt(n, 0)) {
            stringBuffer.append(',').append("Message");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return "Message";
    }

    public String getName() {
        return this.getPropertyAsString("BName");
    }

    public String getOperationMark() {
        return this.getPropertyAsString("OperationMark");
    }

    public boolean isOperationMarkEnable() {
        return this.getPropertyAsBoolean("OperationMarkEnable", false);
    }
}

