/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowCacheMgr;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;

public class FlowNode
extends CMSObj {
    public static final int OBJ_TYPE = 403;
    public static final String DB_TABLE_NAME = "WCMFLOWNODE";
    public static final String DB_ID_NAME = "NODEID";
    public static final int ACTION_EDIT = 0;
    public static final int ACTION_DELETE = 1;
    public static final int ACTION_PUBLISH = 2;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 403;
    }

    public int getFlowId() {
        return this.getPropertyAsInt("FLOWID", 0);
    }

    public Flow getFlow() throws WCMException {
        return Flow.findById(this.getFlowId());
    }

    public boolean setFlow(int n) throws WCMException {
        return this.setFlow(Flow.findById(n));
    }

    public boolean setFlow(Flow flow) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(FlowNode.class, "FlowNode.label1", "\u5de5\u4f5c\u6d41\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539(FlowNode.setFlow)"));
        }
        if (flow == null || flow.getId() <= 0) {
            throw new WCMException(10, I18NMessage.get(FlowNode.class, "FlowNode.label2", "\u65e0\u6548\u7684\u5de5\u4f5c\u6d41\u5bf9\u8c61(FlowNode.setFlow)"));
        }
        return this.setProperty("FLOWID", flow.getId());
    }

    public String getName() {
        return this.getPropertyAsString("NODENAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("NODENAME", string);
    }

    public String getDesc() {
        return this.getPropertyAsString("NODEDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("NODEDESC", string);
    }

    public int getCenterX() {
        return this.getPropertyAsInt("CENTERX", 0);
    }

    public boolean setCeneterX(int n) throws WCMException {
        return this.setProperty("CENTERX", n);
    }

    public int getCenterY() {
        return this.getPropertyAsInt("CENTERY", 0);
    }

    public boolean setCeneterY(int n) throws WCMException {
        return this.setProperty("CENTERY", n);
    }

    public int getDocActionsAsInt() {
        return this.getPropertyAsInt("ACTIONS", 0);
    }

    public CMyBitsValue getDocActions() {
        return new CMyBitsValue(this.getDocActionsAsInt());
    }

    public boolean isCanDoWithDoc(int n) {
        if (n >= 31 || n < 0) {
            return false;
        }
        return CMyBitsValue.getBit(this.getDocActionsAsInt(), n);
    }

    public boolean setDocActions(int n) throws WCMException {
        return this.setProperty("ACTIONS", n);
    }

    public boolean setDocActions(int n, boolean bl) throws WCMException {
        int n2 = -1;
        try {
            Number number;
            if (!this.isAddMode() && (number = (Number)this.getNewProperty("ACTIONS")) != null) {
                n2 = number.intValue();
            }
            if (n2 < 0) {
                n2 = this.getDocActionsAsInt();
            }
            n2 = (int)CMyBitsValue.setBit(n2, n, bl);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label3", "\u5904\u7406\u6587\u6863\u64cd\u4f5c\u8bbe\u7f6e\u65f6\u5931\u8d25\uff08FlowNode.setDocActions\uff09"), exception);
        }
        return this.setDocActions(n2);
    }

    public boolean canDelDoc() {
        return this.isCanDoWithDoc(1);
    }

    public boolean canEditDoc() {
        return this.isCanDoWithDoc(0);
    }

    public boolean canPubDoc() {
        return this.isCanDoWithDoc(2);
    }

    public boolean isNeedPostTogether() {
        return this.getPropertyAsBoolean("TOGETHER", false);
    }

    public boolean setNeedPostTogether(boolean bl) throws WCMException {
        return this.setProperty("TOGETHER", bl);
    }

    public boolean isBReasignUsers() {
        return this.getPropertyAsBoolean("BREASIGNUSERS", false);
    }

    public boolean setReasignSepNodes(boolean bl) throws WCMException {
        return this.setProperty("BREASIGNSEPNODES", bl);
    }

    public boolean isBReasignSepNodes() {
        return this.getPropertyAsBoolean("BREASIGNSEPNODES", false);
    }

    public boolean setReasignUsers(boolean bl) throws WCMException {
        return this.setProperty("BREASIGNUSERS", bl);
    }

    public int getWorkModal() {
        if (this.isNeedPostTogether()) {
            return 1;
        }
        return this.getPropertyAsInt("WorkModal", 0);
    }

    public boolean setWorkModal(int n) throws WCMException {
        return this.setProperty("WorkModal", n);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getProperty("NODENAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNode.class, "FlowNode.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(FlowNode.isValid)"));
            }
            if (this.getProperty("FLOWID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowNode.class, "FlowNode.label5", "\u5c5e\u6027FlowId\u6ca1\u6709\u8bbe\u7f6e(FlowNode.isValid)"));
            }
        }
        if (string != null) {
            String string2 = "(FlowId=" + this.getFlowId() + " and NODENAME='" + CMyString.filterForSQL(string) + "')";
            if (!this.isAddMode()) {
                string2 = string2 + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(FlowNode.class, "FlowNode.label6", "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728(FlowNode.isValid)"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode()) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public int delete(User user) throws WCMException {
        Object object;
        try {
            object = new String[]{"delete  from wcmFlowNodeOper where  NodeId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate((String[])object);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label7", "\u5220\u9664\u8282\u70b9\u4e0a\u7684\u64cd\u4f5c\u8005\u5931\u8d25\uff08FlowNode.delete\uff09"), exception);
        }
        try {
            object = this.getBranchs(user);
            ((BaseObjs)object).removeAll();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label8", "\u5220\u9664\u8282\u70b9\u76f8\u5173\u7684\u5206\u652f\u5931\u8d25\uff08FlowNode.delete"), exception);
        }
        return super.delete(user);
    }

    public boolean isStartNode() throws WCMException {
        try {
            Flow flow = this.getFlow();
            if (flow == null) {
                return false;
            }
            String string = this.getName();
            if (string == null) {
                return false;
            }
            return string.compareTo(flow.getStartNodeName()) == 0;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label10", "\u5224\u5b9a\u8d77\u59cb\u8282\u70b9\u5931\u8d25\uff08FlowNode.isStartNode\uff09"), exception);
        }
    }

    public boolean isEndNode() throws WCMException {
        try {
            Flow flow = this.getFlow();
            if (flow == null) {
                return false;
            }
            String string = this.getName();
            if (string == null) {
                return false;
            }
            return string.compareTo(flow.getEndNodeName()) == 0;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label11", "\u5224\u5b9a\u7ed3\u675f\u8282\u70b9\u5931\u8d25\uff08FlowNode.isEndNode\uff09"), exception);
        }
    }

    public Users getOperUsers(User user) throws WCMException {
        return this.getOperUsers(user, false);
    }

    public Users getOperUsers(User user, boolean bl) throws WCMException {
        return this.getOperUsers(user, bl, "", "", "");
    }

    public Users getOperUsers(User user, boolean bl, String string, String string2, String string3) throws WCMException {
        Users users = null;
        try {
            String string4 = "wcmFlowNodeOper.OperType=204 and  wcmFlowNodeOper.NodeId=" + this.getId();
            if (string2 != null && string2.length() > 1) {
                string4 = "(" + string4 + ") and (" + string2 + " and wcmFlowNodeOper.OPERID = wcmUser.UserId)";
            }
            String string5 = "wcmFlowNodeOper";
            if (string != null && string.length() > 1) {
                string5 = string5 + "," + string;
            }
            WCMFilter wCMFilter = new WCMFilter(string5, string4, string3, "distinct wcmFlowNodeOper.OPERID as USERID");
            users = new Users(user);
            users.open(wCMFilter);
            if (!bl) {
                return users;
            }
            string4 = "wcmGrpUser.GroupId = wcmFlowNodeOper.OPERID and wcmFlowNodeOper.OperType = 201 and  wcmFlowNodeOper.NodeId = " + this.getId();
            if (string2 != null && string2.length() > 1) {
                string4 = "(" + string4 + ") and (" + string2 + " and wcmGrpUser.UserId = wcmUser.UserId)";
            }
            string5 = "wcmFlowNodeOper,wcmGrpUser";
            if (string != null && string.length() > 1) {
                string5 = string5 + "," + string;
            }
            wCMFilter = new WCMFilter(string5, string4, string3, "distinct wcmGrpUser.USERID");
            Users users2 = new Users(user);
            users2.open(wCMFilter);
            users2.addWith(users);
            String string6 = users2.getIdListAsString();
            if (CMyString.isEmpty(string6)) {
                return users2;
            }
            WCMFilter wCMFilter2 = new WCMFilter("", "IsDeleted=0 and Status=30 and UserId in (" + string6 + ")", "");
            users2 = new Users(user);
            users2.open(wCMFilter2);
            return users2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label12", "\u53d6\u5de5\u4f5c\u6d41\u8282\u70b9\u7684\u64cd\u4f5c\u7528\u6237\u96c6\u5408\u5931\u8d25(FlowNode.getOperUsers)"), exception);
        }
    }

    public Groups getOperGroups(User user) throws WCMException {
        Groups groups = null;
        try {
            WCMFilter wCMFilter = new WCMFilter("wcmFlowNodeOper", "OperType=201 and  NodeId=" + this.getId(), "", "OPERID as GROUPID");
            groups = new Groups(user);
            groups.open(wCMFilter);
            return groups;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label13", "\u53d6\u5de5\u4f5c\u6d41\u8282\u70b9\u7684\u64cd\u4f5c\u7528\u6237\u7ec4\u96c6\u5408\u5931\u8d25(FlowNode.getOperGroups)"), exception);
        }
    }

    public FlowNodeBranchs getBranchs(User user) throws WCMException {
        FlowNodeBranchs flowNodeBranchs = null;
        try {
            WCMFilter wCMFilter = new WCMFilter("", "NodeId=" + this.getId(), "");
            flowNodeBranchs = new FlowNodeBranchs(user);
            flowNodeBranchs.open(wCMFilter);
            return flowNodeBranchs;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label14", "\u53d6\u5f97\u5de5\u4f5c\u6d41\u8282\u70b9\u4e0a\u7684\u5206\u652f\u96c6\u5408\u65f6\u51fa\u9519\uff08FlowNode.getBranchs\uff09"), wCMException);
        }
    }

    public FlowNodeBranch getBranchTo(User user, FlowNode flowNode) throws WCMException {
        if (flowNode == null) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "(NodeId=? and NextName=?) or (NodeId=? and NextName=?)", "");
        wCMFilter.addSearchValues(this.getId());
        wCMFilter.addSearchValues(flowNode.getName());
        wCMFilter.addSearchValues(flowNode.getId());
        wCMFilter.addSearchValues(this.getName());
        FlowNodeBranchs flowNodeBranchs = new FlowNodeBranchs(user, 1, 1);
        flowNodeBranchs.open(wCMFilter);
        return flowNodeBranchs.isEmpty() ? null : (FlowNodeBranch)flowNodeBranchs.getAt(0);
    }

    public FlowNodes getNextNodes(User user) throws WCMException {
        try {
            String string = "(WCMFlowNode.FlowId=" + this.getFlowId() + ") and (WCMFlowBranch.NodeId=" + this.getId() + ") and (WCMFlowNode.NodeName=WCMFlowBranch.NextName)";
            WCMFilter wCMFilter = new WCMFilter("WCMFlowNode,WCMFlowBranch", string, "", "distinct WCMFlowNode.NodeId");
            FlowNodes flowNodes = new FlowNodes(user);
            flowNodes.open(wCMFilter);
            return flowNodes;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label15", "\u53d6\u4e0b\u4e00\u4e2a\u6d41\u8f6c\u8282\u70b9\u96c6\u5408\uff08FlowNode.getNextNodes\uff09"), exception);
        }
    }

    public FlowNodes getNextNodes(User user, WCMFilter wCMFilter) throws WCMException {
        try {
            String string = "(WCMFlowNode.FlowId=" + this.getFlowId() + ") and (WCMFlowBranch.NodeId=" + this.getId() + ") and (WCMFlowNode.NodeName=WCMFlowBranch.NextName)";
            WCMFilter wCMFilter2 = new WCMFilter("WCMFlowNode,WCMFlowBranch", string, "", "distinct WCMFlowNode.NodeId");
            wCMFilter2.mergeWith(wCMFilter);
            FlowNodes flowNodes = new FlowNodes(user);
            flowNodes.open(wCMFilter2);
            return flowNodes;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowNode.class, "FlowNode.label15", "\u53d6\u4e0b\u4e00\u4e2a\u6d41\u8f6c\u8282\u70b9\u96c6\u5408\uff08FlowNode.getNextNodes\uff09"), exception);
        }
    }

    public boolean isToFirst() {
        return this.getPropertyAsInt("TOFIRST", 0) == 1;
    }

    public void setToFirst(boolean bl) throws WCMException {
        this.setProperty("TOFIRST", bl);
    }

    public static final FlowNode findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FlowNode)BaseObj.findById(FlowNode.class, n);
    }

    public static final FlowNode createNewInstance() throws WCMException {
        return (FlowNode)BaseObj.createNewInstance(FlowNode.class);
    }

    public static final FlowNode findByKey(Object object) throws WCMException {
        return (FlowNode)BaseObj.findByKey(FlowNode.class, object);
    }

    public static FlowNode findByName(int n, String string) throws WCMException {
        return FlowNode.getFlowCacheMgr().findFlowNodeByName(n, string);
    }

    protected static IFlowCacheMgr getFlowCacheMgr() throws WCMException {
        IFlowCacheMgr iFlowCacheMgr = (IFlowCacheMgr)DreamFactory.createObjectById("IFlowCacheMgr");
        if (iFlowCacheMgr == null) {
            throw new WCMException(I18NMessage.get(FlowNode.class, "FlowNode.label16", "IFlowCacheMgr\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u914d\u7f6e\uff01"));
        }
        return iFlowCacheMgr;
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(FlowNode.class, "FlowNode.label17", "[\u8282\u70b9-") + this.getId() + "]";
    }
}

