/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class FlowEmploy
extends CMSObj {
    public static final int OBJ_TYPE = 30001;
    public static final String DB_TABLE_NAME = "WCMFLOWEMPLOY";
    public static final String DB_ID_NAME = "FLOWEMPLOYID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 30001;
    }

    public int getEmployerType() {
        return this.getPropertyAsInt("EMPLOYERTYPE", 0);
    }

    public int getEmployerId() {
        return this.getPropertyAsInt("EMPLOYERID", 0);
    }

    public BaseObj getEmployer() throws Exception {
        return BaseObj.findById(this.getEmployerType(), this.getEmployerId());
    }

    public boolean setEmployer(int n, int n2) throws WCMException {
        return this.setProperty("EMPLOYERTYPE", n) && this.setProperty("EMPLOYERID", n2);
    }

    public boolean setEmployer(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, "Valid employer required!");
        }
        return this.setEmployer(baseObj.getWCMType(), baseObj.getId());
    }

    public int getFlowId() {
        return this.getPropertyAsInt("FLOWID", 0);
    }

    public Flow getFlow() throws WCMException {
        return Flow.findById(this.getFlowId());
    }

    public boolean setFlow(int n) throws WCMException {
        return this.setProperty("FLOWID", n);
    }

    public boolean setFlow(Flow flow) throws WCMException {
        if (flow == null) {
            throw new WCMException(10, "Valid flow required!");
        }
        return this.setFlow(flow.getId());
    }

    public int getFlowType() {
        return this.getPropertyAsInt("FLOWTYPE", 0);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("EMPLOYERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowEmploy.class, "FlowEmploy.label1", "\u5c5e\u6027EmployerType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("EMPLOYERID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowEmploy.class, "FlowEmploy.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FLOWID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowEmploy.class, "FlowEmploy.label3", "\u5c5e\u6027FlowId\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FlowEmploy.class, "FlowEmploy.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public static final FlowEmploy findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FlowEmploy)BaseObj.findById(FlowEmploy.class, n);
    }

    public static final FlowEmploy createNewInstance() throws WCMException {
        return (FlowEmploy)BaseObj.createNewInstance(FlowEmploy.class);
    }

    public static final FlowEmploy findByKey(Object object) throws WCMException {
        return (FlowEmploy)BaseObj.findByKey(FlowEmploy.class, object);
    }
}

