/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowCacheMgr;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;

public class FlowCacheMgr
implements ICacheMgr,
IFlowCacheMgr {
    private HashMap m_hmFlowNodeNameCache = null;

    public boolean init() throws WCMException {
        this.initFlowNodeNameCache();
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        this.clearFlowNodeNameCache();
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (baseObj instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseObj;
            this.putFlowNodeName(flowNode, this.getFlowNodeNameCache());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseObj;
            this.removeFlowNodeName(flowNode);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseObj;
            if (baseObj.isChangeProperty("NODENAME")) {
                this.getFlowNodeNameCache().put(this.makeFlowNodeNameKey(flowNode.getFlowId(), flowNode.getNewPropertyAsString("NODENAME")), flowNode);
            }
        }
    }

    protected HashMap getFlowNodeNameCache() throws WCMException {
        if (this.m_hmFlowNodeNameCache == null) {
            this.initFlowNodeNameCache();
        }
        return this.m_hmFlowNodeNameCache;
    }

    private synchronized void clearFlowNodeNameCache() {
        if (this.m_hmFlowNodeNameCache == null) {
            return;
        }
        this.m_hmFlowNodeNameCache.clear();
        this.m_hmFlowNodeNameCache = null;
    }

    private synchronized void initFlowNodeNameCache() throws WCMException {
        if (this.m_hmFlowNodeNameCache != null) {
            return;
        }
        FlowNodes flowNodes = FlowNodes.openWCMObjs(User.getSystem(), null);
        HashMap hashMap = new HashMap(flowNodes.size());
        for (int i = 0; i < flowNodes.size(); ++i) {
            FlowNode flowNode = (FlowNode)flowNodes.getAt(i);
            if (flowNode == null) continue;
            this.putFlowNodeName(flowNode, hashMap);
        }
        this.m_hmFlowNodeNameCache = hashMap;
    }

    private void putFlowNodeName(FlowNode flowNode, HashMap hashMap) {
        hashMap.put(this.makeFlowNodeNameKey(flowNode), flowNode);
    }

    private void removeFlowNodeName(FlowNode flowNode) throws WCMException {
        this.getFlowNodeNameCache().remove(this.makeFlowNodeNameKey(flowNode));
    }

    private String makeFlowNodeNameKey(FlowNode flowNode) {
        return this.makeFlowNodeNameKey(flowNode.getFlowId(), flowNode.getName());
    }

    private String makeFlowNodeNameKey(int n, String string) {
        return n + "." + string;
    }

    public FlowNode findFlowNodeByName(int n, String string) throws WCMException {
        return (FlowNode)this.getFlowNodeNameCache().get(this.makeFlowNodeNameKey(n, string));
    }
}

