/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MailContentHelper {
    private static final String MAIL_TEMPLATE = "/TRSEmail.htm";
    private static Logger logger = Logger.getLogger(MailContentHelper.class);
    private static String s_sMailTemplate = null;

    public static String makeEmailContent(Map map) throws Exception {
        if (s_sMailTemplate == null) {
            MailContentHelper.initEmailContent();
        }
        return MailContentHelper.parsePageVariables(s_sMailTemplate, map);
    }

    private static String parsePageVariables(String string, Map map) throws WCMException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        try {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            stringBuffer = new StringBuffer();
            while (n2 < cArray.length) {
                char c;
                if ((c = cArray[n2++]) == '$' && n2 < n && cArray[n2] == '{') {
                    StringBuffer stringBuffer2 = new StringBuffer(16);
                    ++n2;
                    int n3 = 0;
                    boolean bl = false;
                    while (n3++ < 20 && n2 < n) {
                        if ((c = cArray[n2++]) == '}') {
                            bl = true;
                            break;
                        }
                        stringBuffer2.append(c);
                    }
                    if (bl) {
                        String string2 = stringBuffer2.toString().toUpperCase();
                        String string3 = (String)map.get(string2);
                        if (string3 != null) {
                            stringBuffer.append(string3);
                            continue;
                        }
                        stringBuffer.append("${").append(stringBuffer2).append('}');
                        continue;
                    }
                    stringBuffer.append("${").append(stringBuffer2);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label1", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), exception);
        }
    }

    private static synchronized void initEmailContent() throws Exception {
        if (s_sMailTemplate != null) {
            return;
        }
        MailContentHelper.initEmailTemplate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initEmailTemplate() throws Exception {
        Class<MailContentHelper> clazz = MailContentHelper.class;
        InputStream inputStream = clazz.getResourceAsStream(MAIL_TEMPLATE);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(MAIL_TEMPLATE.substring(1));
        }
        if (inputStream == null) {
            logger.error((Object)I18NMessage.get(MailContentHelper.class, "MailContentHelper.label2", "\u6307\u5b9a\u7684\u6a21\u677f\u6587\u4ef6[TRSEmail.htm]\u4e0d\u5b58\u5728\uff01"));
            s_sMailTemplate = "System mail Server Error!";
            return;
        }
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "GBK");
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer(256);
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string).append('\n');
                string = bufferedReader.readLine();
            }
            s_sMailTemplate = stringBuffer.toString();
        }
        catch (Exception exception) {
            s_sMailTemplate = "System mail Server Error!";
            logger.error((Object)"init template fail", (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String readFile(URL uRL) throws CMyException {
        InputStreamReader inputStreamReader = null;
        StringBuffer stringBuffer = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "GBK"));
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string);
            }
            String string2 = stringBuffer == null ? "" : stringBuffer.toString();
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CMyException(55, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CMyException(53, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), iOException);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("to_user".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label5", "\u9646\u68da"));
        hashMap.put("content".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label6", "\u6d4b\u8bd5\u4e00\u4e0b"));
        hashMap.put("from_user".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label7", "\u66f9\u8f89"));
        try {
            System.out.println(MailContentHelper.makeEmailContent(hashMap));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

