/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowingDocLogger;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.process.element.FlowContentDocumentImpl;
import com.trs.infra.common.WCMException;

public class FlowingDocOptMarkScouter {
    public static final String FLOWING_DOC_OPT_MARK = "FLOWOPERATIONMARK";
    public static final String FLOWING_DOC_PRE_OPT_MARK = "FLOWPREOPERATIONMARK";
    public static final String FLOWING_DOC_OPT_MARK_ENUM = "FLOWOPERATIONMASKENUM";
    public static final String MARK_FORCE_END = "RESERVED_FORCED_END";
    public static final String IFLOWCONTENT_APPLYFORM_CLASSNAME = "com.trs.components.wcm.process.element.FlowContentApplyFormImpl";

    private FlowingDocOptMarkScouter() {
    }

    public static void updateOperationMark(FlowContext flowContext) throws WCMException {
        FlowingDocOptMarkScouter.updateOperationMark(flowContext, null, true);
    }

    public static void updateOperationMark(FlowContext flowContext, String string) throws WCMException {
        FlowingDocOptMarkScouter.updateOperationMark(flowContext, string, true);
    }

    private static void updateOperationMark(FlowContext flowContext, String string, boolean bl) throws WCMException {
        IFlowContent iFlowContent = flowContext.getFlowContent();
        if (iFlowContent == null) {
            return;
        }
        FlowingDocLogger.info(flowContext, string);
        if (iFlowContent instanceof FlowContentDocumentImpl) {
            FlowingDocOptMarkScouter.saveDocumentOperationMark(flowContext, string, iFlowContent, bl);
        } else if (iFlowContent.getClass().getName().equals(IFLOWCONTENT_APPLYFORM_CLASSNAME)) {
            FlowingDocOptMarkScouter.saveCMSObjOperationMark(flowContext, string, iFlowContent, bl);
        }
    }

    private static void saveDocumentOperationMark(FlowContext flowContext, String string, IFlowContent iFlowContent, boolean bl) throws WCMException {
        Flow flow;
        Document document = ((FlowContentDocumentImpl)iFlowContent).getDocument();
        if (document == null) {
            return;
        }
        String string2 = string;
        if (bl) {
            if (string2 == null) {
                FlowNodeBranch flowNodeBranch = flowContext.getBranch();
                if (flowNodeBranch == null || !flowNodeBranch.isOperationMarkEnable()) {
                    return;
                }
                string2 = flowNodeBranch.getOperationMark();
            }
            if (string2 == null) {
                return;
            }
        }
        boolean bl2 = false;
        Document document2 = Document.findById(document.getId());
        User user = ContextHelper.getLoginUser();
        if (bl) {
            if (document2.getProperty(FLOWING_DOC_OPT_MARK) == null || document2.getProperty(FLOWING_DOC_OPT_MARK) != null && !document2.getProperty(FLOWING_DOC_OPT_MARK).equals(string2)) {
                bl2 = true;
                document2.setProperty(FLOWING_DOC_OPT_MARK, string2);
            }
        } else if (document2.getProperty(FLOWING_DOC_OPT_MARK) == null || document2.getProperty(FLOWING_DOC_OPT_MARK) != null && !document2.getProperty(FLOWING_DOC_OPT_MARK).equals(string2)) {
            bl2 = true;
            document2.setProperty(FLOWING_DOC_PRE_OPT_MARK, string2);
        }
        if ((flow = flowContext.getCurrFlow()) != null && (document2.getProperty(FLOWING_DOC_OPT_MARK_ENUM) == null || document2.getProperty(FLOWING_DOC_OPT_MARK_ENUM) != null && !document2.getProperty(FLOWING_DOC_OPT_MARK_ENUM).equals(flow.getProperty("OperationMarkEnum")))) {
            bl2 = true;
            document2.setProperty(FLOWING_DOC_OPT_MARK_ENUM, flow.getProperty("OperationMarkEnum"));
        }
        if (bl2 && document2.canEdit(user)) {
            document2.save(user);
        }
    }

    private static void saveCMSObjOperationMark(FlowContext flowContext, String string, IFlowContent iFlowContent, boolean bl) throws WCMException {
        CMSObj cMSObj;
        CMSObj cMSObj2 = iFlowContent.getSubinstance();
        if (cMSObj2 == null) {
            return;
        }
        String string2 = string;
        if (bl) {
            if (string2 == null) {
                cMSObj = flowContext.getBranch();
                if (cMSObj == null || !((FlowNodeBranch)cMSObj).isOperationMarkEnable()) {
                    return;
                }
                string2 = ((FlowNodeBranch)cMSObj).getOperationMark();
            }
            if (string2 == null) {
                return;
            }
        }
        cMSObj = (CMSObj)CMSObj.findById(cMSObj2.getWCMType(), cMSObj2.getId());
        User user = ContextHelper.getLoginUser();
        cMSObj.canEdit(user);
        if (bl) {
            cMSObj.setProperty(FLOWING_DOC_OPT_MARK, string2);
        } else {
            cMSObj.setProperty(FLOWING_DOC_PRE_OPT_MARK, string2);
        }
        Flow flow = flowContext.getCurrFlow();
        if (flow != null) {
            cMSObj.setProperty(FLOWING_DOC_OPT_MARK_ENUM, flow.getProperty("OperationMarkEnum"));
        }
        cMSObj.save(user);
    }

    public static void updatePreOperationMark(FlowContext flowContext, String string) throws WCMException {
        if (string == null) {
            return;
        }
        FlowingDocOptMarkScouter.updateOperationMark(flowContext, string, false);
    }
}

