/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.FlowContentTypeConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class FlowContentFactory {
    private static Logger logger = Logger.getLogger(FlowContentFactory.class);

    public static IFlowContent makeFlowContent(int n, int n2) throws WCMException {
        FlowConfigServer flowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        FlowContentTypeConfig flowContentTypeConfig = flowConfigServer.findContentTypeConfig(n);
        if (flowContentTypeConfig == null) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label1", "\u6307\u5b9a\u7684\u7c7b\u578b\u4e0d\u662f\u53ef\u4ee5\u6d41\u8f6c\u7684\u5185\u5bb9\uff01[Type=") + n + "]");
        }
        try {
            IFlowContent iFlowContent = (IFlowContent)flowContentTypeConfig.getContentClass().newInstance();
            iFlowContent.loadById(n2);
            return iFlowContent;
        }
        catch (Exception exception) {
            logger.warn((Object)(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label2", "\u8f7d\u5165\u6d41\u8f6c\u5185\u5bb9\u5931\u8d25\uff01[Type=") + n + ",Id=" + n2 + I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label3", "], \u539f\u56e0\u4e3a\uff1a") + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    public static IFlowContent makeFlowContent(CMSObj cMSObj) throws WCMException {
        FlowConfigServer flowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        FlowContentTypeConfig flowContentTypeConfig = flowConfigServer.findContentTypeConfig(cMSObj.getWCMType());
        if (flowContentTypeConfig == null) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label1", "\u6307\u5b9a\u7684\u7c7b\u578b\u4e0d\u662f\u53ef\u4ee5\u6d41\u8f6c\u7684\u5185\u5bb9\uff01[Type=") + cMSObj.getWCMType() + ", ObjectInfo=" + cMSObj + "]");
        }
        try {
            IFlowContent iFlowContent = (IFlowContent)flowContentTypeConfig.getContentClass().newInstance();
            iFlowContent.makeFrom(cMSObj);
            return iFlowContent;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label2", "\u8f7d\u5165\u6d41\u8f6c\u5185\u5bb9\u5931\u8d25\uff01[Type=") + cMSObj.getWCMType() + ",Id=" + cMSObj.getId() + ", ObjectInfo=" + cMSObj + "]", exception);
        }
    }
}

