/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.cms.logger.IObjLogger;
import com.trs.cms.logger.LogInfo;
import com.trs.cms.logger.OperTypeHelper;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import java.util.Iterator;
import java.util.Map;

public abstract class ObjLoggerBase
implements IObjLogger {
    protected static final int LINE_MAX_LEN = 100;

    public LogInfo makeLogOnAdd(BaseObj baseObj) {
        String string = this.makeName(baseObj);
        return new LogInfo(this.getAddOpType(baseObj), string, "\u65b0\u5efa" + string);
    }

    protected String makeName(BaseObj baseObj) {
        String string = this.getObjName(baseObj);
        if (string == null) {
            string = baseObj.toString();
        }
        if (string.indexOf(91) == -1) {
            String string2 = WCMTypes.getObjName(baseObj.getWCMType(), true);
            if ("\u672a\u77e5".equals(string2) || "unknown".equals(string2.toLowerCase())) {
                string2 = baseObj.getClassName(false);
            }
            string = string + " [" + string2 + "-" + baseObj.getId() + "]";
        }
        return string;
    }

    public LogInfo makeLogOnDel(BaseObj baseObj) {
        String string = this.makeName(baseObj);
        return new LogInfo(this.getDeleteOpType(baseObj), string, "\u5220\u9664" + string);
    }

    public LogInfo makeLogOnModify(BaseObj baseObj) {
        String string = this.makeName(baseObj);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("\u4fee\u6539").append(string);
        stringBuffer.append(",\u4e3b\u8981\u5c5e\u6027\u4fee\u6539\u60c5\u51b5\u5982\u4e0b:\n");
        Map map = this.getMajorKeys();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                String string2;
                entry = iterator.next();
                if (entry == null || !baseObj.isChangeProperty(string2 = (String)entry.getKey())) continue;
                stringBuffer.append(entry.getValue()).append(":");
                String string3 = baseObj.getPropertyAsString(string2, "");
                stringBuffer.append(this.format(string3));
                stringBuffer.append(" --> ");
                string3 = baseObj.getNewPropertyAsString(string2);
                stringBuffer.append(this.format(string3));
                stringBuffer.append('\n');
                bl = true;
            }
            if (!bl) {
                return null;
            }
        }
        return new LogInfo(this.getModifyOpType(baseObj), string, stringBuffer.toString());
    }

    protected String format(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 100) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
            while (string.length() > 100) {
                stringBuffer.append(string.substring(0, 100));
                stringBuffer.append("\n\t");
                string = string.substring(100);
            }
            if (string.length() > 0) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected int getAddOpType(BaseObj baseObj) {
        return OperTypeHelper.getAddOp(baseObj);
    }

    protected int getModifyOpType(BaseObj baseObj) {
        return OperTypeHelper.getModifyOp(baseObj);
    }

    protected int getDeleteOpType(BaseObj baseObj) {
        return OperTypeHelper.getDeleteOp(baseObj);
    }

    public abstract int getLogObjType();

    protected abstract Map getMajorKeys();

    protected abstract String getObjName(BaseObj var1);
}

