/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import java.util.Date;

public class Locker {
    private User lockUser = null;
    private int lockTimeOut = 0;
    private boolean locked = false;
    private Date expiredTime = null;
    public static int DEF_LOCKTIMEOUT = 1200;

    public Locker() {
    }

    Locker(User user) {
        this.lockUser = user;
        this.locked = true;
    }

    public User getLockUser() {
        return this.lockUser;
    }

    public int getLockTimeOut() {
        return this.lockTimeOut;
    }

    public boolean lockUserIs(User user) {
        if (!this.locked) {
            return false;
        }
        if (this.lockUser == null) {
            return true;
        }
        return this.lockUser.equals(user);
    }

    public synchronized boolean isLocked() {
        if (this.locked && this.isTimeOut()) {
            this.unlock();
        }
        return this.locked;
    }

    public boolean isTimeOut() {
        return this.isTimeOut(new Date());
    }

    public boolean isTimeOut(Date date) {
        if (!this.locked) {
            return true;
        }
        if (this.lockTimeOut == 0) {
            return false;
        }
        return this.expiredTime.before(date);
    }

    public synchronized boolean lock(User user) {
        return this.lock(user, DEF_LOCKTIMEOUT);
    }

    public synchronized boolean lock(User user, int n) {
        if (n < 0) {
            return false;
        }
        if (this.locked) {
            return this.lockUser.equals(user);
        }
        this.locked = true;
        this.lockUser = user;
        this.lockTimeOut = n;
        if (n > 0) {
            Date date = null;
            date = this.expiredTime == null ? (this.expiredTime = new Date()) : new Date();
            this.expiredTime.setTime(date.getTime() + (long)(this.lockTimeOut * 1000));
        }
        return true;
    }

    public synchronized boolean unlock() {
        if (!this.locked) {
            return true;
        }
        this.locked = false;
        this.lockUser = null;
        this.lockTimeOut = 0;
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("locker:");
        stringBuffer.append(this.locked);
        stringBuffer.append(",user=");
        stringBuffer.append(this.lockUser);
        return stringBuffer.toString();
    }

    static {
        try {
            DEF_LOCKTIMEOUT = Integer.valueOf(ConfigServer.getServer().getSysConfigValue("DEF_LOCKTIMEOUT", "20")) * 60;
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
    }
}

