/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.content.ImgRec;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class HTMLContent {
    private static Logger s_logger = Logger.getLogger(HTMLContent.class);
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;
    private String m_sSrcHTMLContent = null;
    private List m_listFiles = null;
    private List m_listWCMFiles = null;
    private static boolean s_bDeleteUploadPic;
    protected List m_listSrcFiles = null;

    public HTMLContent(String string) {
        this.m_sSrcHTMLContent = string;
    }

    public List getFiles() throws WCMException {
        if (this.m_listFiles == null) {
            this.m_listFiles = new ArrayList();
            this.parseHTMLContent(this.m_listFiles, null, true, false);
        }
        return this.m_listFiles;
    }

    public List getWCMFiles() throws WCMException {
        if (this.m_listWCMFiles == null) {
            this.m_listWCMFiles = new ArrayList();
            this.parseHTMLContent(this.m_listWCMFiles, null, true, true);
        }
        return this.m_listWCMFiles;
    }

    public String parseHTMLContent(String string) throws WCMException {
        return this.parseHTMLContentWihtMultImgPre(new String[]{string});
    }

    public String parseHTMLContentWihtMultImgPre(String[] stringArray) throws WCMException {
        if (this.m_listWCMFiles == null) {
            this.m_listWCMFiles = new ArrayList();
        }
        return this.parseHTMLContent(this.m_listWCMFiles, stringArray, false, true);
    }

    private String parseHTMLContent(List list, String[] stringArray, boolean bl, boolean bl2) throws WCMException {
        if (bl) {
            list.clear();
        }
        if (this.m_sSrcHTMLContent == null || this.m_sSrcHTMLContent.length() == 0) {
            return "";
        }
        String string = this.m_sSrcHTMLContent;
        String[] stringArray2 = HTMLContent.getTagNames();
        String[] stringArray3 = HTMLContent.getTagSrcs();
        if (stringArray2 == null || stringArray3 == null) {
            return this.m_sSrcHTMLContent;
        }
        int n = stringArray2.length > stringArray3.length ? stringArray2.length : stringArray3.length;
        FilesMan filesMan = FilesMan.getFilesMan();
        try {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                HtmlElement htmlElement;
                String string2 = stringArray2[i];
                String string3 = stringArray3[i];
                HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string);
                while ((htmlElement = htmlElementFinder.findNextElement(string2, true)) != null) {
                    int n3;
                    String string4 = htmlElement.getAttributeValue(string3);
                    if (string4 == null || string4.length() == 0) {
                        htmlElementFinder.putElement(htmlElement);
                        continue;
                    }
                    if (bl) {
                        if (bl2 ^ FilesMan.isValidFile(string4, "W0")) {
                            htmlElementFinder.putElement(htmlElement);
                            continue;
                        }
                        n3 = string4.lastIndexOf(47);
                        if (n3 > 0) {
                            string4 = string4.substring(n3 + 1);
                        }
                        list.add(string4);
                    } else {
                        String string5;
                        if (!FilesMan.isValidFile(string4, "W0")) {
                            htmlElementFinder.putElement(htmlElement);
                            continue;
                        }
                        n3 = string4.lastIndexOf(47);
                        if (n3 > 0) {
                            string4 = string4.substring(n3 + 1);
                        }
                        list.add(string4);
                        String string6 = stringArray[n2++];
                        if (n2 >= stringArray.length) {
                            n2 = 0;
                        }
                        if ((string5 = string6) == null) {
                            string5 = filesMan.mapFilePath(string4, 1);
                        }
                        htmlElement.setAttribute(string3, string5 + string4);
                    }
                    htmlElementFinder.putElement(htmlElement);
                }
                string = htmlElementFinder.getContent();
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(HTMLContent.class, "HTMLContent.label1", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6587\u6863HTML\u5185\u5bb9\u5931\u8d25(Document.getHtmlContentWithImgFilter)"), exception);
        }
    }

    public static String saveHtmlContent(String string) throws WCMException {
        return HTMLContent.saveHtmlContent(string, false, true);
    }

    public static String saveHtmlContent(String string, boolean bl, boolean bl2) throws WCMException {
        return HTMLContent.saveHtmlContent(string, bl, bl2, null);
    }

    private static String saveHtmlContent(String string, boolean bl, boolean bl2, HashMap hashMap) throws WCMException {
        String[] stringArray = HTMLContent.getTagNames();
        String[] stringArray2 = HTMLContent.getTagSrcs();
        if (stringArray == null) {
            return string;
        }
        int n = stringArray.length > stringArray2.length ? stringArray.length : stringArray2.length;
        HtmlElementFinder htmlElementFinder = null;
        HtmlElement htmlElement = null;
        Vector<ImgRec> vector = new Vector<ImgRec>();
        ImgRec imgRec = null;
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!bl2 && string2.equalsIgnoreCase("A")) continue;
                String string3 = stringArray2[i];
                htmlElementFinder = new HtmlElementFinder(string);
                while ((htmlElement = htmlElementFinder.findNextElement(string2, true)) != null) {
                    String string4 = htmlElement.getAttributeValue("IGNORE");
                    String string5 = htmlElement.getAttributeValue(string3);
                    if (string4 != null && string4.equals("1") || string5 == null || (string5 = string5.trim()).length() == 0) {
                        htmlElementFinder.putElement(htmlElement);
                        continue;
                    }
                    String string6 = null;
                    imgRec = HTMLContent.getRepeatedImg(string5, vector);
                    if (imgRec != null) {
                        htmlElement.setAttribute(string3, imgRec.oldSrc);
                        htmlElement.setAttribute("OLDSRC", imgRec.oldSrc);
                        htmlElementFinder.putElement(htmlElement);
                        continue;
                    }
                    string6 = HTMLContent.saveFile(htmlElement, string5, bl, hashMap);
                    if (string6 != null) {
                        imgRec = new ImgRec();
                        imgRec.src = string5;
                        imgRec.oldSrc = string6;
                        vector.add(imgRec);
                        htmlElement.setAttribute(string3, string6);
                        htmlElement.setAttribute("OLDSRC", imgRec.oldSrc);
                    }
                    htmlElementFinder.putElement(htmlElement);
                }
                string = htmlElementFinder.getContent();
            }
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label2", "\u4fdd\u5b58HTML\u5185\u5bb9\u5931\u8d25!"), exception);
        }
    }

    private static String saveFile(HtmlElement htmlElement, String string, boolean bl, HashMap hashMap) {
        String string2;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (hashMap != null) {
            string2 = CMyFile.extractFileName(string, "/");
            String string3 = (String)hashMap.get((string2 = CMyFile.extractFileName(string2, "\\")).toLowerCase());
            if (string3 != null) {
                try {
                    return filesMan.copyFile(string3, "W0", false);
                }
                catch (Exception exception) {
                    s_logger.error((Object)(I18NMessage.get(HTMLContent.class, "HTMLContent.label3", "\u62f7\u8d1d\u6587\u4ef6[") + string3 + I18NMessage.get(HTMLContent.class, "HTMLContent.label4", "]\u5931\u8d25\uff01")), (Throwable)exception);
                    return null;
                }
            }
        }
        if (FilesMan.isValidFile(string, "W0")) {
            if (bl) {
                try {
                    return filesMan.copyWCMFile(string, "W0");
                }
                catch (WCMException wCMException) {
                    return null;
                }
            }
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                return string.substring(n + 1);
            }
        } else {
            string2 = htmlElement.getAttributeValue("UploadPic");
            if (string2 == null || string2.length() < 8) {
                string2 = string;
            }
            return HTMLContent.saveNewPic(htmlElement, string2);
        }
        return null;
    }

    private static String saveNewPic(HtmlElement htmlElement, String string) {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = null;
        if (FilesMan.isValidFile(string, "U0") || FilesMan.isValidFile(string, "ST")) {
            try {
                string2 = filesMan.copyWCMFile(string, "W0");
                if (s_bDeleteUploadPic) {
                    filesMan.deleteFile(string);
                }
                htmlElement.removeAttribute("UploadPic");
            }
            catch (Exception exception) {
                s_logger.error((Object)(I18NMessage.get(HTMLContent.class, "HTMLContent.label5", "\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1aaddNewPic\uff1a") + string), (Throwable)exception);
                string2 = null;
            }
            return string2;
        }
        if (!HTMLContent.isNeedDownload(htmlElement, string)) {
            return null;
        }
        string2 = HTMLContent.downloadFile(string);
        if (string2 != null && string2.length() > 0) {
            string2 = CMyFile.extractFileName(string2);
        }
        return string2;
    }

    private static boolean isNeedDownload(HtmlElement htmlElement, String string) {
        char c = string.charAt(string.length() - 1);
        if (c == '/' || c == '\\') {
            return false;
        }
        String string2 = string;
        int n = string.lastIndexOf("?");
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        if (FileHelper.isForbidFileExt(string2)) {
            return false;
        }
        boolean bl = true;
        if (htmlElement.getName().equalsIgnoreCase("A")) {
            bl = htmlElement.getAttribute("NeedDownload") != null && !HTMLContent.isHTMLContent(string);
            htmlElement.removeAttribute("NeedDownload");
        } else {
            bl = htmlElement.getAttribute("NeedDownload") != null;
            htmlElement.removeAttribute("NeedDownload");
            if (bl) {
                return true;
            }
            boolean bl2 = bl = string.toUpperCase().indexOf("HTTP:") == 0 || string.toUpperCase().indexOf("HTTPS:") == 0;
            if (!bl) {
                return bl;
            }
            int n2 = string.lastIndexOf(47);
            String string3 = n2 >= 0 ? string.substring(n2 + 1) : "";
            n2 = string3.indexOf(46);
            string3 = n2 >= 0 ? string3.substring(n2 + 1) : "";
            String[] stringArray = new String[]{"ASP", "JSP", "PHP"};
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                if (!string3.toUpperCase().startsWith(stringArray[i])) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static ImgRec getRepeatedImg(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ImgRec imgRec = (ImgRec)vector.get(i);
            if (string.compareToIgnoreCase(imgRec.src) != 0) continue;
            return imgRec;
        }
        return null;
    }

    private static String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private static String[] getTagSrcs() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private static boolean isHTMLContent(String string) {
        String string2 = CMyFile.extractFileExt(string).toLowerCase();
        if (string2.indexOf("htm") >= 0) {
            return true;
        }
        if (string2.indexOf("asp") >= 0) {
            return true;
        }
        if (string2.indexOf("jsp") >= 0) {
            return true;
        }
        return string2.indexOf("php") >= 0;
    }

    private static String downloadFile(String string) {
        try {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = CMyFile.extractFileExt(string);
            String string3 = filesMan.getNextFilePathName("W0", string2);
            if (CMyFile.fileExists(string)) {
                CMyFile.copyFile(string, string3);
            } else {
                CMy3WLib.getFile(string, string3);
            }
            return string3;
        }
        catch (Exception exception) {
            s_logger.error((Object)("Fail to download[" + string + "]!"), (Throwable)exception);
            return null;
        }
    }

    public static String saveHTMLContentFromOut(String string, HashMap hashMap) throws WCMException {
        return HTMLContent.saveHtmlContent(string, false, true, hashMap);
    }

    public static String getBodyContent(String string) throws WCMException {
        try {
            String string2 = string.toUpperCase();
            int n = string2.indexOf("<BODY>");
            if (n < 0) {
                n = string2.indexOf("<BODY ");
                if (n < 0) {
                    return string2;
                }
                HtmlElement htmlElement = new HtmlElement();
                htmlElement.ONLY_SEARCH_SELF = true;
                n += htmlElement.fromString(string.substring(n));
            }
            if (n < 0) {
                return string;
            }
            int n2 = string2.lastIndexOf("</BODY>");
            if (n2 < 0) {
                return string.substring(n);
            }
            return string.substring(n, n2);
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(HTMLContent.class, "HTMLContent.label6", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), (Throwable)exception);
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label6", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            HTMLContent hTMLContent = new HTMLContent("<P align=center><IMG src='U020041026612707828449.gif'></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label7", "<P>\u6b63\u6587\u5185\u5bb91</P><P align=center>") + I18NMessage.get(HTMLContent.class, "HTMLContent.label8", "<IMG src='U020041026612707828449.gif'></P><P>\u6b63\u6587\u5185\u5bb92</P>") + "<P align=center><IMG src='U020041026370966871586.html'></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label9", "<P>\u6b63\u6587\u5185\u5bb93</P><P>\u6b63\u6587\u5185\u5bb92</P>") + "<P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P>" + "<P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P>" + "<P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label10", "<P>\u6b63\u6587\u5185\u5bb93</P>"));
            s_logger.info((Object)"===============WEBPIC===============");
            s_logger.info((Object)hTMLContent.parseHTMLContent(null));
            s_logger.info((Object)"===============IMAGES===============");
            s_logger.info((Object)hTMLContent.parseHTMLContentWihtMultImgPre(new String[]{"im1/", "im2/"}));
            List list = hTMLContent.getWCMFiles();
            for (int i = 0; i < list.size(); ++i) {
                s_logger.info((Object)(i + ":" + list.get(i)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        s_bDeleteUploadPic = true;
    }
}

