/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;
import org.apache.log4j.Logger;

public class ExtendedField
extends CMSObj {
    private static Logger logger = Logger.getLogger(ExtendedField.class);
    private static final char CHAR_UNDERLINE = '_';
    public static final int OBJ_TYPE = 4;
    public static final String DB_TABLE_NAME = "WCMEXTFIELD";
    public static final String DB_ID_NAME = "EXTFIELDID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 4;
    }

    public String getTableName() {
        return this.getPropertyAsString("TABLENAME");
    }

    public boolean setTableName(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label1", "\u5c5e\u6027TableName\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setTableName\uff09"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label2", "\u6307\u5b9a\u7684\u8868\u540d\u79f0\u4e3a\u7a7a\uff08ExtendedField.setTableName\uff09"));
        }
        string = string.toUpperCase();
        if (this.getDBManager().getTableInfo(string) == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label3", "\u6307\u5b9a\u7684\u6570\u636e\u8868") + string + I18NMessage.get(ExtendedField.class, "ExtendedField.label4", "\u4e0d\u5b58\u5728\uff08ExtendedField.setTableName\uff09"));
        }
        return this.setProperty("TABLENAME", string.toUpperCase());
    }

    public String getName() {
        return this.getPropertyAsString("FIELDNAME");
    }

    public boolean setName(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label5", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setName\uff09"));
        }
        return this.setProperty("FIELDNAME", string.toUpperCase());
    }

    public String getDesc() {
        return this.getPropertyAsString("FIELDDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("FIELDDESC", string);
    }

    public String getTypeName() {
        return this.getPropertyAsString("FIELDTYPE");
    }

    public String getTypeDesc() throws WCMException {
        return DataType.toTypeDescription(this.getType());
    }

    public DataType getType() throws WCMException {
        String string = this.getTypeName();
        return string == null ? null : this.getDBManager().getDBType().getDataType(string);
    }

    public int getMaxLength() {
        return this.getPropertyAsInt("FIELDMAXLEN", 0);
    }

    public int getScale() {
        return this.getPropertyAsInt("FIELDSCALE", 0);
    }

    public boolean isNullable() {
        return this.getPropertyAsBoolean("FIELDNULLABLE", true);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString("FIELDDEFAULT");
    }

    public int getDefaultValueAsInt(int n) throws WCMException {
        String string = this.getDefaultValue();
        if (string == null || (string = string.trim()).length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(ExtendedField.class, "ExtendedField.label6", "\u9ed8\u8ba4\u503c\u4e0d\u662f\u6574\u6570\uff08ExtendedField.getDefaultValueAsInt\uff09"), exception);
        }
    }

    public boolean setType(String string, int n) throws WCMException {
        return this.setType(string, n, true, null);
    }

    public boolean setType(String string, int n, boolean bl, String string2) throws WCMException {
        return this.setType(string, n, bl, string2, 0);
    }

    public boolean setType(String string, int n, boolean bl, String string2, int n2) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(ExtendedField.class, "ExtendedField.label7", "\u5c5e\u6027Name\u4e0d\u5141\u8bb8\u4fee\u6539\uff08ExtendedField.setType\uff09"));
        }
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label8", "\u6307\u5b9a\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a\uff08ExtendedField.setType\uff09"));
        }
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label9", "\u6307\u5b9a\u6700\u5927\u957f\u5ea6\u5c0f\u4e8e0\uff1a") + n + "\uff08ExtendedField.setType\uff09");
        }
        if (!bl && string2 == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label10", "\u975e\u7a7a\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u9ed8\u8ba4\u503c\uff08ExtendedField.setType\uff09"));
        }
        DataType dataType = this.getDBManager().getDBType().getDataType(string);
        if (dataType == null) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label11", "\u65e0\u6548\u7684\u6570\u636e\u7c7b\u578b\uff1a") + string + "\uff08ExtendedField.setType\uff09");
        }
        int n3 = dataType.getMaxLength();
        if (!dataType.isLengthDefinedByUser()) {
            n = n3;
        } else if (n > n3) {
            throw new WCMException(10, I18NMessage.get(ExtendedField.class, "ExtendedField.label12", "\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7") + n3 + "\uff08ExtendedField.setType\uff09");
        }
        if (!this.setProperty("FIELDTYPE", string)) {
            return false;
        }
        if (!this.setProperty("FIELDMAXLEN", n)) {
            return false;
        }
        if (!this.setProperty("FIELDNULLABLE", bl)) {
            return false;
        }
        if (!this.setProperty("FIELDSCALE", n2)) {
            return false;
        }
        return bl ? true : this.setProperty("FIELDDEFAULT", string2);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String string = (String)this.getAllProperty().get("TABLENAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(ExtendedField.class, "ExtendedField.label13", "\u5c5e\u6027TableName\u6ca1\u6709\u8bbe\u7f6e(ExtendedField.isValid)"));
            }
            String string2 = (String)this.getAllProperty().get("FIELDNAME");
            if (string2 == null || string2.trim().length() == 0) {
                throw new WCMException(1106, I18NMessage.get(ExtendedField.class, "ExtendedField.label14", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ExtendedField.isValid)"));
            }
            if (CMyString.isContainChineseChar(string2)) {
                throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label15", "\u5c5e\u6027Name\u65e0\u6548,\u4e0d\u5141\u8bb8\u5305\u542b\u4e2d\u6587\u5b57\u7b26\u7684\u6269\u5c55\u5b57\u6bb5\u540d!"));
            }
            this.assertValidName(string2);
            this.setName(string2);
            if (this.getDBManager().getFieldInfo(string, string2) != null) {
                throw new WCMException(1108, I18NMessage.get(ExtendedField.class, "ExtendedField.label16", "\u6570\u636e\u8868") + string + I18NMessage.get(ExtendedField.class, "ExtendedField.label17", "\u4e2d\u5df2\u7ecf\u5b58\u5728\u5b57\u6bb5") + string2 + "\uff08ExtendedField.isValid\uff09");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ExtendedField.class, "ExtendedField.label18", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ExtendedField.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
            DBManager dBManager = this.getDBManager();
            try {
                String[] stringArray = new String[]{dBManager.getDBType().sqlAddField(this.getTableName(), this.getName(), this.getTypeName(), this.getMaxLength(), this.isNullable(), this.getDefaultValue(), this.getScale())};
                dBManager.sqlExecuteUpdate(stringArray);
            }
            catch (Exception exception) {
                try {
                    String string = "DELETE FROM WCMEXTFIELD WHERE FieldName='" + this.getName() + "'";
                    dBManager.sqlExecuteUpdate(string);
                }
                catch (Exception exception2) {
                    logger.fatal((Object)"Faield rollback:\n", (Throwable)exception2);
                }
                throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label19", "\u6dfb\u52a0\u6269\u5c55\u5b57\u6bb5\u5931\u8d25!"), exception);
            }
            dBManager.reloadTableInfo(this.getTableName());
            return;
        }
    }

    public int delete(User user) throws WCMException {
        if (!this.getDBManager().getDBType().canDropField()) {
            return 0;
        }
        String string = " EXTFIELDID in (select EXTFIELDID from WCMCONTENTEXTFIELD where EXTFIELDID=" + this.getId() + ")";
        if (this.checkExists(string)) {
            throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label20", "\u67d0\u4e9b\u9891\u9053\u6b63\u5728\u4f7f\u7528\u8be5\u6269\u5c55\u5b57\u6bb5\uff0c\u4e0d\u80fd\u5220\u9664\uff08ExtentedField.delete\uff09"));
        }
        DBManager dBManager = DBManager.getDBManager();
        try {
            String[] stringArray = new String[]{this.getDBManager().getDBType().sqlDropField(this.getTableName(), this.getName())};
            dBManager.sqlExecuteUpdate(stringArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ExtendedField.class, "ExtendedField.label21", "\u5220\u9664\u6570\u636e\u5e93\u4e2d\u7684\u6269\u5c55\u5b57\u6bb5\u5931\u8d25\uff08ExtendedField.delete\uff09"), exception);
        }
        int n = super.delete(user);
        dBManager.reloadTableInfo(this.getTableName());
        return n;
    }

    public static final ExtendedField findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ExtendedField)BaseObj.findById(ExtendedField.class, n);
    }

    public static final ExtendedField createNewInstance() throws WCMException {
        return (ExtendedField)BaseObj.createNewInstance(ExtendedField.class);
    }

    public static final ExtendedField findByKey(Object object) throws WCMException {
        return (ExtendedField)BaseObj.findByKey(ExtendedField.class, object);
    }

    private void assertValidName(String string) throws WCMException {
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!ExtendedField.isEnglishChar(c)) {
            throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label22", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5\u540d,\u6269\u5c55\u5b57\u6bb5\u540d\u7684\u7b2c\u4e00\u4e2a\u5b57\u7b26\u5fc5\u987b\u662f\u82f1\u6587\u5b57\u7b26!"));
        }
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            if (c == '_' || ExtendedField.isEnglishChar(c) || ExtendedField.isNumricChar(c)) continue;
            throw new WCMException(1104, I18NMessage.get(ExtendedField.class, "ExtendedField.label23", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5\u540d,\u6269\u5c55\u5b57\u6bb5\u540d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u7b26\u548c\u6570\u5b57\u7ec4\u6210!\u5305\u542b\u65e0\u6548\u7684\u5b57\u7b26[") + c + "]");
        }
    }

    private static boolean isNumricChar(int n) {
        return n >= 48 && n <= 57;
    }

    private static boolean isEnglishChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122;
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return I18NMessage.get(ExtendedField.class, "ExtendedField.label24", "[\u6269\u5c55\u5b57\u6bb5-") + this.getId() + "]" + this.getName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExtendedField)) {
            return false;
        }
        ExtendedField extendedField = (ExtendedField)object;
        if (!extendedField.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        try {
            return this.getType().equals(extendedField.getType());
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(ExtendedField.class, "ExtendedField.label25", "\u5bf9\u4e8eData Type\u6bd4\u8f83\u5931\u8d25\uff01"), (Throwable)exception);
            return false;
        }
    }
}

