/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class ClusterLocker {
    private User lockUser = null;
    private CMSObj lockedObj = null;
    private static final String SQL_INS = "insert into WCMCLUSTERLOCK(OBJID,OBJTYPE,LOCKEDUSER,LOCKEDTIME) values(?,?,?,?)";
    private static final String SQL_DEL = "delete from WCMCLUSTERLOCK where OBJID=? and OBJTYPE=? and LOCKEDUSER=?";

    public ClusterLocker(User user, CMSObj cMSObj) {
        this.lockUser = user;
        this.lockedObj = cMSObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        if (this.lockUser == null || this.lockedObj == null) {
            return false;
        }
        if (this.lockedObj.getId() == 0) {
            return true;
        }
        DBManager dBManager = DBManager.getDBManager();
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(SQL_INS);
            preparedStatement.setInt(1, this.lockedObj.getId());
            preparedStatement.setInt(2, this.lockedObj.getWCMType());
            preparedStatement.setString(3, this.lockUser.getName());
            preparedStatement.setTimestamp(4, CMyDateTime.now().toTimestamp());
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        if (this.lockUser == null || this.lockedObj == null) {
            return false;
        }
        if (this.lockedObj.getId() == 0) {
            return true;
        }
        DBManager dBManager = DBManager.getDBManager();
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(SQL_DEL);
            preparedStatement.setInt(1, this.lockedObj.getId());
            preparedStatement.setInt(2, this.lockedObj.getWCMType());
            preparedStatement.setString(3, this.lockUser.getName());
            boolean bl = preparedStatement.executeUpdate() == 1;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
    }
}

