/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class CMSBaseObjs
extends BaseObjs {
    private static Logger s_logger = Logger.getLogger(CMSBaseObjs.class);
    protected User currUser = null;

    public CMSBaseObjs() {
        this.currUser = User.getSystem();
    }

    public CMSBaseObjs(User user) {
        this.currUser = user;
    }

    public CMSBaseObjs(User user, int n, int n2) {
        super(n, n2);
        this.currUser = user;
    }

    public User getCurrUser() {
        return this.currUser;
    }

    public void setCurrUser(User user) {
        this.currUser = user;
    }

    protected void updateElement(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label1", "\u6307\u5b9a\u66f4\u65b0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".updateElement)");
        }
        ((CMSObj)baseObj).update(this.currUser);
    }

    public boolean canEditAll() {
        if (this.isEmpty()) {
            return false;
        }
        CMSObj cMSObj = null;
        for (int i = 0; i < this.size(); ++i) {
            cMSObj = (CMSObj)this.getAt(i);
            if (cMSObj == null || cMSObj.canEdit(this.currUser)) continue;
            for (int j = 0; j < i; ++j) {
                cMSObj = (CMSObj)this.getAt(j);
                if (cMSObj == null) continue;
                cMSObj.cancelUpdate(this.currUser);
            }
            return false;
        }
        return true;
    }

    public boolean canEdit() throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label2", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20(") + this.getClass().getName() + ".canEdit)");
        }
        CMSObj cMSObj = (CMSObj)this.getCurrent();
        if (cMSObj == null) {
            return false;
        }
        boolean bl = cMSObj.canEdit(this.currUser);
        if (bl) {
            this.currMode = 2;
        }
        return bl;
    }

    public boolean canEdit(int n) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label2", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20(") + this.getClass().getName() + ".canEdit)");
        }
        CMSObj cMSObj = (CMSObj)this.getCurrent();
        if (cMSObj == null) {
            return false;
        }
        boolean bl = cMSObj.canEdit(this.currUser, n);
        if (bl) {
            this.currMode = 2;
        }
        return bl;
    }

    public void cancelUpdateAll(int n) {
        if (n <= 0) {
            return;
        }
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                int n2 = this.size() > n ? n : this.size();
                for (int i = 0; i < n2; ++i) {
                    try {
                        ((CMSObj)this.getAt(i)).cancelUpdate(this.currUser);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
    }

    public void cancelUpdateAll() {
        this.cancelUpdateAll(this.size());
    }

    public void cancelUpdate() {
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                try {
                    CMSObj cMSObj = (CMSObj)this.getCurrent();
                    if (cMSObj != null) {
                        cMSObj.cancelUpdate(this.currUser);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currMode = 0;
            }
        }
    }

    public static CMSBaseObjs createInstance(User user, String string) throws WCMException {
        try {
            return CMSBaseObjs.createInstance(user, Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_logger.error((Object)("failed to create new instance of " + string), (Throwable)classNotFoundException);
            throw new WCMException(1351, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label3", "\u521b\u5efa\u5bf9\u8c61[") + string + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label4", "]\u5b9e\u4f8b\u5931\u8d25!"), classNotFoundException);
        }
    }

    public static CMSBaseObjs createInstance(User user, Class clazz) throws WCMException {
        try {
            return (CMSBaseObjs)clazz.getDeclaredConstructor(User.class).newInstance(user);
        }
        catch (Exception exception) {
            s_logger.error((Object)"faile to create new instance of CMSBaseObjs:", (Throwable)exception);
            throw new WCMException(1351, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label3", "\u521b\u5efa\u5bf9\u8c61[") + clazz.getName() + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label4", "]\u5b9e\u4f8b\u5931\u8d25!"), exception);
        }
    }

    public static CMSBaseObjs openWCMObjs(User user, Class clazz, WCMFilter wCMFilter) throws WCMException {
        CMSBaseObjs cMSBaseObjs = CMSBaseObjs.createInstance(user, clazz);
        cMSBaseObjs.open(wCMFilter);
        return cMSBaseObjs;
    }

    public static CMSBaseObjs openWCMObjs(User user, String string, WCMFilter wCMFilter) throws WCMException {
        try {
            return CMSBaseObjs.openWCMObjs(user, Class.forName(string), wCMFilter);
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_logger.error((Object)"failed to find objs:", (Throwable)classNotFoundException);
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label5", "\u67e5\u8be2\u6307\u5b9a\u5bf9\u8c61\u96c6\u5408[") + string + "][" + wCMFilter + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label6", "]\u5931\u8d25!"), classNotFoundException);
        }
    }

    public static CMSBaseObjs findWCMObjsByIds(User user, Class clazz, String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label7", "\u6307\u5b9a\u7684ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        if (clazz == null) {
            throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label8", "\u6307\u5b9a\u7684\u96c6\u5408Class\u65e0\u6548\uff01"));
        }
        CMSBaseObjs cMSBaseObjs = CMSBaseObjs.createInstance(user, clazz);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                cMSBaseObjs.clear();
                cMSBaseObjs = null;
                throw new WCMException(10, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label9", "\u6307\u5b9a\u7684ID\u5e8f\u5217\u6709\u8bef[") + string + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label10", "]\uff01\u5305\u542b\u975e\u6570\u5b57\u7c7b\u578b[") + string2 + "]!");
            }
            CMSObj cMSObj = (CMSObj)BaseObj.findById(cMSBaseObjs.getElementClass(), n);
            if (cMSObj == null) continue;
            cMSBaseObjs.addElement(cMSObj);
        }
        return cMSBaseObjs;
    }

    public static CMSBaseObjs findWCMObjsByIds(User user, String string, String string2) throws WCMException {
        try {
            return CMSBaseObjs.findWCMObjsByIds(user, Class.forName(string), string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_logger.error((Object)"failed to find objs:", (Throwable)classNotFoundException);
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label11", "\u67e5\u8be2\u6307\u5b9a\u5bf9\u8c61[") + string + "][" + string2 + I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label12", "]\u96c6\u5408\u5931\u8d25!"), classNotFoundException);
        }
    }

    protected boolean removeElement(BaseObj baseObj, int n, boolean bl) throws WCMException {
        try {
            if (bl) {
                ((CMSObj)baseObj).delete(this.currUser);
                if (!baseObj.isCached() && this.getObjsBuffer().remove(baseObj.getKey()) == null) {
                    return false;
                }
            }
            this.vIdList.removeElementAt(n);
            this.currIndex = n >= this.size() ? -3 : n;
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(CMSBaseObjs.class, "CMSBaseObjs.label13", "\u4ece\u96c6\u5408\u4e2d\u5220\u9664\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".removeElement).", exception);
        }
    }
}

