/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.infra.util.key.MacAddressHelper;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class UserLicenseMgr {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static License s_oLicense = null;
    private static UserLicenseMgr s_oMgr = new UserLicenseMgr();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserLicenseMgr getInstance() {
        if (s_oLicense == null) {
            UserLicenseMgr userLicenseMgr = s_oMgr;
            synchronized (userLicenseMgr) {
                License license;
                if (s_oLicense != null) {
                    return s_oMgr;
                }
                String string = UserLicenseMgr.getProductKey();
                UserLicenseMgr.validateHostMachine(string);
                UserLicenseMgr.validateExpiration(string);
                String string2 = string.substring(12, 14);
                final int n = CKeyUtil.getKeyNum(string2);
                string2 = string.substring(14, 16);
                final int n2 = CKeyUtil.getKeyNum(string2);
                s_oLicense = license = new License(){

                    public int getMaxSiteNum() {
                        return n - 1;
                    }

                    public int getMaxUserNum() {
                        return n2;
                    }

                    public int getPluginCode() {
                        return 0;
                    }

                    public String validate() {
                        return null;
                    }
                };
            }
        }
        return s_oMgr;
    }

    public int getMaxUserNum() {
        return s_oLicense.getMaxUserNum();
    }

    public void validateUserLicense() {
        String string = "SELECT COUNT(*) FROM WCMUSER";
        int n = 0;
        try {
            n = DBManager.getDBManager().sqlExecuteIntQuery(string);
        }
        catch (Exception exception) {
            throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label1", "\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"), exception);
        }
        if (n > s_oLicense.getMaxUserNum() && s_oLicense.getMaxUserNum() != -1) {
            throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u7684\u7cfb\u7edf\u7528\u6237\u6570\u5df2\u7ecf\u8fbe\u5230\u5141\u8bb8\u7684\u4e0a\u9650!\u60a8\u7684\u6700\u591a\u7528\u6237\u6570\u4e3a[") + (s_oLicense.getMaxUserNum() + 1) + "]");
        }
    }

    private static String getProductKey() {
        String string = UserLicenseMgr.loadLicenseFile();
        string = LicenseUtil.decodeRadix64(string);
        return CKeyUtil.DecodeKey(string);
    }

    private static void validateExpiration(String string) {
        String string2 = string.substring(16, string.length());
        string2 = string2.substring(0, 4) + '-' + string2.substring(4, 6) + '-' + string2.substring(6, string2.length());
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateWithString(string2, 0);
            if (cMyDateTime.dateDiff(3, CMyDateTime.now()) < 0L) {
                String string3 = I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label3", "\u4ea7\u54c1\u5df2\u8fc7\u671f,\u60a8\u9700\u8981\u8d2d\u4e70\u53e6\u4e00\u4e2a\u4f7f\u7528\u8bb8\u53ef\u624d\u80fd\u7ee7\u7eed\u4f7f\u7528!\n") + I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label4", "\u611f\u8c22\u60a8\u4f7f\u7528TRSWCM!\n") + I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label5", "TRS\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1.");
                throw new LicenseException(string3);
            }
        }
        catch (CMyException cMyException) {
            throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label6", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!"), cMyException);
        }
    }

    private static void validateHostMachine(String string) {
        String string2 = string.substring(0, 12);
        while (string2.charAt(0) == '0' && string2.length() > 0) {
            string2 = string2.substring(1);
        }
        long l = Long.parseLong(string2);
        if (!MacAddressHelper.isValidMac(l)) {
            throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label7", "\u65e0\u6548\u7684\u4f7f\u7528\u8bb8\u53ef(Host)!"));
        }
    }

    private static String loadLicenseFile() {
        String string = "";
        Class<UserLicenseMgr> clazz = UserLicenseMgr.class;
        String string2 = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            string = CMyFile.readFile(string2).trim();
        }
        catch (CMyException cMyException) {
            int n = cMyException.getErrNo();
            if (55 == n) {
                throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label8", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(UserLicenseMgr.class, "UserLicenseMgr.label9", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String string3 = LicenseUtil.decodeRadix64(string);
        return string3;
    }
}

