/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUserCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.IUserCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyEncrypt;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class User
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = 1354095122078583355L;
    private static Logger s_logger = Logger.getLogger(User.class);
    public static final int OBJ_TYPE = 204;
    public static final String DB_TABLE_NAME = "WCMUSER";
    public static final String DB_ID_NAME = "USERID";
    public static final int USER_STATUS_APPLY = 0;
    public static final int USER_STATUS_REG = 30;
    public static final int USER_STATUS_DEL = 10;
    public static final int USER_STATUS_FORBID = 20;
    public static final int USER_STATUS_ALL = -1;
    public static final int USER_STATUS_DROPED = 40;
    public static final char USER_DROPED_NAME_FLAG = '$';
    public static final String SYSTEM_USERNAME = "system";
    private static final int SYSTEM_USEID = Integer.MAX_VALUE;
    private static User USER_SYSTEM = null;
    private boolean bLogined = false;
    private CMyDateTime dtLastLoginTime = null;
    private static final char[] INVALID_FOR_NAME = new char[]{'~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '\'', '\"', ':', '>', '<', '?'};
    private boolean m_bCacheGroupsAndRoles = false;
    private Groups m_oGroups = null;
    private Roles m_oRoles = null;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 204;
    }

    public boolean isValidInstance() {
        return super.isValidInstance() || this.isSystem();
    }

    public boolean isSystem() {
        return this.id == Integer.MAX_VALUE;
    }

    public boolean isForbidden() {
        return this.getStatus() == 20;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof User)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        User user = (User)object;
        return this.isSystem() && user.isSystem();
    }

    public String getName() {
        return (String)this.getProperty("USERNAME");
    }

    public boolean nameIs(String string) {
        if (string == null) {
            return false;
        }
        return string.compareTo(this.getName()) == 0;
    }

    public boolean setName(String string) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(User.class, "User.label1", "\u7528\u6237\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539(User.setName)"));
        }
        return this.setProperty("USERNAME", string);
    }

    public boolean setPassword(String string) throws WCMException {
        int n = string.length();
        if (n < 8) {
            throw new WCMException(1104, I18NMessage.get(User.class, "User.label2", "\u5bc6\u7801\u8981\u6c42\u81f3\u5c114\u4e2a\u5b57\u7b26 (User.setPassword)"));
        }
        return this.setProperty("PASSWORD", string);
    }

    public String getReminderQuestion() {
        return (String)this.getProperty("REMINDERQUESTION");
    }

    public boolean setReminderQuestion(String string) throws WCMException {
        return this.setProperty("REMINDERQUESTION", string);
    }

    public String getReminderAnswer() {
        return (String)this.getProperty("REMINDERANSWER");
    }

    public boolean setReminderAnswer(String string) throws WCMException {
        return this.setProperty("REMINDERANSWER", string);
    }

    public String getNickName() {
        return (String)this.getProperty("NICKNAME");
    }

    public boolean setNickName(String string) throws WCMException {
        return this.setProperty("NICKNAME", string);
    }

    public String getTrueName() {
        return (String)this.getProperty("TRUENAME");
    }

    public boolean setTrueName(String string) throws WCMException {
        return this.setProperty("TRUENAME", string);
    }

    public String getAddress() {
        return (String)this.getProperty("ADDRESS");
    }

    public boolean setAddress(String string) throws WCMException {
        return this.setProperty("ADDRESS", string);
    }

    public String getTel() {
        return (String)this.getProperty("TEL");
    }

    public boolean setTel(String string) throws WCMException {
        return this.setProperty("TEL", string);
    }

    public String getMobile() {
        return (String)this.getProperty("MOBILE");
    }

    public boolean setMobile(String string) throws WCMException {
        return this.setProperty("MOBILE", string);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String string) throws WCMException {
        return this.setProperty("EMAIL", string);
    }

    public int getStatus() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    public boolean setStatus(int n) throws WCMException {
        if (!this.setProperty("STATUS", n)) {
            return false;
        }
        if (n == 30) {
            return this.setRegTime();
        }
        return true;
    }

    public String getStatusString() {
        if (this.isDeleted()) {
            return I18NMessage.get(User.class, "User.label3", "\u5df2\u5220\u9664");
        }
        return User.getStatusString(this.getStatus());
    }

    public int getLoginTimes() {
        return this.getPropertyAsInt("LOGINTIMES", 0);
    }

    public CMyDateTime getRegTime() {
        return this.getPropertyAsDateTime("REGTIME");
    }

    private boolean setRegTime() throws WCMException {
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithCurrentTime();
        return this.setProperty("REGTIME", cMyDateTime);
    }

    public CMyDateTime getLoginTime() {
        return this.getPropertyAsDateTime("LOGINTIME");
    }

    public CMyDateTime getLastLoginTime() {
        return this.dtLastLoginTime;
    }

    public boolean isPubMyInfo() {
        return this.getPropertyAsBoolean("IFPUBMYINFO", true);
    }

    public boolean setPubMyInfo(boolean bl) throws WCMException {
        return this.setProperty("IFPUBMYINFO", bl);
    }

    public int getMsgInterval() {
        return this.getPropertyAsInt("MSGINTERVAL", 0);
    }

    public boolean setMsgInterval(int n) throws WCMException {
        return this.setProperty("MSGINTERVAL", n);
    }

    public int getViewInterval() {
        return this.getPropertyAsInt("VIEWINTERVAL", 0);
    }

    public boolean setViewInterval(int n) throws WCMException {
        return this.setProperty("VIEWINTERVAL", n);
    }

    public int getPrice() {
        return this.getPropertyAsInt("PRICE", 0);
    }

    public boolean setPrice(int n) throws WCMException {
        return this.setProperty("PRICE", n);
    }

    public String getLoginIP() {
        return this.getAttributeValue("LOGINIP");
    }

    public boolean isDeleted() {
        return this.getPropertyAsBoolean("ISDELETED", true);
    }

    public boolean setDeleted(boolean bl) throws WCMException {
        return this.setProperty("ISDELETED", bl);
    }

    public int getPasswordLev() {
        return this.getPropertyAsInt("PASSWORDLEV", 0);
    }

    public boolean setPasswordLev(int n) throws WCMException {
        return this.setProperty("PASSWORDLEV", n);
    }

    private String cryptPassword(String string) {
        if (string == null) {
            return null;
        }
        return new CMyEncrypt().getMD5OfStr(string).substring(0, 15);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String string = (String)this.getAllProperty().get("USERNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(User.class, "User.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(User.isValid)"));
            }
            this.assertValidName(string);
            if ((String)this.getAllProperty().get("PASSWORD") == null) {
                throw new WCMException(1106, I18NMessage.get(User.class, "User.label5", "\u5c5e\u6027Password\u6ca1\u6709\u8bbe\u7f6e(User.isValid)"));
            }
            if ((string = string.toLowerCase()).compareTo(SYSTEM_USERNAME) == 0) {
                throw new WCMException(1104, I18NMessage.get(User.class, "User.label6", "\u7528\u6237\u540d") + SYSTEM_USERNAME + I18NMessage.get(User.class, "User.label7", "\u7981\u6b62\u4f7f\u7528\uff08User.isValid\uff09"));
            }
            String string2 = "UserName='" + CMyString.filterForSQL(string) + "'";
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(User.class, "User.label6", "\u7528\u6237\u540d") + string + I18NMessage.get(User.class, "User.label8", "\u5df2\u7ecf\u5b58\u5728\uff08User.isValid\uff09"));
            }
            this.setName(string);
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(User.class, "User.label9", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(User.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getProperty("ISDELETED") == null) {
                this.setDeleted(false);
            }
            if (this.getProperty("CRTIME") == null) {
                this.setCrTime();
            }
            if (this.getProperty("STATUS") == null) {
                this.setProperty("STATUS", 0L);
            }
            this.setProperty("LOGINTIMES", 0L);
            this.setProperty("PASSWORD", this.cryptPassword((String)this.getAllProperty().get("PASSWORD")));
            super.insert(user);
        }
    }

    public void update(User user) throws WCMException {
        if (this.isChangeProperty("PASSWORD")) {
            this.setProperty("PASSWORD", this.cryptPassword(this.getNewPropertyAsString("PASSWORD")));
        }
        super.update(user);
    }

    public boolean isLogined() {
        return this.bLogined;
    }

    public boolean passwordIs(String string) {
        String string2 = (String)this.getAllProperty().get("PASSWORD");
        if (string2 == null) {
            return false;
        }
        return string2.compareTo(this.cryptPassword(string)) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int login(String string, String string2) throws WCMException {
        int n;
        if (this.getAllProperty() == null) {
            return -1;
        }
        if (this.isDeleted()) {
            return 10;
        }
        int n2 = this.getStatus();
        if (n2 != 30) {
            return n2;
        }
        if (!this.passwordIs(string)) {
            return -1;
        }
        if (this.bLogined) {
            this.logout();
        }
        User user = this;
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.canEdit(user)) {
            return -2;
        }
        try {
            CMyDateTime cMyDateTime = this.getPropertyAsDateTime("LOGINTIME");
            CMyDateTime cMyDateTime2 = this.dtLastLoginTime = cMyDateTime == null ? null : (CMyDateTime)cMyDateTime.clone();
            if (cMyDateTime == null) {
                cMyDateTime = new CMyDateTime();
            }
            cMyDateTime.setDateTimeWithCurrentTime();
            this.setProperty("LOGINTIME", cMyDateTime);
            int n3 = this.getLoginTimes();
            this.setProperty("LOGINTIMES", n3 + 1);
            this.setAttribute("LoginIP", string2);
            this.update(user);
            this.bLogined = true;
            n = n2;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object var9_10 = null;
                if (!this.isLocked()) break block12;
                this.cancelUpdate(this);
            }
            throw throwable;
        }
        if (this.isLocked()) {
            this.cancelUpdate(this);
        }
        return n;
    }

    public void logout() {
        if (!this.bLogined) {
            return;
        }
        this.bLogined = false;
    }

    public static String getStatusString(int n) {
        switch (n) {
            case 0: {
                return I18NMessage.get(User.class, "User.label10", "\u5f85\u5f00\u901a");
            }
            case 10: {
                return I18NMessage.get(User.class, "User.label3", "\u5df2\u5220\u9664");
            }
            case 20: {
                return I18NMessage.get(User.class, "User.label11", "\u5df2\u505c\u7528");
            }
            case 30: {
                return I18NMessage.get(User.class, "User.label12", "\u5df2\u5f00\u901a");
            }
        }
        return I18NMessage.get(User.class, "User.label13", "\u672a\u77e5");
    }

    public boolean isAdministrator() throws WCMException {
        return Users.findAdministrators().indexOf(this.getId()) >= 0;
    }

    public void setCacheGroupsAndRoles(boolean bl) {
        this.m_bCacheGroupsAndRoles = bl;
        if (!bl) {
            if (this.m_oGroups != null) {
                this.m_oGroups.clear();
                this.m_oGroups = null;
            }
            if (this.m_oRoles != null) {
                this.m_oRoles.clear();
                this.m_oRoles = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Groups getGroups() throws WCMException {
        if (this.m_bCacheGroupsAndRoles) {
            if (this.m_oGroups == null) {
                User user = this;
                synchronized (user) {
                    if (this.m_oGroups == null) {
                        this.m_oGroups = this.initGroups();
                    }
                }
            }
            return this.m_oGroups;
        }
        return this.initGroups();
    }

    private Groups initGroups() throws WCMException {
        Groups groups = ((GroupUserCacheMgr)DreamFactory.createObjectById("GroupUserCacheMgr")).getGroups(this);
        Groups groups2 = new Groups(this);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            groups2.addElement(group);
        }
        return groups2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roles getRoles() throws WCMException {
        if (this.m_bCacheGroupsAndRoles) {
            if (this.m_oRoles == null) {
                User user = this;
                synchronized (user) {
                    if (this.m_oRoles == null) {
                        this.m_oRoles = this.initRoles();
                    }
                }
            }
            return this.m_oRoles;
        }
        return this.initRoles();
    }

    private Roles initRoles() throws WCMException {
        Roles roles = ((RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr")).getRoles(this);
        Roles roles2 = new Roles(this);
        for (int i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null) continue;
            roles2.addElement(role);
        }
        if (roles.indexOf(2) < 0) {
            Role role = Role.findById(2);
            roles2.addElement(role);
        }
        return roles2;
    }

    public Rights getMyRights(int n) throws WCMException {
        WCMFilter wCMFilter = null;
        Rights rights = null;
        try {
            wCMFilter = new WCMFilter("", "OprType=" + this.getWCMType() + " and OprId=" + this.getId() + " and ObjType=" + n, "");
            rights = new Rights(null);
            rights.open(wCMFilter);
            return rights;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(User.class, "User.label14", "\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(User.getMyRights)"), exception);
        }
    }

    public RightValue getMyRightValue(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(User.class, "User.label15", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(User.getMyRightValue)"));
        }
        return this.getMyRightValue(cMSObj.getWCMType(), cMSObj.getId());
    }

    public RightValue getMyRightValue(int n, int n2) throws WCMException {
        RightValue rightValue = new RightValue();
        try {
            rightValue.load(this, n, n2);
            return rightValue;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(User.class, "User.label16", "\u83b7\u53d6\u7528\u6237\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(User.getMyRightValue)"), exception);
        }
    }

    public DocLevel getDocLevel() throws WCMException {
        int n = this.getDocLevleId();
        if (n == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(n);
    }

    public boolean setDocLevel(DocLevel docLevel) throws WCMException {
        if (docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("VIEWDOCLEVEL", 0);
    }

    public boolean setDocLevel(int n) throws WCMException {
        return this.setProperty("VIEWDOCLEVEL", n);
    }

    public static final User findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        if (n == Integer.MAX_VALUE && USER_SYSTEM != null) {
            return USER_SYSTEM;
        }
        return (User)BaseObj.findById(User.class, n);
    }

    public static final User createNewInstance() throws WCMException {
        return (User)BaseObj.createNewInstance(User.class);
    }

    public static final User findByKey(Object object) throws WCMException {
        if ((Integer)object == Integer.MAX_VALUE) {
            return User.getSystem();
        }
        return (User)BaseObj.findByKey(User.class, object);
    }

    public static IUserCacheMgr getUserCacheMgr() throws WCMException {
        IUserCacheMgr iUserCacheMgr = (IUserCacheMgr)DreamFactory.createObjectById("IUserCacheMgr");
        if (iUserCacheMgr == null) {
            throw new WCMException(10, "IUserCacheMgr config invalid!");
        }
        return iUserCacheMgr;
    }

    public static final User findByName(String string) {
        if (SYSTEM_USERNAME.equals(string)) {
            return User.getSystem();
        }
        try {
            return User.getUserCacheMgr()._getUserByName(string);
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)I18NMessage.get(User.class, "User.label17", "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff01"), (Throwable)wCMException);
            return null;
        }
    }

    public static final User getSystem() {
        if (USER_SYSTEM == null) {
            User.makeSystem();
        }
        return USER_SYSTEM;
    }

    private static final synchronized void makeSystem() {
        if (USER_SYSTEM != null) {
            return;
        }
        try {
            User user = new User();
            user.setName(SYSTEM_USERNAME);
            user.setTrueName(I18NMessage.get(User.class, "User.label18", "\u865a\u62df\u7684\u7cfb\u7edf\u7528\u6237"));
            user.setAttribute("LOGINIP", "127.0.0.1");
            user.id = Integer.MAX_VALUE;
            USER_SYSTEM = user;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(User.class, "User.label19", "[\u7528\u6237-") + this.getId() + "]";
    }

    private void assertValidName(String string) throws WCMException {
        String string2 = "";
        char[] cArray = INVALID_FOR_NAME;
        for (int i = 0; i < cArray.length; ++i) {
            if (string.indexOf(cArray[i]) == -1) continue;
            string2 = string2 + cArray[i];
        }
        if (string2.length() > 0) {
            throw new WCMException(10, I18NMessage.get(User.class, "User.label20", "\u65e0\u6548\u7684\u7528\u6237\u540d[") + string + I18NMessage.get(User.class, "User.label21", "],\u7528\u6237\u540d\u542b\u6709\u7279\u6b8a\u5b57\u7b26[") + string2 + "]!");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getAllProperty());
        objectOutputStream.writeObject(this.getNewProperties());
        objectOutputStream.writeInt(this.getId());
        objectOutputStream.writeBoolean(this.isAddMode());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setProperties((Hashtable)objectInputStream.readObject());
        this.setNewProperties((Hashtable)objectInputStream.readObject());
        this.id = objectInputStream.readInt();
        this.bAddMode = objectInputStream.readBoolean();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"trsdemo123", "trswcmadmin", "trsadmin@196", "trsadmin", "11111111", "12345678", "88888888"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
            System.out.println(new CMyEncrypt().getMD5OfStr(stringArray2[i]).substring(0, 15));
        }
    }
}

