/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class RoleUser
extends CMSObj {
    public static final int OBJ_TYPE = -1643208931;
    public static final String DB_TABLE_NAME = "WCMROLEUSER";
    public static final String DB_ID_NAME = "ROLEUSERID";
    public static final int SITEID_FOR_SPECIAL_ROLE = -1;
    public static final int SITEID_FOR_ALL_SITES = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return -1643208931;
    }

    public int getRoleId() {
        return this.getPropertyAsInt("ROLEID", 0);
    }

    public boolean setRoleId(int n) throws WCMException {
        return this.setProperty("ROLEID", n);
    }

    public int getUserId() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public boolean setUserId(int n) throws WCMException {
        return this.setProperty("USERID", n);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public boolean setSiteId(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("ROLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(RoleUser.class, "RoleUser.label1", "\u5c5e\u6027RoleId\u6ca1\u6709\u8bbe\u7f6e(RoleUser.isValid)"));
            }
            if (this.getAllProperty().get("USERID") == null) {
                throw new WCMException(1106, I18NMessage.get(RoleUser.class, "RoleUser.label2", "\u5c5e\u6027UserId\u6ca1\u6709\u8bbe\u7f6e(RoleUser.isValid)"));
            }
            int n = this.getRoleId();
            Role role = Role.findById(n);
            if (role == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272RoleId[" + n + "]\u4e0d\u5b58\u5728");
            }
            if (role.getRoleType() == 0 && this.getSiteId() != -1) {
                throw new WCMException(10, "\u53c2\u6570\u4e0d\u517c\u5bb9\uff0c\u7279\u5b9a\u89d2\u8272\u7684SiteId\u5e94\u8be5\u4e3a-1");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(RoleUser.class, "RoleUser.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(RoleUser.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("CRUSER") == null) {
                this.setCrUser(user);
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(user);
        }
    }

    public static final RoleUser findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (RoleUser)BaseObj.findById(RoleUser.class, n);
    }

    public static final RoleUser createNewInstance() throws WCMException {
        return (RoleUser)BaseObj.createNewInstance(RoleUser.class);
    }

    public static final RoleUser findByKey(Object object) throws WCMException {
        return (RoleUser)BaseObj.findByKey(RoleUser.class, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u89d2\u8272\u7528\u6237[RoleId=").append(this.getRoleId());
        stringBuffer.append(", UserId=").append(this.getUserId());
        stringBuffer.append(", Id=").append("]");
        return stringBuffer.toString();
    }
}

