/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Role
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = 7232302897977228998L;
    public static final int OBJ_TYPE = 203;
    public static final String DB_TABLE_NAME = "WCMROLE";
    public static final String DB_ID_NAME = "ROLEID";
    public static final int ADMINISTRATORS_ID = 1;
    public static final int EVERYONE_ID = 2;
    public static final String ROLEMANAGERS_NAME = "RoleManagers";
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SPECIAL = 0;
    public static final int TYPE_SYSTEM = -1;
    public static final int TYPE_SITE = -2;
    public static final int RANGE_ADMINISTRATOR = -1;
    public static final int RANGE_ALL = 1;
    public static final int RANGE_GROUP = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 203;
    }

    public String getName() {
        return (String)this.getProperty("ROLENAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("ROLENAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("ROLEDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("ROLEDESC", string);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public StringTokenizer getEmails() {
        String string = this.getEmail();
        if (string == null) {
            return null;
        }
        return new StringTokenizer(string, ";");
    }

    public boolean setEmail(String string) throws WCMException {
        return this.setProperty("EMAIL", string);
    }

    public boolean isSysDefined() {
        return this.getPropertyAsBoolean("SYSDEFINED", true);
    }

    public boolean setSysDefined(boolean bl) throws WCMException {
        return this.setProperty("SYSDEFINED", bl);
    }

    public boolean isViewable() {
        return this.getPropertyAsBoolean("VIEWABLE", false);
    }

    public boolean setViewable(boolean bl) throws WCMException {
        return this.setProperty("VIEWABLE", bl);
    }

    public boolean isRemoveable() {
        return this.getPropertyAsBoolean("REMOVEABLE", false);
    }

    public boolean setRemoveable(boolean bl) throws WCMException {
        return this.setProperty("REMOVEABLE", bl);
    }

    public boolean setRoleType(int n) throws WCMException {
        return this.setProperty("RoleType", n);
    }

    public int getRoleType() {
        return this.getPropertyAsInt("RoleType", 0);
    }

    public boolean isSystemRole() {
        return this.getRoleType() == -1 || this.getRoleType() == -2;
    }

    public boolean setRoleRange(int n) throws WCMException {
        return this.setProperty("RoleRange", n);
    }

    public int getRoleRange() {
        return this.getPropertyAsInt("RoleRange", 0);
    }

    public boolean setRightValue(long l) throws WCMException {
        return this.setProperty("RightValue", l);
    }

    public long getRightValue() {
        return this.getPropertyAsLong("RightValue", -1L);
    }

    public int getRoleOrder() {
        return this.getPropertyAsInt("RoleOrder", 0);
    }

    public boolean setRoleOrder(int n) throws WCMException {
        return this.setProperty("RoleOrder", n);
    }

    public boolean isValid() throws WCMException {
        Object object;
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("ROLENAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Role.class, "Role.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Role.isValid)"));
            }
            object = this.getProperty("REMOVEABLE");
            if (object == null) {
                this.setRemoveable(true);
            }
            if ((object = this.getProperty("VIEWABLE")) == null) {
                this.setViewable(true);
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Role.class, "Role.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Role.isValid)"));
            }
            string = (String)this.getNewProperty("ROLENAME");
        }
        if (string != null) {
            object = "RoleName='" + CMyString.filterForSQL(string) + "'";
            if (!this.isAddMode()) {
                object = (String)object + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists((String)object)) {
                throw new WCMException(1108, CMyString.format(I18NMessage.get(Role.class, "Role.label3", "\u89d2\u8272\u540d\u79f0[{0}]\u5df2\u7ecf\u5b58\u5728\uff08Role.isValid\uff09"), new String[]{string}));
            }
        }
        this.changeOrder();
        return true;
    }

    public Users getUsers(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("wcmRoleUser", "RoleId=" + this.getId(), "", "UserId");
        Users users = new Users(user);
        try {
            users.open(wCMFilter);
            return users;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label4", "\u83b7\u53d6\u89d2\u8272\u4e2d\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519\uff08Role.getUsers\uff09"), wCMException);
        }
    }

    public Rights getMyRights(int n) throws WCMException {
        WCMFilter wCMFilter = null;
        Rights rights = null;
        try {
            wCMFilter = new WCMFilter("", "OprType=" + this.getWCMType() + " and ObjId=" + this.getId() + " and ObjType=" + n, "");
            rights = new Rights(null);
            rights.open(wCMFilter);
            return rights;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label5", "\u83b7\u53d6\u89d2\u8272\u7684\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(Role.getMyRights)"), wCMException);
        }
    }

    public RightValue getMyRightValue(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Role.class, "Role.label6", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(Role.getMyRightValue)"));
        }
        return this.getMyRightValue(cMSObj.getWCMType(), cMSObj.getId());
    }

    public RightValue getMyRightValue(int n, int n2) throws WCMException {
        RightValue rightValue = new RightValue();
        try {
            rightValue.load(this, n, n2);
            return rightValue;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Role.class, "Role.label7", "\u83b7\u53d6\u89d2\u8272\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(Role.getMyRightValue)"), wCMException);
        }
    }

    public boolean isAdministrators() {
        return this.id == 1;
    }

    public boolean isEveryone() {
        return this.id == 2;
    }

    public boolean isRoleManagers() {
        return ROLEMANAGERS_NAME.equals(this.getName());
    }

    public static final Role findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Role)BaseObj.findById(Role.class, n);
    }

    public static final Role createNewInstance() throws WCMException {
        return (Role)BaseObj.createNewInstance(Role.class);
    }

    public static final Role findByKey(Object object) throws WCMException {
        return (Role)BaseObj.findByKey(Role.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Role.class, "Role.label8", "[\u89d2\u8272-") + this.getId() + "]";
    }

    private void changeOrder() throws WCMException {
        if (this.isAddMode()) {
            String string = "select max(roleorder) from " + this.getDbTableName() + " where VIEWABLE=1";
            DBManager dBManager = DBManager.getDBManager();
            if (dBManager == null || !dBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01");
            }
            if (!dBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u6ca1\u6709\u542f\u52a8\uff01");
            }
            int n = dBManager.sqlExecuteIntQuery(string);
            this.setRoleOrder(++n);
        } else {
            Role role;
            int n;
            if (!this.isChangeProperty("RoleOrder")) {
                return;
            }
            int n2 = this.getNewPropertyAsInt("RoleOrder", 0);
            int n3 = this.getPropertyAsInt("RoleOrder", 0);
            WCMFilter wCMFilter = new WCMFilter("", "VIEWABLE=1", "ROLEORDER ASC", "RoleId");
            Roles roles = Roles.openWCMObjs(null, wCMFilter);
            int n4 = roles.size();
            int n5 = 0;
            int n6 = 1;
            if (n2 < 0 || n2 >= n4) {
                n2 = n4;
                n6 = 0;
                n5 = roles.getIdAt(n2 - 1);
            } else if (n2 == 0) {
                n5 = roles.getIdAt(0);
            } else if (n2 > 0 && n3 > (n = (role = Role.findById(n5 = roles.getIdAt(n2 - 1))).getRoleOrder())) {
                n6 = 0;
            }
            if (n5 != this.getId()) {
                role = Role.findById(n5);
                n = n3;
                int n7 = role.getRoleOrder();
                if (this.equals(role) || n == n7) {
                    return;
                }
                int n8 = n;
                int n9 = n - n7;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                switch (n6) {
                    case 1: {
                        if (n9 == 0) {
                            return;
                        }
                        if (n9 > 0) {
                            n10 = n7;
                            n11 = n - 1;
                            n8 = n10;
                            n12 = 1;
                            break;
                        }
                        if (n9 >= 0) break;
                        n10 = n + 1;
                        n8 = n11 = n7;
                        n12 = -1;
                        break;
                    }
                    case 0: {
                        if (n9 == 0) {
                            return;
                        }
                        if (n9 > 0) {
                            n10 = n7;
                            n11 = n - 1;
                            n8 = n10;
                            n12 = 1;
                            break;
                        }
                        if (n9 >= 0) break;
                        n10 = n + 1;
                        n8 = n11 = n7;
                        n12 = -1;
                    }
                }
                String string = "RoleOrder>=" + n10 + " AND RoleOrder <=" + n11 + " and VIEWABLE=1";
                String string2 = "UPDATE WCMROLE SET RoleOrder = RoleOrder+(" + n12 + ") WHERE " + string;
                WCMFilter wCMFilter2 = new WCMFilter("", string, "RoleOrder ASC");
                Roles roles2 = Roles.openWCMObjs(null, wCMFilter2);
                DBManager.getDBManager().sqlExecuteUpdate(string2);
                for (int i = 0; i < roles2.size(); ++i) {
                    Role role2 = (Role)roles2.getAt(i);
                    if (role2 == null) continue;
                    role2.refreshProperty("RoleOrder", role2.getRoleOrder() + n12);
                }
                this.setRoleOrder(n8);
            }
        }
    }
}

