/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import org.aton.cache.LRUCacheContainer;

public class GroupUserCacheMgr
implements ICacheMgr {
    public static int MAX_CACHE_SIZE = 52000;
    private LRUCacheContainer m_lruGroupsCache = new LRUCacheContainer();

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (this.isListening(baseObj)) {
            GroupUser groupUser = (GroupUser)baseObj;
            this.addToCache(groupUser.getUserId(), groupUser.getGroupId());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj)) {
            GroupUser groupUser = (GroupUser)baseObj;
            this.removeFromCache(groupUser.getUserId(), groupUser.getGroupId());
        }
    }

    public boolean init() throws WCMException {
        Users users = Users.openWCMObjs(null, null);
        int n = MAX_CACHE_SIZE;
        if (n < MAX_CACHE_SIZE && (n = (int)((double)n * 1.5)) > MAX_CACHE_SIZE) {
            n = MAX_CACHE_SIZE;
        }
        this.m_lruGroupsCache.setMaxSize(n);
        User user = null;
        for (int i = 0; i < 1000 && i < users.size(); ++i) {
            user = (User)users.getAt(i);
            if (user == null) continue;
            this.initCache(user.getId());
        }
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        if (this.m_lruGroupsCache != null) {
            this.m_lruGroupsCache.clear();
            this.m_lruGroupsCache = null;
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
    }

    final Groups getGroups(User user) throws WCMException {
        return this.getGroups(user.getId());
    }

    private void addToCache(int n, int n2) throws WCMException {
        Groups groups = this.getGroups(n);
        if (groups.indexOf(n2) == -1) {
            groups.addElement(n2);
        }
    }

    private void removeFromCache(int n, int n2) throws WCMException {
        Groups groups = this.getGroups(n);
        groups.remove(n2, false);
    }

    private Groups getGroups(int n) throws WCMException {
        Integer n2 = new Integer(n);
        Groups groups = (Groups)this.m_lruGroupsCache.get((Object)n2);
        if (groups == null && (groups = this.initCache(n)).isEmpty()) {
            this.m_lruGroupsCache.put((Object)n2, (Object)groups);
        }
        return groups;
    }

    private synchronized Groups initCache(int n) throws WCMException {
        Integer n2 = new Integer(n);
        Groups groups = (Groups)this.m_lruGroupsCache.get((Object)n2);
        if (groups != null) {
            return groups;
        }
        String string = "UserId=?";
        WCMFilter wCMFilter = new WCMFilter("WCMGrpUser", string, "GroupId");
        wCMFilter.addSearchValues(n);
        groups = Groups.openWCMObjs(User.getSystem(), wCMFilter);
        if (groups.isEmpty()) {
            return new Groups(null);
        }
        this.m_lruGroupsCache.put((Object)n2, (Object)groups);
        return groups;
    }

    private boolean isListening(BaseObj baseObj) {
        return baseObj != null && baseObj instanceof GroupUser;
    }
}

