/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.GroupAdminsCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class Group
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = -2265204905756007169L;
    public static final int OBJ_TYPE = 201;
    public static final String DB_TABLE_NAME = "WCMGROUP";
    public static final String DB_ID_NAME = "GROUPID";
    private Hashtable hAdministrator = null;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 201;
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public Group getParent() throws WCMException {
        return Group.findById(this.getParentId());
    }

    public boolean setParent(int n) throws WCMException {
        return this.setProperty("PARENTID", n);
    }

    public boolean setParent(Group group) throws WCMException {
        if (group != null && !group.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Group.class, "Group.label1", "\u65e0\u6548\u7684\u7236\u7ec4\u5bf9\u8c61(Group.setParent)"));
        }
        return this.setParent(group == null ? 0 : group.getId());
    }

    public String getName() {
        return (String)this.getProperty("GNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("GNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("GDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("GDESC", string);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String string) throws WCMException {
        return this.setProperty("EMAIL", string);
    }

    public int getGroupOrder() {
        return this.getPropertyAsInt("GroupOrder", 0);
    }

    public boolean setGroupOrder(int n) throws WCMException {
        return this.setProperty("GroupOrder", n);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("GNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Group.class, "Group.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Group.isValid)"));
            }
            int n = this.getParentId();
            if (n != 0 && Group.findById(n) == null) {
                throw new WCMException(1104, I18NMessage.get(Group.class, "Group.label3", "\u6307\u5b9a\u7684ParentId\u65e0\u6548(Group.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Group.class, "Group.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Group.isValid)"));
            }
            string = (String)this.getNewProperty("GNAME");
        }
        if (string != null) {
            String string2 = "(ParentId=" + this.getParentId() + ") and (GName='" + CMyString.filterForSQL(string) + "')";
            if (!this.isAddMode()) {
                string2 = string2 + " and (" + this.getIdFieldName() + "<>" + this.getId() + ")";
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(Group.class, "Group.label5", "\u7ec4\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Group.isValid\uff09"));
            }
        }
        this.changeOrder();
        return true;
    }

    public Users getUsers(User user) throws WCMException {
        return this.getUsers(user, null);
    }

    public Users getUsers(User user, String string) throws WCMException {
        WCMFilter wCMFilter = null;
        Users users = new Users(user);
        wCMFilter = string == null || string.trim().length() == 0 ? new WCMFilter("wcmGrpUser", "GroupId=" + this.getId(), "", "UserId") : new WCMFilter("wcmUser, wcmGrpUser", "(wcmGrpUser.GroupId=" + this.getId() + ") and (wcmUser.UserId=wcmGrpUser.UserId) ", string, "wcmUser.USERID");
        try {
            users.open(wCMFilter);
            return users;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label6", "\u53d6\u7ec4\u4e2d\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519(Group.getUsers)"), wCMException);
        }
    }

    public Groups getChildren(User user) throws WCMException {
        return this.getChildren(user, "");
    }

    public Groups getChildren(User user, String string) throws WCMException {
        try {
            WCMFilter wCMFilter = new WCMFilter("", "ParentId=" + this.getId(), string);
            Groups groups = new Groups(user);
            groups.open(wCMFilter);
            return groups;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label7", "\u53d6\u7ec4\u7684\u5b50\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(Group.getChildren)"), wCMException);
        }
    }

    public boolean addUser(int n, User user) throws WCMException {
        User user2 = User.findById(n);
        return this.addUser(user2, user, false);
    }

    public boolean addUser(int n, User user, boolean bl) throws WCMException {
        User user2 = User.findById(n);
        return this.addUser(user2, user, bl);
    }

    public boolean addUser(User user, User user2) throws WCMException {
        return this.addUser(user, user2, false);
    }

    /*
     * Loose catch block
     */
    public boolean addUser(User user, User user2, boolean bl) throws WCMException {
        block29: {
            Exception exception322;
            Statement statement;
            Statement statement2;
            Connection connection;
            block27: {
                block26: {
                    String string;
                    block23: {
                        Exception exception2222;
                        boolean bl2;
                        block24: {
                            connection = null;
                            statement2 = null;
                            ResultSet resultSet = null;
                            statement = null;
                            if (user == null || !user.isValidInstance()) {
                                throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label8", "\u8981\u52a0\u5165\u7ec4\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
                            }
                            if (user2 == null || !user2.isValidInstance()) {
                                throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label9", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
                            }
                            int n = user.getId();
                            boolean bl3 = false;
                            connection = this.getDBManager().getConnection();
                            string = "select count(*) from wcmGrpUser where GroupId=" + this.getId() + " and UserId=" + n;
                            statement2 = connection.createStatement();
                            resultSet = statement2.executeQuery(string);
                            resultSet.next();
                            bl3 = resultSet.getInt(1) > 0;
                            resultSet.close();
                            statement2.close();
                            if (!bl3) break block23;
                            bl2 = false;
                            Object var13_15 = null;
                            if (statement2 == null) break block24;
                            try {
                                statement2.close();
                            }
                            catch (Exception exception2222) {
                                exception2222.printStackTrace();
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception exception2222) {
                                exception2222.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            this.getDBManager().freeConnection(connection);
                        }
                        return bl2;
                    }
                    string = "insert into wcmGrpUser(GroupId,UserId, isAdministrator, CrUser,CrTime) values(?,?,?,?,?)";
                    CMyDateTime cMyDateTime = new CMyDateTime();
                    cMyDateTime.setDateTimeWithCurrentTime();
                    statement = connection.prepareStatement(string);
                    statement.setInt(1, this.getId());
                    statement.setInt(2, user.getId());
                    statement.setInt(3, bl ? 1 : 0);
                    statement.setString(4, user2.getName());
                    statement.setTimestamp(5, cMyDateTime.toTimestamp());
                    statement.executeUpdate();
                    if (!bl) break block26;
                    this.addAdministrator(user);
                }
                Object var13_16 = null;
                if (statement2 == null) break block27;
                try {
                    statement2.close();
                }
                catch (Exception exception322) {
                    exception322.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception322) {
                    exception322.printStackTrace();
                }
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
            break block29;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(Group.class, "Group.label10", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), sQLException);
                }
                catch (Exception exception4) {
                    throw new WCMException(0, I18NMessage.get(Group.class, "Group.label10", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), exception4);
                }
            }
            catch (Throwable throwable) {
                Exception exception5222;
                Object var13_17 = null;
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (Exception exception5222) {
                        exception5222.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception5222) {
                        exception5222.printStackTrace();
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
        return true;
    }

    public void addAdministrator(User user) {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        }
        if (this.hAdministrator.containsKey(new Integer(user.getId()))) {
            return;
        }
        this.hAdministrator.put(new Integer(user.getId()), user);
    }

    public void removeAdministrator(User user) {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        }
        if (!this.hAdministrator.containsKey(new Integer(user.getId()))) {
            return;
        }
        this.hAdministrator.remove(new Integer(user.getId()));
    }

    private void refreshAdministrator() throws WCMException {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        } else {
            this.hAdministrator.clear();
        }
        Users users = null;
        try {
            WCMFilter wCMFilter = new WCMFilter("wcmGrpUser", "isAdministrator=1 and GroupId=" + this.getId(), "", "UserId");
            users = new Users(null);
            users.open(wCMFilter);
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.getAt(i);
                if (user == null) continue;
                this.hAdministrator.put(new Integer(user.getId()), user);
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label11", "\u53d6\u7528\u6237\u6240\u5728\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(User.getGroups)"), exception);
        }
    }

    public Users getAdministrator(User user) throws WCMException {
        if (this.hAdministrator == null) {
            this.refreshAdministrator();
        }
        Users users = new Users(user);
        Enumeration enumeration = this.hAdministrator.elements();
        while (enumeration.hasMoreElements()) {
            users.addElement((User)enumeration.nextElement());
        }
        return users;
    }

    public boolean isAdministrator(User user) throws WCMException {
        GroupAdminsCacheMgr groupAdminsCacheMgr = (GroupAdminsCacheMgr)DreamFactory.createObjectById("GroupAdminsCacheMgr");
        return groupAdminsCacheMgr.getAdmins(this).indexOf(user) >= 0;
    }

    public static final Group findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Group)BaseObj.findById(Group.class, n);
    }

    public static final Group createNewInstance() throws WCMException {
        return (Group)BaseObj.createNewInstance(Group.class);
    }

    public static final Group findByKey(Object object) throws WCMException {
        return (Group)BaseObj.findByKey(Group.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Group.class, "Group.label12", "[\u7ec4\u7ec7-") + this.getId() + "]";
    }

    private void changeOrder() throws WCMException {
        int n = this.getParentId();
        if (this.isAddMode()) {
            String string = "select max(grouporder) from " + this.getDbTableName() + " where parentid = " + n;
            DBManager dBManager = DBManager.getDBManager();
            if (dBManager == null || !dBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01");
            }
            if (!dBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u6ca1\u6709\u542f\u52a8\uff01");
            }
            int n2 = dBManager.sqlExecuteIntQuery(string);
            this.setGroupOrder(++n2);
        } else {
            Group group;
            int n3;
            if (!this.isChangeProperty("GroupOrder")) {
                return;
            }
            WCMFilter wCMFilter = new WCMFilter("", "PARENTID=" + n, "GROUPORDER ASC", "GroupId");
            Groups groups = Groups.openWCMObjs(null, wCMFilter);
            int n4 = groups.size();
            int n5 = 0;
            int n6 = this.getNewPropertyAsInt("GroupOrder", 0);
            int n7 = this.getId();
            int n8 = this.getPropertyAsInt("GroupOrder", 0);
            int n9 = 1;
            if (n6 < 0 || n6 >= n4) {
                n6 = n4;
                n9 = 0;
                n5 = groups.getIdAt(n6 - 1);
            } else if (n6 == 0) {
                n5 = groups.getIdAt(0);
            } else if (n6 > 0 && n8 > (n3 = (group = Group.findById(n5 = groups.getIdAt(n6 - 1))).getGroupOrder())) {
                n9 = 0;
            }
            if (n5 != n7) {
                group = Group.findById(n5);
                n3 = n8;
                int n10 = group.getGroupOrder();
                if (this.equals(group) || n3 == n10) {
                    return;
                }
                int n11 = n3;
                int n12 = n3 - n10;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                switch (n9) {
                    case 1: {
                        if (n12 == 0) {
                            return;
                        }
                        if (n12 > 0) {
                            n13 = n10;
                            n14 = n3 - 1;
                            n11 = n13;
                            n15 = 1;
                            break;
                        }
                        if (n12 >= 0) break;
                        n13 = n3 + 1;
                        n11 = n14 = n10;
                        n15 = -1;
                        break;
                    }
                    case 0: {
                        if (n12 == 0) {
                            return;
                        }
                        if (n12 > 0) {
                            n13 = n10;
                            n14 = n3 - 1;
                            n11 = n13;
                            n15 = 1;
                            break;
                        }
                        if (n12 >= 0) break;
                        n13 = n3 + 1;
                        n11 = n14 = n10;
                        n15 = -1;
                    }
                }
                String string = "GroupOrder>=" + n13 + " AND GroupOrder <=" + n14 + " and parentid = " + n;
                String string2 = "UPDATE WCMGROUP SET GroupOrder = GroupOrder+(" + n15 + ") WHERE " + string;
                WCMFilter wCMFilter2 = new WCMFilter("", string, "GROUPORDER ASC");
                Groups groups2 = Groups.openWCMObjs(null, wCMFilter2);
                DBManager.getDBManager().sqlExecuteUpdate(string2);
                for (int i = 0; i < groups2.size(); ++i) {
                    Group group2 = (Group)groups2.getAt(i);
                    if (group2 == null) continue;
                    group2.refreshProperty("GroupOrder", group2.getGroupOrder() + n15);
                }
                this.setGroupOrder(n11);
            }
        }
    }
}

