/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UpdUserScheduleCreator;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class UserMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)UserMgr.class.getName());
    public static final String USER_DEFAULT_PASSWORD = "trsadmin";

    public Rights getUserRightsOnWCMObj(int n) throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label1", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u5728\u5176\u5b83\u5bf9\u8c61\u4e0a\u62e5\u6709\u7684\u6743\u9650!"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "OprType=204 and OprId=" + ContextHelper.getLoginUser().getId() + " and ObjType=" + n, "");
        try {
            return Rights.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)(I18NMessage.get(UserMgr.class, "UserMgr.label2", "\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u5931\u8d25:") + wCMException.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label3", "\u83b7\u53d6\u7528\u6237\u5728[") + WCMTypes.getObjName(n, true) + I18NMessage.get(UserMgr.class, "UserMgr.label4", "]\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u5931\u8d25!"), wCMException);
        }
    }

    public RightValue getMyRightValue(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label5", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(User.getMyRightValue)"));
        }
        return this.getMyRightValue(cMSObj.getWCMType(), cMSObj.getId());
    }

    public RightValue getMyRightValue(int n, int n2) throws WCMException {
        try {
            RightValue rightValue = new RightValue();
            rightValue.load(ContextHelper.getLoginUser(), n, n2);
            return rightValue;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label6", "\u83b7\u53d6\u7528\u6237\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(User.getMyRightValue)"), exception);
        }
    }

    public Groups getGroups(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label7", "\u65e0\u6548\u7528\u6237\u5bf9\u8c61!"));
        }
        WCMFilter wCMFilter = new WCMFilter("wcmGrpUser", "UserId=" + user.getId(), "", "GroupId");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Roles getRoles(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label7", "\u65e0\u6548\u7528\u6237\u5bf9\u8c61!"));
        }
        Roles roles = Roles.createNewInstance(ContextHelper.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("wcmRoleUser", "UserId=" + user.getId(), "", "RoleId");
        roles = Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (roles.indexOf(2) < 0) {
            Role role = Role.findById(2);
            roles.addElement(role);
        }
        return roles;
    }

    public boolean delete(User user, boolean bl) throws WCMException {
        if (user == null) {
            throw new WCMException(20, I18NMessage.get(UserMgr.class, "UserMgr.label8", "\u6b32\u5220\u9664\u7684\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        if (user == ContextHelper.getLoginUser()) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label9", "\u60a8\u65e0\u6cd5\u5220\u9664\u81ea\u5df1\uff01"));
        }
        if (!bl) {
            user.canEdit(this.getLoginUser());
            user.setDeleted(true);
            this.save(user);
            return true;
        }
        try {
            GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
            Groups groups = this.getGroups(user);
            if (groups != null && !groups.isEmpty()) {
                for (int i = 0; i < groups.size(); ++i) {
                    groupMgr.removeUser(user, (Group)groups.getAt(i));
                }
            }
            RoleMgr roleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
            Roles roles = this.getRoles(user);
            if (roles != null && !roles.isEmpty()) {
                for (int i = 0; i < roles.size(); ++i) {
                    roleMgr.removeUser(user, (Role)roles.getAt(i));
                }
            }
            User user2 = this.getLoginUser();
            Rights rights = new Rights(user2);
            WCMFilter wCMFilter = new WCMFilter("WCMRIGHT", "OprType=? and OprId=?", "");
            wCMFilter.addSearchValues(204);
            wCMFilter.addSearchValues(user.getId());
            rights.open(wCMFilter);
            rights.removeAll(true);
            wCMFilter = new WCMFilter("", "MEMBERTYPE=? AND MEMBERID=?", "", "");
            wCMFilter.addSearchValues(204);
            wCMFilter.addSearchValues(user.getId());
            ObjectMembers objectMembers = ObjectMembers.openWCMObjs(user2, wCMFilter);
            objectMembers.removeAll(true);
            UpdUserScheduleCreator.scheduleUpdUserRelatedInfo(user, user2);
            user.canEdit(user2);
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(user.getName());
            stringBuffer.append('$');
            stringBuffer.append(user.getId());
            user.setProperty("USERNAME", stringBuffer.toString());
            user.setStatus(40);
            user.setDeleted(false);
            user.save(user2);
            return true;
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)wCMException.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label13", "\u5f7b\u5e95\u5220\u9664\u7528\u6237\u5931\u8d25!"), wCMException);
        }
        catch (Exception exception) {
            m_oLogger.debug((Object)("ex: " + exception.toString()));
            return false;
        }
    }

    public boolean changeUserRegStatus(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label14", "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u8981\u66f4\u6539\u7684\u7528\u6237\uff01"));
        }
        if (n == user.getStatus()) {
            return true;
        }
        if (!user.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(UserMgr.class, "UserMgr.label15", "\u5f53\u524d\u5bf9\u8c61\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a!"));
        }
        boolean bl = user.setStatus(n);
        user.update(ContextHelper.getLoginUser());
        return bl;
    }

    public Users getConsignUsers(int n) throws WCMException {
        String string = CMyDateTime.now().toString("yyyy-MM-dd");
        String string2 = "StartTime<=" + this.getDBManager().getDBType().sqlDateTime(string + " 23:59:59", "YYYY-MM-DD HH24:MI:SS") + " and EndTime>=" + this.getDBManager().getDBType().sqlDateTime(string + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        String string3 = "Status>0 and (" + string2 + ") and Module=" + n;
        String string4 = "EXISTS(select Trustee from wcmTrusteeInfo where " + string3 + ")";
        WCMFilter wCMFilter = new WCMFilter("WCMUSER", string4, "");
        try {
            return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)(I18NMessage.get(UserMgr.class, "UserMgr.label16", "\u83b7\u53d6\u6307\u5b9a\u6a21\u5757\u7684\u6240\u6709\u7684\u59d4\u6258\u4eba\u5931\u8d25:") + wCMException.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label17", "\u83b7\u53d6\u6307\u5b9a\u6a21\u5757\u7684\u6240\u6709\u7684\u59d4\u6258\u4eba\u5931\u8d25!"), wCMException);
        }
    }

    public Rights getMyRights(int n, int n2, int n3) throws WCMException {
        if (n != 204 && n != 203 && n != 201) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label18", "\u65e0\u6548\u7684\u64cd\u4f5c\u8005\u7c7b\u578b!"));
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label19", "\u65e0\u6548\u7684\u5bf9\u8c61id!"));
        }
        String string = "OprType=" + n + " and OprId=" + n2 + " and ObjType=" + n3;
        WCMFilter wCMFilter = new WCMFilter("WCMRIGHT", string, "");
        return Rights.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public User save(User user) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(UserMgr.class, "UserMgr.label20", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u7528\u6237\uff1aUserMgr.save"));
        this.validate(user);
        user = this.prepareSave(user);
        user.save(ContextHelper.getLoginUser());
        return user;
    }

    private void validate(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(20, I18NMessage.get(UserMgr.class, "UserMgr.label21", "\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        if (user.getName() == null) {
            throw new WCMException(1106, I18NMessage.get(UserMgr.class, "UserMgr.label22", "\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String string = user.getName().trim();
        int n = CMyString.getBytesLength(string);
        if (n < 3 || n > 50) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label23", "\u7528\u6237\u59d3\u540d\u4e0d\u5728\u957f\u5ea6\u8303\u56f4\u5185\uff01"));
        }
        if (!this.isNameValid(string)) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label24", "\u7528\u6237\u540d\u4e2d\u5305\u542b\u65e0\u6548\u5b57\u7b26\uff01"));
        }
        if (user.isAddMode() && User.findByName(string) != null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label25", "\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (string.compareTo("system") == 0) {
            throw new WCMException(1104, I18NMessage.get(UserMgr.class, "UserMgr.label26", "\u7528\u6237\u540d") + "system" + I18NMessage.get(UserMgr.class, "UserMgr.label27", "\u7981\u6b62\u4f7f\u7528"));
        }
    }

    private User prepareSave(User user) throws WCMException {
        String string;
        if (user.getNickName() == null) {
            user.setNickName(user.getName());
        }
        if ((string = user.getPropertyAsString("PASSWORD")) == null || string.trim().length() == 0) {
            user.setProperty("PASSWORD", USER_DEFAULT_PASSWORD);
        }
        return user;
    }

    public boolean resetPassword(User user, String string, String string2) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        if (!user.passwordIs(string)) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label29", "\u9519\u8bef\u7684\u65e7\u5bc6\u7801,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65e7\u5bc6\u7801!"));
        }
        if (!user.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(UserMgr.class, "UserMgr.label30", "\u5bf9\u8c61\u5df2\u7ecf\u88ab\u7528\u6237[") + user.getLockerUserName() + I18NMessage.get(UserMgr.class, "UserMgr.label31", "]\u9501\u5b9a!\u4e0d\u80fd\u88ab\u5f53\u524d\u7528\u6237[") + this.getLoginUserName() + I18NMessage.get(UserMgr.class, "UserMgr.label32", "]\u4fee\u6539!"));
        }
        user.setProperty("PASSWORD", string2);
        user.update(ContextHelper.getLoginUser());
        return true;
    }

    public boolean resetPassword(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        User user2 = this.getLoginUser();
        if (user2 == null) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label33", "\u64cd\u4f5c\u6ca1\u6709\u76f8\u5173\u7684\u7528\u6237!"));
        }
        String string = ConfigServer.getServer().getSysConfigValue("SYSUSERPWD", USER_DEFAULT_PASSWORD);
        user.canEdit(user2);
        user.setProperty("PASSWORD", string);
        user.update(user2);
        return true;
    }

    public boolean resetPassword(User user, String string) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        User user2 = this.getLoginUser();
        if (user2 == null) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label33", "\u64cd\u4f5c\u6ca1\u6709\u76f8\u5173\u7684\u7528\u6237!"));
        }
        user.canEdit(user2);
        user.setProperty("PASSWORD", string);
        user.update(user2);
        return true;
    }

    private boolean isNameValid(String string) {
        String string2 = "\\\"'!@#$%^&*()";
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (string.indexOf(string3) == -1) continue;
            return false;
        }
        return true;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label34", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label35", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        User user = this.getLoginUser();
        if (user == null) {
            return "";
        }
        return user.getName();
    }

    public boolean isAdminOfGroup(User user) throws WCMException {
        if (user == null) {
            return false;
        }
        String string = "SELECT COUNT(*) FROM WCMGRPUSER WHERE IsAdministrator=1 AND UserId=" + user.getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(string) >= 1;
    }

    public boolean isManagerOfRole(User user) throws WCMException {
        if (user == null) {
            return false;
        }
        String string = "SELECT COUNT(*) FROM WCMROLEUSER WHERE RoleId IN (SELECT RoleId FROM WCMROLE WHERE RoleName='RoleManagers') AND UserId=" + user.getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(string) >= 1;
    }

    public boolean isManagerOfUser(User user) throws WCMException {
        User user2 = ContextHelper.getLoginUser();
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = this.getGroups(user);
        if (groups == null || groups.isEmpty()) {
            return this.isAdminOfGroup(user2);
        }
        for (int i = 0; i < groups.size(); ++i) {
            if (!groupMgr.isAdministrator((Group)groups.getAt(i), user2, true)) continue;
            return true;
        }
        return false;
    }
}

