/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.RoleUsers;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class RoleMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)RoleMgr.class.getName());

    public boolean addUser(User user, Role role) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label1", "\u8981\u52a0\u5165\u89d2\u8272\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser roleUser = this.getRoleUser(user, role);
            if (roleUser != null) {
                return false;
            }
            roleUser = RoleUser.createNewInstance();
            roleUser.setRoleId(role.getId());
            roleUser.setUserId(user.getId());
            roleUser.setCrUser(ContextHelper.getLoginUser());
            roleUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), exception);
        }
        return true;
    }

    public boolean addUser(Role role, int n, User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label1", "\u8981\u52a0\u5165\u89d2\u8272\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser roleUser = this.getRoleUser(role, n, user);
            if (roleUser != null) {
                return false;
            }
            roleUser = RoleUser.createNewInstance();
            roleUser.setRoleId(role.getId());
            roleUser.setUserId(user.getId());
            roleUser.setSiteId(n);
            roleUser.setCrUser(ContextHelper.getLoginUser());
            roleUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), exception);
        }
        return true;
    }

    public boolean removeUser(User user, Role role) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if ("admin".equals(user.getName()) && role.getId() == 1) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label20", "\u4e0d\u80fd\u5c06admin\u7528\u6237\u4ece\u7cfb\u7edf\u7ba1\u7406\u5458\u89d2\u8272\u4e2d\u79fb\u9664\uff08Role.removeUser\uff09"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser roleUser = this.getRoleUser(user, role);
            if (roleUser == null) {
                return false;
            }
            roleUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), exception);
        }
        return true;
    }

    public boolean removeUser(Role role, int n, User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if ("admin".equals(user.getName()) && role.getId() == 1) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label20", "\u4e0d\u80fd\u5c06admin\u7528\u6237\u4ece\u7cfb\u7edf\u7ba1\u7406\u5458\u89d2\u8272\u4e2d\u79fb\u9664\uff08Role.removeUser\uff09"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser roleUser = this.getRoleUser(role, n, user);
            if (roleUser == null) {
                return false;
            }
            roleUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), exception);
        }
        return true;
    }

    public Roles getRoles() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMROLE", "", "");
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Users getUsers(Role role, int n, WCMFilter wCMFilter) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT RoleId FROM WCMRoleUser WHERE WCMRoleUser.UserId=WCMUser.UserId AND RoleId=? AND SITEID=?)", "", "UserId");
        wCMFilter2.addSearchValues(role.getId());
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Users getUsers(Role role, WCMFilter wCMFilter) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT RoleId FROM WCMRoleUser WHERE WCMRoleUser.UserId=WCMUser.UserId AND RoleId=" + role.getId() + " and SiteId=" + -1 + ")", "", "UserId");
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Users getUsersBySystemRoleForUser(Role role, int n, WCMFilter wCMFilter) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        User user = ContextHelper.getLoginUser();
        if (user.isAdministrator()) {
            return this.getUsers(role, n, wCMFilter);
        }
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(user, null);
        String string = groups.getIdListAsString();
        if (CMyString.isEmpty(string)) {
            string = "0";
        }
        String string2 = IdFilterSqlUtil.makeAsString("GroupId", string);
        String string3 = "exists (select 1 from WCMRoleUser where RoleId=? and SiteId = ? and WCMRoleUser.UserId = WCMUser.UserId) and exists(select 1 from WCMGrpUser where " + string2 + " and WCMUser.UserId=WCMGrpUser.UserId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string3, "", "UserId");
        wCMFilter2.addSearchValues(role.getId());
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Users getUsersBySpecailForUser(Role role, WCMFilter wCMFilter) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        User user = ContextHelper.getLoginUser();
        if (user.isAdministrator()) {
            return this.getUsers(role, wCMFilter);
        }
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(user, null);
        String string = groups.getIdListAsString();
        if (CMyString.isEmpty(string)) {
            string = "0";
        }
        String string2 = IdFilterSqlUtil.makeAsString("GroupId", string);
        String string3 = "exists (select 1 from WCMRoleUser where RoleId=? and SiteId=? and WCMRoleUser.UserId = WCMUser.UserId) and exists(select 1 from WCMGrpUser where " + string2 + " and WCMUser.UserId=WCMGrpUser.UserId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string3, "", "UserId");
        wCMFilter2.addSearchValues(role.getId());
        wCMFilter2.addSearchValues(-1);
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public boolean delete(Role role, boolean bl) throws WCMException {
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label9", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!bl) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label10", "\u4e0d\u652f\u6301\u5c06\u89d2\u8272\u5220\u9664\u5230\u56de\u6536\u7ad9\u7684\u64cd\u4f5c\uff01"));
        }
        if (role.isSysDefined()) {
            throw new WCMException(1100, I18NMessage.get(RoleMgr.class, "RoleMgr.label11", "\u89d2\u8272[") + role.getName() + I18NMessage.get(RoleMgr.class, "RoleMgr.label12", "]\u662f\u7cfb\u7edf\u9884\u5b9a\u4e49\u7684\u89d2\u8272,\u4e0d\u5141\u8bb8\u5220\u9664!"));
        }
        Users users = this.getUsers(role, null);
        if (users != null && !users.isEmpty()) {
            for (int i = 0; i < users.size(); ++i) {
                this.removeUser((User)users.getAt(i), role);
            }
        }
        role.delete(ContextHelper.getLoginUser());
        return true;
    }

    public Role save(Role role) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(RoleMgr.class, "RoleMgr.label13", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\uff1aRoleMgr.save"));
        if (role == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label14", "\u89d2\u8272\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        this.validate(role);
        role = this.prepareSave(role);
        role.save(ContextHelper.getLoginUser());
        return role;
    }

    private void validate(Role role) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (role == null) {
            throw new WCMException(20, I18NMessage.get(RoleMgr.class, "RoleMgr.label15", "\u89d2\u8272\u4e3a\u7a7a\uff01"));
        }
        if (!user.isAdministrator() && role.getRoleType() == -1) {
            throw new WCMException(1002, I18NMessage.get(RoleMgr.class, "RoleMgr.label19", "\u60a8\u6c92\u6709\u6743\u9650\u521b\u5efa\u7cfb\u7edf\u7ea7\u89d2\u8272\uff01"));
        }
        if (role.getName() == null || role.getName().trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label16", "\u89d2\u8272\u540d\u4e3a\u7a7a\uff01"));
        }
        String string = role.getName();
        if (role.isAddMode() && this.getByName(string) != null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(RoleMgr.class, "RoleMgr.label17", "\u89d2\u8272\u540d[{0}]\u5df2\u7ecf\u5b58\u5728\uff01"), new String[]{string}));
        }
        String string2 = role.getFinalPropertyAsString("RelateSiteIds");
        if (role.isAddMode() && role.getRoleType() == -2 && CMyString.isEmpty(string2)) {
            throw new WCMException(1106, CMyString.format(I18NMessage.get(RoleMgr.class, "RoleMgr.label18", "\u7ad9\u70b9\u7ea7\u89d2\u8272[{0}]\u6240\u5c5e\u7ad9\u70b9\u4e3a\u7a7a\uff01"), new String[]{string}));
        }
        string2 = null;
    }

    private Role prepareSave(Role role) throws WCMException {
        if (role.getProperty("SYSDEFINED") == null) {
            role.setSysDefined(false);
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role getByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMROLE", "RoleName='" + CMyString.filterForSQL(string) + "'", "", "RoleId", 1);
        Roles roles = Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (roles.isEmpty()) {
            return null;
        }
        try {
            Role role = (Role)roles.getAt(0);
            return role;
        }
        finally {
            if (roles != null) {
                roles.clear();
            }
        }
    }

    private RoleUser getRoleUser(User user, Role role) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMROLEUSER", "UserId=" + user.getId() + " AND RoleId=" + role.getId(), "", "", 1);
        RoleUsers roleUsers = RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (roleUsers.isEmpty()) {
            return null;
        }
        return (RoleUser)roleUsers.getAt(0);
    }

    private RoleUser getRoleUser(Role role, int n, User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMROLEUSER", "UserId=" + user.getId() + " AND RoleId=" + role.getId() + " AND SiteId=" + n, "", "", 1);
        RoleUsers roleUsers = RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (roleUsers.isEmpty()) {
            return null;
        }
        return (RoleUser)roleUsers.getAt(0);
    }

    public RoleUsers getRoleUsers(Role role, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMROLEUSER", "RoleId=" + role.getId(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public RoleUsers getRoleUsers(User user, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMROLEUSER", "UserId=" + user.getId(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public boolean isRoleManagers(User user) throws WCMException {
        if (user == null) {
            return false;
        }
        String string = "ROLENAME=? and exists(select 1 from WCMRoleUser where WCMRoleUser.UserId=? and WCMRoleUser.RoleId=WCMRole.RoleId)";
        WCMFilter wCMFilter = new WCMFilter(null, string, null);
        wCMFilter.addSearchValues("RoleManagers");
        wCMFilter.addSearchValues(user.getId());
        Roles roles = Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        return roles != null && !roles.isEmpty();
    }

    public Roles getRolesForUser(User user, WCMFilter wCMFilter) throws WCMException {
        if (user == null) {
            return Roles.createNewInstance(null);
        }
        if (user.isAdministrator()) {
            return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        }
        WCMFilter wCMFilter2 = this.makeRoleFilterForOthers(user, wCMFilter, false);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    private WCMFilter makeRoleFilterForOthers(User user, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (user == null || user.isAdministrator()) {
            throw new WCMException("\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff0c\u6b64\u63a5\u53e3\u53ea\u4f9b\u975e\u7cfb\u7edf\u7ba1\u7406\u5458\u7528\u6237\u4f7f\u7528");
        }
        String string = "WCMRole.RoleRange=1";
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(user, null);
        String string2 = groups.getIdListAsString();
        if (CMyString.isEmpty(string2)) {
            string2 = "0";
        }
        String string3 = IdFilterSqlUtil.makeAsString("WCMGrpRole.GroupId", string2);
        string = string + " or exists(select 1 from WCMGrpRole where WCMGrpRole.RoleId=WCMRole.RoleId and " + string3 + ")";
        if (bl) {
            string = string + " or WCMRole.RoleId=2";
        }
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    public Roles getRolesForUser(User user, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (user == null) {
            return Roles.createNewInstance(null);
        }
        if (user.isAdministrator()) {
            return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        }
        WCMFilter wCMFilter2 = this.makeRoleFilterForOthers(user, wCMFilter, bl);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public void setRoleUsers(Role role, int n, Users users) throws WCMException {
        User user;
        int n2;
        Users users2 = this.getUsers(role, n, null);
        int n3 = users.size();
        for (n2 = 0; n2 < n3; ++n2) {
            user = (User)users.getAt(n2);
            if (user == null) continue;
            int n4 = users2.indexOf(user.getId());
            if (n4 >= 0) {
                users2.removeAt(n4, false);
                continue;
            }
            this.addUser(role, n, user);
        }
        n3 = users2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            user = (User)users2.getAt(n2);
            if (user == null) continue;
            this.removeUser(role, n, user);
        }
    }

    public Roles getSystemRolesOfUser(User user, int n, WCMFilter wCMFilter) throws WCMException {
        if (user == null) {
            return Roles.createNewInstance(null);
        }
        String string = "WCMRole.RoleType=-1 and exists(select 1 from WCMRoleUser where WCMRoleUser.RoleId=WCMRole.RoleId and  WCMRoleUser.UserId=? and WCMRoleUser.SiteId=?)";
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.addSearchValues(user.getId());
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Roles getSpecialRolesOfUser(User user, WCMFilter wCMFilter) throws WCMException {
        if (user == null) {
            return Roles.createNewInstance(null);
        }
        String string = "WCMRole.RoleType=0 and exists(select 1 from WCMRoleUser where WCMRoleUser.RoleId=WCMRole.RoleId and  WCMRoleUser.UserId=? and WCMRoleUser.SiteId=?)";
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.addSearchValues(user.getId());
        wCMFilter2.addSearchValues(-1);
        wCMFilter2.mergeWith(wCMFilter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public void setSystemRolesOfUser(User user, int n, Roles roles) throws WCMException {
        Role role;
        int n2;
        Roles roles2 = this.getSystemRolesOfUser(user, n, null);
        int n3 = roles.size();
        for (n2 = 0; n2 < n3; ++n2) {
            role = (Role)roles.getAt(n2);
            if (role == null) continue;
            int n4 = roles2.indexOf(role.getId());
            if (n4 >= 0) {
                roles2.removeAt(n4, false);
                continue;
            }
            this.addUser(role, n, user);
        }
        n3 = roles2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            role = (Role)roles2.getAt(n2);
            if (role == null) continue;
            this.removeUser(role, n, user);
        }
    }

    public void setSpecailRolesOfUser(User user, Roles roles) throws WCMException {
        Role role;
        int n;
        Roles roles2 = this.getSpecialRolesOfUser(user, null);
        int n2 = roles.size();
        for (n = 0; n < n2; ++n) {
            role = (Role)roles.getAt(n);
            if (role == null) continue;
            int n3 = roles2.indexOf(role.getId());
            if (n3 >= 0) {
                roles2.removeAt(n3, false);
                continue;
            }
            this.addUser(role, -1, user);
        }
        n2 = roles2.size();
        for (n = 0; n < n2; ++n) {
            role = (Role)roles2.getAt(n);
            if (role == null) continue;
            this.removeUser(role, -1, user);
        }
    }

    public Role findRoleByName(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(null, "ROLENAME=?", "ROLEID desc");
        wCMFilter.addSearchValues(string);
        Roles roles = Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        int n = roles.size();
        for (int i = 0; i < n; ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null) continue;
            return role;
        }
        return null;
    }
}

