/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.domain.RightSet;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class RightHostLCListenerForInherit
implements IObjectLCListenerOnAdd {
    private static Logger logger = Logger.getLogger(RightHostLCListenerForInherit.class);

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("INHERIT_PARENT_RIGHT", "true");
        if (!string.equalsIgnoreCase("true")) {
            return;
        }
        if (!(baseObj instanceof CMSObj)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        IRightHost iRightHost = RightHostFactory.makeRightHostFrom((CMSObj)baseObj);
        if (iRightHost == null) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(RightHostLCListenerForInherit.class, "RightHostLCListenerForInherit.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        User user = null;
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RightSet rightSet = new RightSet();
        rightSet.inheritRights(user, iRightHost, false);
        if (baseObj instanceof Channel) {
            this.inheritObjectMembers((Channel)baseObj);
        }
    }

    public void inheritObjectMembers(Channel channel) throws WCMException {
        int n = channel.getId();
        int n2 = 101;
        User user = null;
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BaseChannel baseChannel = channel.getHost();
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        wCMFilter.addSearchValues(baseChannel.getWCMType());
        wCMFilter.addSearchValues(baseChannel.getId());
        ObjectMembers objectMembers = ObjectMembers.openWCMObjs(user, wCMFilter);
        if (objectMembers.isEmpty()) {
            return;
        }
        IObjectMemberMgr iObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        for (int i = 0; i < objectMembers.size(); ++i) {
            ObjectMember objectMember = (ObjectMember)objectMembers.getAt(i);
            if (objectMember == null) continue;
            int n3 = objectMember.getMemberType();
            int n4 = objectMember.getMemberId();
            if (!objectMember.isDoOperation()) continue;
            ObjectMember objectMember2 = iObjectMemberMgr.getObjectMember(n3, n4, n2, n);
            if (objectMember2 != null) {
                objectMember2.setVisible(objectMember.isVisible());
                objectMember2.setDoOperation(objectMember.isDoOperation());
                objectMember2.save(user);
                continue;
            }
            objectMember2 = (ObjectMember)objectMember.cloneToNewObj();
            objectMember2.setObjType(n2);
            objectMember2.setObjId(n);
            objectMember2.insert(user);
        }
    }
}

