/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.NewRightSet;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ObjectMemberSet {
    public static final int IMPART_MODE_NODE = 0;
    public static final int IMPART_MODE_ADD = 1;
    public static final int IMPART_MODE_MODIFY = 2;
    public static final int IMPART_MODE_DELETE = 3;
    public static final int IMPART_MODE_ALL = 4;
    private int m_nImpartMode = 0;
    private int[] m_pImpartMode = null;
    private User m_currLoginUser = null;
    private IRightHost m_oTopRightHost = null;
    private List m_arCurrObjectMembersList = null;
    private Logger logger = Logger.getLogger(ObjectMemberSet.class);

    public ObjectMemberSet(User user, IRightHost iRightHost, List list, int[] nArray) {
        this.m_currLoginUser = user;
        this.m_oTopRightHost = iRightHost;
        this.m_arCurrObjectMembersList = list;
        this.m_pImpartMode = nArray;
    }

    public boolean save() throws WCMException {
        this.m_oTopRightHost.validateCanDoSetRight(this.m_currLoginUser);
        Reports reports = new Reports("\u8bbf\u95ee\u63a7\u5236\u8bbe\u7f6e");
        for (int i = 0; i < this.m_pImpartMode.length; ++i) {
            this.m_nImpartMode = this.m_pImpartMode[i];
            if (this.m_nImpartMode == 0) continue;
            ArrayList arrayList = this.makeImpartObjectMembers();
            this.impartObjectMembers(this.m_oTopRightHost, arrayList, reports);
        }
        this.saveObjectMembersOfTopHost();
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException("\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u8bbf\u95ee\u63a7\u5236\u5931\u8d25\uff01\n" + reports.toString());
    }

    private void impartObjectMembers(IRightHost iRightHost, ArrayList arrayList, Reports reports) throws WCMException {
        IRightHost[] iRightHostArray = iRightHost.getChildren();
        if (iRightHostArray == null || iRightHostArray.length == 0) {
            return;
        }
        for (IRightHost iRightHost2 : iRightHostArray) {
            if (iRightHost2 == null) continue;
            this.saveRightOfChildNode(arrayList, iRightHost2, reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveRightOfChildNode(ArrayList arrayList, IRightHost iRightHost, Reports reports) throws WCMException {
        this.logger.debug((Object)(iRightHost.getInfo() + " impart objectMembers..."));
        try {
            iRightHost.validateCanDoSetRight(this.m_currLoginUser);
        }
        catch (Exception exception) {
            reports.addFailedReport("\u6ca1\u6709\u6743\u9650\u7ed9[" + iRightHost.getInfo() + "]\u4f20\u9012\u8bbf\u95ee\u63a7\u5236\u8bbe\u7f6e.", null);
            return false;
        }
        switch (this.m_nImpartMode) {
            case 1: 
            case 2: 
            case 3: {
                if (arrayList != null && !arrayList.isEmpty()) break;
                return true;
            }
            case 4: {
                if (arrayList != null && !arrayList.isEmpty()) break;
                ObjectMembers objectMembers = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, iRightHost.getSubstance(), new int[0]);
                objectMembers.removeAll(true);
                this.impartObjectMembers(iRightHost, arrayList, reports);
                return true;
            }
            default: {
                return false;
            }
        }
        this.logger.debug((Object)(iRightHost.getInfo() + " impart objectMember for!"));
        int[] nArray = new int[arrayList.size()];
        block20: for (int i = 0; i < arrayList.size(); ++i) {
            int[] nArray2 = (int[])arrayList.get(i);
            int n = iRightHost.getType();
            int n2 = iRightHost.getId();
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            boolean bl = nArray2[2] == 1;
            boolean bl2 = nArray2[3] == 1;
            ObjectMember objectMember = ObjectMember.findByMemberObj(n3, n4, n, n2);
            try {
                switch (this.m_nImpartMode) {
                    case 1: 
                    case 4: {
                        boolean bl3;
                        boolean bl4 = bl3 = objectMember == null;
                        if (objectMember == null) {
                            objectMember = ObjectMember.createNewInstance();
                            objectMember.setMember(n3, n4);
                            objectMember.setObj(n, n2);
                        } else {
                            nArray[i] = objectMember.getId();
                            if (!objectMember.canEdit(this.m_currLoginUser)) {
                                reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + n + ", ObjId=" + n2 + ", OprType=" + n3 + ", OprId=" + n4 + "] ", null);
                                continue block20;
                            }
                            if (objectMember.isVisible() == bl && objectMember.isDoOperation() == bl2) continue block20;
                        }
                        objectMember.setVisible(bl);
                        objectMember.setDoOperation(bl2);
                        this.logger.debug((Object)(iRightHost.getInfo() + " impart right save right!" + objectMember.isAddMode()));
                        objectMember.save(this.m_currLoginUser);
                        this.logger.debug((Object)(iRightHost.getInfo() + " impart right save right!" + objectMember.getId()));
                        if (!bl3) break;
                        nArray[i] = objectMember.getId();
                        break;
                    }
                    case 2: {
                        this.logger.debug((Object)("modify right:" + objectMember));
                        if (objectMember == null || objectMember.isVisible() == bl && objectMember.isDoOperation() == bl2) continue block20;
                        if (!objectMember.canEdit(this.m_currLoginUser)) {
                            reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + n + ", ObjId=" + n2 + ", OprType=" + n3 + ", OprId=" + n4 + "] ", null);
                            continue block20;
                        }
                        objectMember.setVisible(bl);
                        objectMember.setDoOperation(bl2);
                        objectMember.save(this.m_currLoginUser);
                        this.logger.debug((Object)"modify right success!");
                        break;
                    }
                    case 3: 
                }
                continue;
            }
            finally {
                if (objectMember != null && objectMember.isLocked() && objectMember.getLockerUserName().equalsIgnoreCase(this.m_currLoginUser.getName())) {
                    objectMember.unlock();
                }
            }
        }
        if (this.m_nImpartMode == 4) {
            ObjectMembers objectMembers = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, iRightHost.getSubstance(), nArray);
            this.logger.debug((Object)(iRightHost.getInfo() + " impart right delete right!" + objectMembers.getIdListAsString()));
            objectMembers.removeAll(true);
        }
        this.impartObjectMembers(iRightHost, arrayList, reports);
        return true;
    }

    private ArrayList makeImpartObjectMembers() throws WCMException {
        int n;
        int n2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(this.m_arCurrObjectMembersList.size());
        switch (this.m_nImpartMode) {
            case 1: {
                n2 = this.m_arCurrObjectMembersList.size();
                for (int i = 0; i < n2; ++i) {
                    ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
                    if (objectMember == null || !objectMember.isAddMode()) continue;
                    arrayList.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), objectMember.getPropertyAsInt("VISIBLE", 0), objectMember.getPropertyAsInt("DOOPERATION", 0)});
                }
                break;
            }
            case 2: {
                int n3;
                int n4;
                boolean bl;
                n2 = this.m_arCurrObjectMembersList.size();
                for (int i = 0; i < n2; ++i) {
                    ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
                    if (objectMember == null || objectMember.isAddMode()) continue;
                    n = objectMember.isChangeProperty("VISIBLE");
                    bl = objectMember.isChangeProperty("DOOPERATION");
                    if (n == 0 && !bl) continue;
                    n4 = n != 0 ? objectMember.getNewPropertyAsInt("VISIBLE", 0) : objectMember.getPropertyAsInt("VISIBLE", 0);
                    n3 = bl ? objectMember.getNewPropertyAsInt("DOOPERATION", 0) : objectMember.getPropertyAsInt("DOOPERATION", 0);
                    arrayList.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), n4, n3});
                }
                break;
            }
            case 3: {
                ObjectMembers objectMembers = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrObjectMembersList));
                int n5 = objectMembers.size();
                for (n2 = 0; n2 < n5; ++n2) {
                    ObjectMember objectMember = (ObjectMember)objectMembers.getAt(n2);
                    if (objectMember == null) continue;
                    arrayList.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), 0, 0});
                }
                break;
            }
            case 4: {
                int n3;
                int n4;
                boolean bl;
                int n6 = this.m_arCurrObjectMembersList.size();
                for (n2 = 0; n2 < n6; ++n2) {
                    ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(n2);
                    if (objectMember == null) continue;
                    bl = objectMember.isChangeProperty("VISIBLE");
                    n4 = objectMember.isChangeProperty("DOOPERATION");
                    n3 = bl ? objectMember.getNewPropertyAsInt("VISIBLE", 0) : objectMember.getPropertyAsInt("VISIBLE", 0);
                    int n7 = n4 != 0 ? objectMember.getNewPropertyAsInt("DOOPERATION", 0) : objectMember.getPropertyAsInt("DOOPERATION", 0);
                    arrayList.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), n3, n7});
                }
                break;
            }
        }
        if (this.logger.isDebugEnabled() && arrayList != null) {
            n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                long[] lArray = (long[])arrayList.get(i);
                for (n = 0; n < lArray.length; ++n) {
                    this.logger.debug((Object)(i + "." + n + ":" + lArray[n]));
                }
            }
        }
        return arrayList;
    }

    private ObjectMembers getDeleteObjectMembersOfHost(User user, CMSObj cMSObj, String string) throws WCMException {
        int[] nArray = null;
        if (!CMyString.isEmpty(string)) {
            nArray = CMyString.splitToInt(string, ",");
        }
        return this.getDeleteObjectMembersOfHost(user, cMSObj, nArray);
    }

    private ObjectMembers getDeleteObjectMembersOfHost(User user, CMSObj cMSObj, int[] nArray) throws WCMException {
        Object object;
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string = "OBJTYPE=? and OBJID=?";
        wCMFilter.addSearchValues(cMSObj.getWCMType());
        wCMFilter.addSearchValues(cMSObj.getId());
        if (nArray != null && nArray.length > 0) {
            object = new StringBuffer(nArray.length * 3);
            ((StringBuffer)object).append(" and OBJECTMEMBERID not in (");
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                if (n > 0) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append("?");
                wCMFilter.addSearchValues(nArray[i]);
                ++n;
            }
            ((StringBuffer)object).append(")");
            if (n > 0) {
                string = string + object;
            }
        }
        wCMFilter.setWhere(string);
        this.logger.debug((Object)("delete filter:" + wCMFilter));
        object = ObjectMembers.openWCMObjs(user, wCMFilter);
        return object;
    }

    private boolean saveObjectMembersOfTopHost() throws WCMException {
        this.deleteRights(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrObjectMembersList));
        if (this.m_arCurrObjectMembersList == null || this.m_arCurrObjectMembersList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.m_arCurrObjectMembersList.size(); ++i) {
            ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
            if (objectMember == null) {
                this.logger.error((Object)I18NMessage.get(NewRightSet.class, "NewRightSet.label3", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (objectMember.getObjType() == 0 || objectMember.getId() <= 0) {
                objectMember.setObj(this.m_oTopRightHost.getType(), this.m_oTopRightHost.getId());
            }
            objectMember.save(this.m_currLoginUser);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("\u4fdd\u5b58[" + this.m_oTopRightHost.getSubstance() + "]objectMember[" + i + "]\uff01<BR>"));
        }
        return true;
    }

    private boolean deleteRights(User user, CMSObj cMSObj, String string) throws WCMException {
        if (cMSObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label8", "\u5220\u9664[") + cMSObj + "][" + string + "]rights...\n<BR>\n"));
        }
        ObjectMembers objectMembers = this.getDeleteObjectMembersOfHost(user, cMSObj, string);
        objectMembers.removeAll(true);
        return true;
    }
}

