/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NewRightSet {
    private Logger logger = Logger.getLogger(this.getClass());
    public static final int IMPART_MODE_NODE = 0;
    public static final int IMPART_MODE_ADD = 1;
    public static final int IMPART_MODE_MODIFY = 2;
    public static final int IMPART_MODE_DELETE = 3;
    public static final int IMPART_MODE_ALL = 4;
    private int m_nImpartMode = 0;
    private int[] m_pImpartMode = null;
    private User m_currLoginUser = null;
    private IRightHost m_oTopRightHost = null;
    private List m_arCurrRightsList = null;

    public NewRightSet(User user, IRightHost iRightHost, List list, int[] nArray) {
        this.m_currLoginUser = user;
        this.m_oTopRightHost = iRightHost;
        this.m_arCurrRightsList = list;
        this.m_pImpartMode = nArray;
    }

    public boolean save() throws WCMException {
        this.m_oTopRightHost.validateCanDoSetRight(this.m_currLoginUser);
        Reports reports = new Reports(I18NMessage.get(NewRightSet.class, "NewRightSet.label1", "\u8bbe\u7f6e\u6743\u9650"));
        for (int i = 0; this.m_pImpartMode != null && i < this.m_pImpartMode.length; ++i) {
            this.m_nImpartMode = this.m_pImpartMode[i];
            if (this.m_nImpartMode == 0) continue;
            ArrayList arrayList = this.makeImpartRights();
            this.impartRights(this.m_oTopRightHost, arrayList, reports);
        }
        this.saveRightsOfTopHost();
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException(I18NMessage.get(NewRightSet.class, "NewRightSet.label2", "\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u6743\u9650\u5931\u8d25\uff01\n") + reports.toString());
    }

    private void impartRights(IRightHost iRightHost, ArrayList arrayList, Reports reports) throws WCMException {
        IRightHost[] iRightHostArray = iRightHost.getChildren();
        if (iRightHostArray == null || iRightHostArray.length == 0) {
            return;
        }
        for (IRightHost iRightHost2 : iRightHostArray) {
            if (iRightHost2 == null) continue;
            this.saveRightOfChildNode(arrayList, iRightHost2, reports);
        }
    }

    private ArrayList makeImpartRights() throws WCMException {
        int n;
        ArrayList<long[]> arrayList = new ArrayList<long[]>(this.m_arCurrRightsList.size());
        switch (this.m_nImpartMode) {
            case 1: {
                n = this.m_arCurrRightsList.size();
                for (int i = 0; i < n; ++i) {
                    Right right = (Right)this.m_arCurrRightsList.get(i);
                    if (right == null || !right.isAddMode()) continue;
                    arrayList.add(new long[]{right.getOperatorType(), right.getOperatorId(), right.getValueAsLong()});
                }
                break;
            }
            case 2: {
                n = this.m_arCurrRightsList.size();
                for (int i = 0; i < n; ++i) {
                    Right right = (Right)this.m_arCurrRightsList.get(i);
                    if (right == null || right.isAddMode() || !right.isChangeProperty("RIGHTVALUE")) continue;
                    long l = right.isAddMode() ? right.getValueAsLong() : ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
                    arrayList.add(new long[]{right.getOperatorType(), right.getOperatorId(), l});
                }
                break;
            }
            case 3: {
                Rights rights = this.getDeleteRightsOfHost(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrRightsList));
                int n2 = rights.size();
                for (n = 0; n < n2; ++n) {
                    Right right = (Right)rights.getAt(n);
                    if (right == null) continue;
                    arrayList.add(new long[]{right.getOperatorType(), right.getOperatorId(), 0L});
                }
                break;
            }
            case 4: {
                int n3 = this.m_arCurrRightsList.size();
                for (n = 0; n < n3; ++n) {
                    Right right = (Right)this.m_arCurrRightsList.get(n);
                    if (right == null) continue;
                    long l = right.isAddMode() ? right.getValueAsLong() : ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
                    arrayList.add(new long[]{right.getOperatorType(), right.getOperatorId(), l});
                }
                break;
            }
        }
        if (this.logger.isDebugEnabled() && arrayList != null) {
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                long[] lArray = (long[])arrayList.get(i);
                for (int j = 0; j < lArray.length; ++j) {
                    this.logger.debug((Object)(i + "." + j + ":" + lArray[j]));
                }
            }
        }
        return arrayList;
    }

    private boolean saveRightsOfTopHost() throws WCMException {
        this.deleteRights(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrRightsList));
        if (this.m_arCurrRightsList == null || this.m_arCurrRightsList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.m_arCurrRightsList.size(); ++i) {
            Right right = (Right)this.m_arCurrRightsList.get(i);
            if (right == null) {
                this.logger.error((Object)I18NMessage.get(NewRightSet.class, "NewRightSet.label3", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (right.getObjType() == 0 || right.getId() <= 0) {
                right.setObject(this.m_oTopRightHost.getSubstance());
            }
            right.save(this.m_currLoginUser);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label4", "\u4fdd\u5b58[") + this.m_oTopRightHost.getSubstance() + "]right[" + i + "]\uff01<BR>"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveRightOfChildNode(ArrayList arrayList, IRightHost iRightHost, Reports reports) throws WCMException {
        this.logger.debug((Object)(iRightHost.getInfo() + " impart right..."));
        try {
            iRightHost.validateCanDoSetRight(this.m_currLoginUser);
        }
        catch (Exception exception) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(NewRightSet.class, "NewRightSet.label9", "\u6ca1\u6709\u6743\u9650\u7ed9{0}\u4f20\u9012\u6743\u9650\u8bbe\u7f6e."), new String[]{iRightHost.getInfo()}), null);
            return false;
        }
        switch (this.m_nImpartMode) {
            case 1: 
            case 2: 
            case 3: {
                if (arrayList != null && !arrayList.isEmpty()) break;
                return true;
            }
            case 4: {
                if (arrayList != null && !arrayList.isEmpty()) break;
                Rights rights = this.getDeleteRightsOfHost(this.m_currLoginUser, iRightHost.getSubstance(), new int[0]);
                rights.removeAll(true);
                this.impartRights(iRightHost, arrayList, reports);
                return true;
            }
            default: {
                return false;
            }
        }
        this.logger.debug((Object)(iRightHost.getInfo() + " impart right for!"));
        int[] nArray = new int[arrayList.size()];
        block20: for (int i = 0; i < arrayList.size(); ++i) {
            long[] lArray = (long[])arrayList.get(i);
            int n = iRightHost.getType();
            int n2 = iRightHost.getId();
            int n3 = (int)lArray[0];
            int n4 = (int)lArray[1];
            long l = lArray[2];
            Right right = Right.findBy(n, n2, n3, n4);
            try {
                switch (this.m_nImpartMode) {
                    case 1: 
                    case 4: {
                        boolean bl;
                        boolean bl2 = bl = right == null;
                        if (right == null) {
                            right = Right.createNewInstance();
                            right.setObject(n, n2);
                            right.setOperator(n3, n4);
                        } else {
                            nArray[i] = right.getId();
                            if (!right.canEdit(this.m_currLoginUser)) {
                                reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + n + ", ObjId=" + n2 + ", OprType=" + n3 + ", OprId=" + n4 + "] ", null);
                                continue block20;
                            }
                            if (right.getValueAsLong() == l) continue block20;
                        }
                        right.setValue(l);
                        this.logger.debug((Object)(iRightHost.getInfo() + " impart right save right!" + right.isAddMode()));
                        right.save(this.m_currLoginUser);
                        this.logger.debug((Object)(iRightHost.getInfo() + " impart right save right!" + right.getId()));
                        if (!bl) break;
                        nArray[i] = right.getId();
                        break;
                    }
                    case 2: {
                        this.logger.debug((Object)("modify right:" + right));
                        if (right == null || right.getValueAsLong() == l) continue block20;
                        this.logger.debug((Object)("modify right.value:" + l));
                        if (!right.canEdit(this.m_currLoginUser)) {
                            reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + n + ", ObjId=" + n2 + ", OprType=" + n3 + ", OprId=" + n4 + "] ", null);
                            continue block20;
                        }
                        right.setValue(l);
                        right.save(this.m_currLoginUser);
                        this.logger.debug((Object)"modify right success!");
                        break;
                    }
                    case 3: 
                }
                continue;
            }
            finally {
                if (right != null && right.isLocked() && right.getLockerUserName().equalsIgnoreCase(this.m_currLoginUser.getName())) {
                    right.unlock();
                }
            }
        }
        if (this.m_nImpartMode == 4) {
            Rights rights = this.getDeleteRightsOfHost(this.m_currLoginUser, iRightHost.getSubstance(), nArray);
            this.logger.debug((Object)(iRightHost.getInfo() + " impart right delete right!" + rights.getIdListAsString()));
            rights.removeAll(true);
        }
        this.impartRights(iRightHost, arrayList, reports);
        return true;
    }

    private boolean deleteRights(User user, CMSObj cMSObj, String string) throws WCMException {
        if (cMSObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label8", "\u5220\u9664[") + cMSObj + "][" + string + "]rights...\n<BR>\n"));
        }
        Rights rights = this.getDeleteRightsOfHost(user, cMSObj, string);
        rights.removeAll(true);
        return true;
    }

    private Rights getDeleteRightsOfHost(User user, CMSObj cMSObj, String string) throws WCMException {
        int[] nArray = null;
        if (!CMyString.isEmpty(string)) {
            nArray = CMyString.splitToInt(string, ",");
        }
        return this.getDeleteRightsOfHost(user, cMSObj, nArray);
    }

    private Rights getDeleteRightsOfHost(User user, CMSObj cMSObj, int[] nArray) throws WCMException {
        Object object;
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string = "OBJTYPE=? and OBJID=?";
        wCMFilter.addSearchValues(cMSObj.getWCMType());
        wCMFilter.addSearchValues(cMSObj.getId());
        if (nArray != null && nArray.length > 0) {
            object = new StringBuffer(nArray.length * 3);
            ((StringBuffer)object).append(" and RIGHTID not in (");
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                if (n > 0) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append("?");
                wCMFilter.addSearchValues(nArray[i]);
                ++n;
            }
            ((StringBuffer)object).append(")");
            if (n > 0) {
                string = string + object;
            }
        }
        wCMFilter.setWhere(string);
        this.logger.debug((Object)("delete filter:" + wCMFilter));
        object = Rights.openWCMObjs(user, wCMFilter);
        return object;
    }

    public void inheritRights(User user, IRightHost iRightHost, boolean bl) throws WCMException {
        if (iRightHost == null) {
            return;
        }
        IRightHost iRightHost2 = iRightHost.getParent();
        if (iRightHost2 == null) {
            return;
        }
        IRightMgr iRightMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (bl) {
            iRightMgr.getRights(iRightHost.getSubstance()).removeAll(true);
        }
        Rights rights = iRightMgr.getRights(iRightHost2.getSubstance());
        int n = rights.size();
        for (int i = 0; i < n; ++i) {
            Right right = (Right)rights.getAt(i);
            if (right == null) continue;
            Right right2 = (Right)right.cloneToNewObj();
            right2.setObject(iRightHost.getSubstance());
            right2.insert(user);
        }
    }
}

