/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.GroupUsers;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;

public class GrpUserIdsMan
extends BaseIdsMan {
    private GroupUsers m_oGroupUsers = null;
    private GroupMgr m_oMgr = null;
    private Group m_oGroup = null;

    public GrpUserIdsMan(int n) throws WCMException {
        this.m_oGroup = Group.findById(n);
        this.m_oMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        this.m_oGroupUsers = this.m_oMgr.getGroupUsers(this.m_oGroup, null);
    }

    protected int getExistsSize() {
        return this.m_oGroupUsers.size();
    }

    protected int getExistsIdAt(int n) {
        return ((GroupUser)this.m_oGroupUsers.getAt(n)).getUserId();
    }

    protected void deleteExists(int n) throws WCMException {
        GroupUser groupUser = (GroupUser)this.m_oGroupUsers.getAt(n);
        User user = User.findById(groupUser.getUserId());
        String string = CMyString.format("\u5220\u9664{0}\u7684\u7528\u6237{1}", new String[]{this.m_oGroup.toString(), user.toString()});
        User user2 = ContextHelper.getLoginUser();
        long l = LogServer.startRecord(user2.getName(), "GROUPUSER_DEL", string, this.m_oGroup);
        try {
            this.m_oGroupUsers.removeAt(n);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, "\u4ece\u7ec4\u7ec7\u4e2d\u5220\u9664\u7528\u6237\u5931\u8d25!", throwable);
        }
        LogServer.endRecordSucceedOperation(l);
    }

    protected void addRelation(int n) throws WCMException {
        User user = User.findById(n);
        String string = CMyString.format("\u5411{0}\u6dfb\u52a0{1}", new String[]{this.m_oGroup.toString(), user.toString()});
        User user2 = ContextHelper.getLoginUser();
        long l = LogServer.startRecord(user2.getName(), "GROUPUSER_ADD", string, this.m_oGroup);
        try {
            this.m_oMgr.addUser(user, this.m_oGroup);
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, "\u5f80\u7ec4\u7ec7\u6dfb\u52a0\u7528\u6237\u5931\u8d25!", throwable);
        }
        LogServer.endRecordSucceedOperation(l);
    }
}

