/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.GroupUsers;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class GroupMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)GroupMgr.class.getName());

    public boolean addUser(User user, Group group) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label1", "\u8981\u52a0\u5165\u7ec4\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        if (group == null || !group.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label3", "\u6307\u5b9a\u7684\u7ec4\u7ec7\u65e0\u6548!"));
        }
        int n = user.getId();
        int n2 = group.getId();
        try {
            GroupUser groupUser = this.getGroupUser(group, user);
            if (groupUser != null) {
                return false;
            }
            groupUser = GroupUser.createNewInstance();
            groupUser.setUserId(n);
            groupUser.setGroupId(n2);
            groupUser.setIsAdministrator(0);
            groupUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(GroupMgr.class, "GroupMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), exception);
        }
        return true;
    }

    public boolean removeUser(User user, Group group) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(GroupMgr.class, "GroupMgr.label5", "\u8981\u4ece\u7ec4\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(GroupMgr.class, "GroupMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Group.removeUser\uff09"));
        }
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label7", "\u5f53\u524d\u64cd\u4f5c\u7684\u7ec4\u7ec7\u65e0\u6548!"));
        }
        try {
            GroupUser groupUser = this.getGroupUser(group, user);
            if (groupUser == null) {
                return false;
            }
            groupUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(GroupMgr.class, "GroupMgr.label8", "\u4ece\u7ec4\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25\uff08Group.removeUser\uff09"), exception);
        }
        return true;
    }

    public boolean setGroupManager(User user, Group group, boolean bl) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label9", "\u65e0\u6548\u7684\u7528\u6237,\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u7528\u6237\u4f5c\u4e3a\u7ba1\u7406\u5458!"));
        }
        if (bl && (user.isForbidden() || user.isDeleted())) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label10", "\u8be5\u7528\u6237\u4e3a\u7a7a\u6216\u88ab\u505c\u7528\u3001\u88ab\u5220\u9664,\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6709\u6548\u7684\u7528\u6237\u4f5c\u4e3a\u7ba1\u7406\u5458!"));
        }
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label11", "\u65e0\u6548\u7684\u7ec4\u7ec7\u5bf9\u8c61"));
        }
        GroupUser groupUser = this.getGroupUser(group, user);
        if (groupUser == null) {
            return false;
        }
        groupUser.canEdit(ContextHelper.getLoginUser());
        groupUser.setIsAdministrator(bl ? 1 : 0);
        groupUser.update(ContextHelper.getLoginUser());
        return true;
    }

    public Users getUsers(Group group, WCMFilter wCMFilter) throws WCMException {
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label12", "\u65e0\u6548\u7684\u7fa4\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u8be5\u7ec4\u5185\u7684\u7528\u6237"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpUser WHERE GroupID=" + group.getId() + " AND WCMGrpUser.UserId=WCMUser.UserId)", "UserId");
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Groups getChildren(Group group) throws WCMException {
        WCMFilter wCMFilter = null;
        wCMFilter = group == null ? new WCMFilter("", "ParentId=0", "GROUPORDER ASC") : new WCMFilter("", "ParentId=" + group.getId(), "GROUPORDER ASC");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Groups getChildren(Group group, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = null;
        wCMFilter2 = group == null ? new WCMFilter("", "ParentId=0", "") : new WCMFilter("", "ParentId=" + group.getId(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Users getAdmins(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label13", "\u65e0\u6548\u7684\u7ec4\u7ec7,\u65e0\u6cd5\u83b7\u7ec4\u7ec7\u7684\u7ba1\u7406\u5458!"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "isAdministrator=1", "", "UserId");
        GroupUsers groupUsers = this.getGroupUsers(group, wCMFilter);
        Users users = Users.createNewInstance(ContextHelper.getLoginUser());
        GroupUser groupUser = null;
        User user = null;
        for (int i = 0; i < groupUsers.size(); ++i) {
            groupUser = (GroupUser)groupUsers.getAt(i);
            if (groupUser == null || (user = User.findById(groupUser.getUserId())) == null) continue;
            users.addElement(user);
        }
        return users;
    }

    public boolean moveUser(User user, Group group, Group group2) throws WCMException {
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label14", "\u6307\u5b9a\u7684\u7528\u6237\u539f\u6240\u5c5e\u7ec4\u7ec7\u65e0\u6548!"));
        }
        if (group2 == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label15", "\u6307\u5b9a\u7684\u76ee\u6807\u7ec4\u7ec7\u65e0\u6548!"));
        }
        if (group.getId() == group2.getId()) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label16", "\u6307\u5b9a\u7684\u539f\u7ec4\u7ec7\u4e0e\u76ee\u6807\u7ec4\u7ec7\u662f\u540c\u4e00\u4e2a\u7ec4\u7ec7,\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
        GroupUser groupUser = this.getGroupUser(group, user);
        GroupUser groupUser2 = this.getGroupUser(group2, user);
        if (groupUser != null) {
            if (groupUser2 == null) {
                groupUser.canEdit(ContextHelper.getLoginUser());
                groupUser.setGroupId(group2.getId());
                groupUser.update(ContextHelper.getLoginUser());
            } else {
                groupUser.delete(ContextHelper.getLoginUser());
            }
            return true;
        }
        return false;
    }

    public Group save(Group group) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(GroupMgr.class, "GroupMgr.label17", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u7ec4\u7ec7\uff1aGroupMgr.save"));
        this.validate(group);
        this.prepareSave(group);
        group.save(ContextHelper.getLoginUser());
        return group;
    }

    private void validate(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label18", "\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        if (group.getName() == null || group.getName().trim().length() == 0) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label19", "\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a\uff01"));
        }
        if (group.isAddMode() && this.isNameExist(group)) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label20", "\u7ec4\u7ec7\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (group.getParentId() != 0 && group.getParent() == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label21", "\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01"));
        }
    }

    private Group prepareSave(Group group) throws WCMException {
        Group group2 = null;
        group2 = group.isChangeProperty("ParentId") ? Group.findById(group.getNewPropertyAsInt("ParentId", 0)) : group.getParent();
        if (group2 == null) {
            group.setParent(0);
        }
        return group;
    }

    public boolean delete(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(20, I18NMessage.get(GroupMgr.class, "GroupMgr.label22", "\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        m_oLogger.debug((Object)(I18NMessage.get(GroupMgr.class, "GroupMgr.label23", "\u5220\u9664\u7ec4\u7ec7\uff1aGroupMgr.delete\uff0cId\uff1a") + group.getId() + "\uff0c" + group.getName()));
        Groups groups = this.getChildren(group);
        if (groups != null && !groups.isEmpty()) {
            for (int i = 0; i < groups.size(); ++i) {
                this.delete((Group)groups.getAt(i));
            }
        }
        WCMFilter wCMFilter = new WCMFilter("WCMGRPUSER", "GroupId=" + group.getId(), "");
        GroupUsers groupUsers = GroupUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        groupUsers.removeAll();
        group.delete(ContextHelper.getLoginUser());
        return true;
    }

    private boolean isNameExist(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label18", "\u7ec4\u7ec7\u4e3a\u7a7a\uff01"));
        }
        String string = group.getName();
        WCMFilter wCMFilter = new WCMFilter("WCMGROUP", "GNAME='" + CMyString.filterForSQL(string) + "' AND PARENTID=" + group.getParentId(), "", "GroupId", 1);
        Groups groups = Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (groups.isEmpty()) {
            return false;
        }
        groups.clear();
        return true;
    }

    private GroupUser getGroupUser(Group group, User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "UserId=" + user.getId(), "", "", 1);
        GroupUsers groupUsers = this.getGroupUsers(group, wCMFilter);
        if (groupUsers.isEmpty()) {
            return null;
        }
        return (GroupUser)groupUsers.getAt(0);
    }

    public GroupUsers getGroupUsers(Group group, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMGRPUSER", "GroupId=" + group.getId(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return GroupUsers.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Groups getOffspringGroups(Group group, boolean bl, WCMFilter wCMFilter) throws WCMException {
        if (group == null) {
            return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        }
        String string = this.getOffspringGroupIds(String.valueOf(group.getId()), bl);
        if (CMyString.isEmpty(string)) {
            return null;
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        IdFilterSqlUtil.RangeSQL rangeSQL = IdFilterSqlUtil.make("GROUPID", string);
        wCMFilter2.setWhere(rangeSQL.getSql());
        int[] nArray = rangeSQL.getValues();
        if (nArray != null) {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                wCMFilter2.addSearchValues(nArray[i]);
            }
        }
        wCMFilter2.mergeWith(wCMFilter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public String getOffspringGroupIds(String string, boolean bl) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(string);
        }
        String string2 = string;
        String string3 = "";
        while (true) {
            string3 = IdFilterSqlUtil.makeAsString("ParentId", string2);
            WCMFilter wCMFilter = new WCMFilter("", string3, "", "GroupId");
            Groups groups = Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
            if (groups.size() == 0) break;
            string2 = groups.getIdListAsString();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public Users getUsers(Group group, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (!bl) {
            return this.getUsers(group, wCMFilter);
        }
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupMgr.class, "GroupMgr.label12", "\u65e0\u6548\u7684\u7fa4\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u8be5\u7ec4\u5185\u7684\u7528\u6237"));
        }
        String string = this.getOffspringGroupIds(String.valueOf(group.getId()), true);
        IdFilterSqlUtil.RangeSQL rangeSQL = IdFilterSqlUtil.make("GROUPID", string);
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpUser WHERE " + rangeSQL.getSql() + " AND WCMGrpUser.UserId=WCMUser.UserId)", "UserId");
        int[] nArray = rangeSQL.getValues();
        if (nArray != null) {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                wCMFilter2.addSearchValues(nArray[i]);
            }
        }
        wCMFilter2.mergeWith(wCMFilter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Groups getGroups(User user, WCMFilter wCMFilter) throws WCMException {
        if (user == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u80fd\u591f\u7ba1\u7406\u7684\u89d2\u8272!");
        }
        String string = "GroupId in (select GroupId from WCMGrpUser where isAdministrator=1 and UserId=?)";
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.addSearchValues(user.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Groups getOffspringGroups(User user, WCMFilter wCMFilter) throws WCMException {
        if (user == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u80fd\u591f\u7ba1\u7406\u7684\u89d2\u8272!");
        }
        String string = "GroupId in (select GroupId from WCMGrpUser where isAdministrator=1 and UserId=?)";
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.addSearchValues(user.getId());
        wCMFilter2.mergeWith(wCMFilter);
        Groups groups = Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        Groups groups2 = Groups.createNewInstance(null);
        this.addGroups(groups2, groups);
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            Groups groups3 = this.getOffspringGroups(group, false, null);
            this.addGroups(groups2, groups3);
        }
        return groups2;
    }

    private Groups addGroups(Groups groups, Groups groups2) throws WCMException {
        if (groups2 == null) {
            return groups;
        }
        int n = groups2.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups2.getAt(i);
            if (group == null || groups.indexOf(group) >= 0) continue;
            groups.addElement(group);
        }
        return groups;
    }

    public boolean isAdministrator(Group group, User user, boolean bl) throws WCMException {
        if (user == null || group == null) {
            return false;
        }
        if (!bl) {
            return group.isAdministrator(user);
        }
        while (group != null) {
            if (group.isAdministrator(user)) {
                return true;
            }
            group = group.getParent();
        }
        return false;
    }
}

