/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.config;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.OperationConfig;
import com.trs.cms.auth.config.OperationDefineOnCurrChannelConfig;
import com.trs.cms.auth.config.OperationRelatedConfig;
import com.trs.cms.auth.config.RightHostConfig;
import com.trs.cms.auth.config.RightObjectConfig;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.util.NamesRegister;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RightConfigServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(RightConfigServer.class);
    private static final int MAX_OPERATION_COUNT = 100;
    private static final int MAX_RELATE_COUNT = 20;
    private Map m_mRightObjects = null;
    private Map m_mRightHosts = null;
    private int[][] m_pSimilarIndexs = null;
    private int[][] m_pDependIndexs = null;
    private Map m_mapRightIndexsDefineOnCurrChannel = null;
    private Map m_mapTypeOperationsTemp = null;
    private NamesRegister m_mapRightIndexes = null;
    private XMLConfigServer m_oXMLConfigServer = XMLConfigServer.getInstance();

    public static RightConfigServer getInstance() {
        return (RightConfigServer)DreamFactory.createObjectById("RightConfigServer");
    }

    public IRightObj makeRightObjectInstance(int n) {
        RightObjectConfig rightObjectConfig = (RightObjectConfig)this.getRightObjects().get(new Integer(n));
        if (rightObjectConfig == null) {
            return null;
        }
        return rightObjectConfig.makeNewHostInstance();
    }

    public IRightHost makeRightHostInstance(int n) {
        RightHostConfig rightHostConfig = (RightHostConfig)this.getRightHosts().get(new Integer(n));
        if (rightHostConfig == null) {
            return null;
        }
        return rightHostConfig.makeNewHostInstance();
    }

    public int[] getSimilarIndexs(int n) {
        return this.getSimilarIndexs()[n];
    }

    public int[] getDependIndexs(int n) {
        return this.getDependIndexs()[n];
    }

    public List getOperationConfigs(String string) {
        if (this.m_mapTypeOperationsTemp == null) {
            this.startup();
        }
        return (ArrayList)this.m_mapTypeOperationsTemp.get(string.toUpperCase());
    }

    public int getRightIndexByOperName(String string) {
        int n;
        if (this.m_mapRightIndexes == null) {
            this.startup();
        }
        if ((n = this.m_mapRightIndexes.lookup(string.toUpperCase(), -1)) == -1) {
            logger.warn((Object)(string + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label1", "\u6709\u53ef\u80fd\u6ca1\u6709\u5728\u6587\u4ef6[") + TRSConfigServer.getConfigRootPath() + "domain" + File.separatorChar + "com.trs.cms.auth" + File.separatorChar + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label2", "config.xml]\u4e2d\u5b9a\u4e49\uff01")));
        }
        return n;
    }

    public int[] getRightIndexDefineOnCurrChannel(int n) {
        int[] nArray;
        if (this.m_mapRightIndexsDefineOnCurrChannel == null) {
            this.startup();
        }
        if ((nArray = (int[])this.m_mapRightIndexsDefineOnCurrChannel.get(new Integer(n))) != null) {
            return nArray;
        }
        nArray = (int[])this.m_mapRightIndexsDefineOnCurrChannel.get(new Integer(0));
        if (nArray != null) {
            return nArray;
        }
        return new int[0];
    }

    protected void doShutdown() {
        if (this.m_mRightObjects != null) {
            this.m_mRightObjects.clear();
            this.m_mRightObjects = null;
        }
        if (this.m_mRightHosts != null) {
            this.m_mRightHosts.clear();
            this.m_mRightHosts = null;
        }
    }

    protected boolean doStart() {
        this.initRightObjectsConfig();
        this.initRightHostsConfig();
        this.initOperationIndexConfig();
        this.initOperIndexDefineOnCurrChannelConfig();
        return true;
    }

    private synchronized void initRightHostsConfig() {
        if (this.m_mRightHosts != null) {
            return;
        }
        List list = this.m_oXMLConfigServer.getConfigObjects(RightHostConfig.class);
        if (list == null) {
            this.m_mRightHosts = new HashMap(0);
            return;
        }
        int n = list.size();
        HashMap<Integer, RightHostConfig> hashMap = new HashMap<Integer, RightHostConfig>(n);
        for (int i = 0; i < n; ++i) {
            RightHostConfig rightHostConfig = (RightHostConfig)list.get(i);
            if (rightHostConfig == null) continue;
            hashMap.put(new Integer(rightHostConfig.getRightHost().getType()), rightHostConfig);
        }
        this.m_mRightHosts = hashMap;
    }

    private synchronized void initRightObjectsConfig() {
        if (this.m_mRightObjects != null) {
            return;
        }
        List list = this.m_oXMLConfigServer.getConfigObjects(RightObjectConfig.class);
        int n = list.size();
        HashMap<Integer, RightObjectConfig> hashMap = new HashMap<Integer, RightObjectConfig>(n);
        for (int i = 0; i < n; ++i) {
            RightObjectConfig rightObjectConfig = (RightObjectConfig)list.get(i);
            if (rightObjectConfig == null) continue;
            hashMap.put(new Integer(rightObjectConfig.getRightObject().getType()), rightObjectConfig);
        }
        this.m_mRightObjects = hashMap;
    }

    private synchronized void initOperationIndexConfig() {
        if (this.m_pSimilarIndexs != null) {
            return;
        }
        int[][] nArray = new int[100][20];
        int[][] nArray2 = new int[100][20];
        HashMap hashMap = new HashMap(10);
        NamesRegister namesRegister = new NamesRegister();
        List list = this.m_oXMLConfigServer.getConfigObjects(OperationConfig.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            OperationConfig operationConfig = (OperationConfig)list.get(i);
            if (operationConfig == null) continue;
            this.initSimilarIndex(nArray, operationConfig);
            this.initDependIndex(nArray2, operationConfig);
            this.initTypeOperations(hashMap, operationConfig);
            this.initRightIndexes(namesRegister, operationConfig);
        }
        this.m_mapTypeOperationsTemp = hashMap;
        this.m_pSimilarIndexs = nArray;
        this.m_pDependIndexs = nArray2;
        this.m_mapRightIndexes = namesRegister;
    }

    private synchronized void initOperIndexDefineOnCurrChannelConfig() {
        if (this.m_mapRightIndexsDefineOnCurrChannel != null) {
            return;
        }
        List list = this.m_oXMLConfigServer.getConfigObjects(OperationDefineOnCurrChannelConfig.class);
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        if (n == 0) {
            this.m_mapRightIndexsDefineOnCurrChannel = new HashMap();
            return;
        }
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>(n);
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList;
            OperationDefineOnCurrChannelConfig operationDefineOnCurrChannelConfig = (OperationDefineOnCurrChannelConfig)list.get(i);
            if (operationDefineOnCurrChannelConfig == null || (arrayList = operationDefineOnCurrChannelConfig.getOperations()) == null || arrayList.isEmpty()) continue;
            int[] nArray = new int[arrayList.size()];
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                OperationConfig operationConfig = (OperationConfig)arrayList.get(j);
                if (operationConfig == null) continue;
                nArray[j] = operationConfig.getIndex();
            }
            hashMap.put(new Integer(operationDefineOnCurrChannelConfig.getSiteId()), nArray);
        }
        this.m_mapRightIndexsDefineOnCurrChannel = hashMap;
    }

    private void initRightIndexes(NamesRegister namesRegister, OperationConfig operationConfig) {
        String string = operationConfig.getName();
        if (string == null || string.length() == 0) {
            logger.warn((Object)(operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label3", "\u5b9a\u4e49\u6709\u8bef\uff0c\u6ca1\u6709\u8bbe\u7f6eName\u5c5e\u6027\uff01")));
            return;
        }
        if (namesRegister.contains(string = string.toUpperCase())) {
            logger.warn((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label4", "\u6743\u9650[") + string + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label5", "]\u91cd\u590d\u5b9a\u4e49!")));
        }
        namesRegister.register(string, operationConfig.getIndex());
    }

    private void initTypeOperations(Map map, OperationConfig operationConfig) {
        String string = operationConfig.getType();
        if (string == null || string.length() == 0) {
            logger.warn((Object)(operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label6", "\u5b9a\u4e49\u6709\u8bef\uff0c\u6ca1\u6709\u8bbe\u7f6eType\u8282\u70b9\uff01")));
            return;
        }
        ArrayList<OperationConfig> arrayList = (ArrayList<OperationConfig>)map.get(string = string.toUpperCase());
        if (arrayList == null) {
            arrayList = new ArrayList<OperationConfig>(20);
            map.put(string, arrayList);
        }
        arrayList.add(operationConfig);
    }

    private void initSimilarIndex(int[][] nArray, OperationConfig operationConfig) {
        OperationRelatedConfig operationRelatedConfig = operationConfig.getDepends();
        if (operationRelatedConfig == null) {
            return;
        }
        ArrayList arrayList = operationRelatedConfig.getOperations();
        OperationRelatedConfig operationRelatedConfig2 = operationConfig.getIncludeOperations();
        ArrayList arrayList2 = new ArrayList(0);
        if (operationRelatedConfig2 != null) {
            arrayList2 = operationRelatedConfig2.getOperations();
        }
        int n = operationConfig.getIndex();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            OperationConfig operationConfig2 = (OperationConfig)arrayList.get(i);
            if (operationConfig2 == null || arrayList2.contains(operationConfig2)) continue;
            int n3 = operationConfig2.getIndex();
            int n4 = this.getCurrentIndex(nArray[n3]);
            if (n4 < 0) {
                logger.error((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label9", "\u7c7b\u4f3c\u6743\u9650\u7f13\u51b2\u5df2\u6ee1\uff01\u7c7b\u4f3c\u6743\u9650[") + operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label7", "]\u4e0d\u80fd\u52a0\u5165\u5230\u6743\u9650[") + operationConfig2 + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label8", "]\u4e2d")));
                continue;
            }
            nArray[n3][n4] = n;
        }
    }

    private void initDependIndex(int[][] nArray, OperationConfig operationConfig) {
        OperationRelatedConfig operationRelatedConfig = operationConfig.getDepends();
        if (operationRelatedConfig == null) {
            return;
        }
        int n = operationConfig.getIndex();
        int n2 = this.getCurrentIndex(nArray[n]);
        ArrayList arrayList = operationRelatedConfig.getOperations();
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            OperationConfig operationConfig2 = (OperationConfig)arrayList.get(i);
            if (operationConfig2 == null) continue;
            if (n2 >= 20) {
                logger.error((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label10", "\u6743\u9650\u7f13\u51b2\u5df2\u6ee1\uff01\u4f9d\u8d56\u6743\u9650[") + operationConfig2 + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label7", "]\u4e0d\u80fd\u52a0\u5165\u5230\u6743\u9650[") + operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label8", "]\u4e2d")));
                continue;
            }
            nArray[n][n2] = operationConfig2.getIndex();
            ++n2;
        }
    }

    private int getCurrentIndex(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private Map getRightHosts() {
        if (this.m_mRightHosts == null) {
            this.initRightHostsConfig();
        }
        return this.m_mRightHosts;
    }

    private Map getRightObjects() {
        if (this.m_mRightObjects == null) {
            this.initRightObjectsConfig();
        }
        return this.m_mRightObjects;
    }

    public int[][] getSimilarIndexs() {
        if (this.m_pSimilarIndexs == null) {
            this.initOperationIndexConfig();
        }
        return this.m_pSimilarIndexs;
    }

    public int[][] getDependIndexs() {
        if (this.m_pDependIndexs == null) {
            this.initOperationIndexConfig();
        }
        return this.m_pDependIndexs;
    }
}

