/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObjs;
import org.apache.log4j.Logger;

public class AuthHelper {
    private static Logger logger = Logger.getLogger(AuthHelper.class);
    private static RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");

    public static boolean hasSuperRight(User user, CMSObj cMSObj) throws WCMException {
        if (user == null) {
            throw new WCMException(10, "\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u6821\u9a8c\u6743\u9650!");
        }
        if (user.isAdministrator()) {
            return true;
        }
        return cMSObj != null && user.getName().equalsIgnoreCase(cMSObj.getCrUserName());
    }

    public static boolean hasRightOnSelf(User user, CMSObj cMSObj, int[] nArray) throws WCMException {
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        if (user == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01");
        }
        if (user.isSystem()) {
            logger.warn((Object)"\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!");
            return false;
        }
        if (cMSObj == null) {
            return user.isAdministrator();
        }
        if (AuthHelper.hasSuperRight(user, cMSObj)) {
            return true;
        }
        BaseObjs baseObjs = null;
        BaseObjs baseObjs2 = null;
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        try {
            boolean bl;
            CMSObj cMSObj2;
            int n;
            boolean[] blArray = new boolean[nArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            long l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 204, user.getId(), -1L);
            if (l == WCMRightTypes.VALUE_ONLY_BROWSER) {
                n = AuthHelper.hasRight(l, nArray, blArray);
                if (n != 0) {
                    boolean bl2 = true;
                    return bl2;
                }
            } else if (l != -1L) {
                int n2;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    int n3 = nArray[n2];
                    if (AuthServer.hasRight(l, n3)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                n2 = 1;
                return n2 != 0;
            }
            baseObjs2 = user.getGroups();
            block14: for (n = 0; n < baseObjs2.size(); ++n) {
                cMSObj2 = (Group)baseObjs2.getAt(n);
                if (cMSObj2 == null) continue;
                l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 201, baseObjs2.getIdAt(n), -1L);
                if (l == -1L) {
                    for (Group group = ((Group)cMSObj2).getParent(); group != null && baseObjs2.indexOf(group.getId()) < 0; group = group.getParent()) {
                        l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 201, group.getId(), -1L);
                        if (l == -1L) continue;
                        bl = AuthHelper.hasRight(l, nArray, blArray);
                        if (!bl) continue block14;
                        boolean bl4 = true;
                        return bl4;
                    }
                    continue;
                }
                boolean bl5 = AuthHelper.hasRight(l, nArray, blArray);
                if (!bl5) continue;
                bl = true;
                return bl;
            }
            baseObjs = roleUserCacheMgr.getRoles(user, RightValue.getSite(cMSObj.getWCMType(), cMSObj.getId()));
            for (n = 0; n < baseObjs.size(); ++n) {
                boolean bl6;
                cMSObj2 = (Role)baseObjs.getAt(n);
                if (cMSObj2 == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + baseObjs.getIdAt(n) + "] of user[" + user.getName() + "] not exists!"));
                    continue;
                }
                l = ((Role)cMSObj2).isSystemRole() ? ((Role)cMSObj2).getRightValue() : rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 203, baseObjs.getIdAt(n), -1L);
                if (l == -1L || !(bl6 = AuthHelper.hasRight(l, nArray, blArray))) continue;
                bl = true;
                return bl;
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)", wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)", exception);
        }
        finally {
            if (baseObjs != null) {
                baseObjs.clear();
            }
            if (baseObjs2 != null) {
                baseObjs2.clear();
            }
        }
        return false;
    }

    private static boolean hasRight(long l, int[] nArray, boolean[] blArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[i]) continue;
            int n = nArray[i];
            if (AuthServer.hasRight(l, n)) {
                blArray[i] = true;
                continue;
            }
            bl = false;
        }
        return bl;
    }
}

