/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.support.log.LogServer;
import org.apache.batik.dom.util.HashTable;
import org.apache.log4j.Logger;

public class ContextHelper {
    private static Logger logger = Logger.getLogger(ContextHelper.class);
    private static final int ARG_INDEX_USER = BaseContextHelper.getNextIndex();
    private static final int ARG_INDEX_TESTVALUES = BaseContextHelper.getNextIndex();

    public static void initContext(User user) {
        ContextHelper.setLoginUser(user);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, user.getLoginIP());
    }

    public static User getLoginUser() {
        User user = (User)BaseContextHelper.getArg(ARG_INDEX_USER);
        if (user == null) {
            throw new RuntimeException("fatal error:no current user in threadlocal,iniContext please!");
        }
        return user;
    }

    public static void setLoginUser(User user) {
        if (user.getName().equalsIgnoreCase("system")) {
            logger.debug((Object)I18NMessage.get(ContextHelper.class, "ContextHelper.label1", "\u8c01\u4f7f\u7528System\u521d\u59cb\u5316ContextHelper?"), (Throwable)new Exception());
        }
        BaseContextHelper.setArg(ARG_INDEX_USER, user);
    }

    public static HashTable getTestValues() {
        HashTable hashTable = (HashTable)BaseContextHelper.getArg(ARG_INDEX_TESTVALUES);
        if (hashTable == null) {
            throw new RuntimeException("fatal error:no current user in threadlocal,iniContext please!");
        }
        return hashTable;
    }

    public static void setTestValues(HashTable hashTable) {
        BaseContextHelper.setArg(ARG_INDEX_TESTVALUES, hashTable);
    }

    public static Object getArg(int n) {
        return BaseContextHelper.getArg(n);
    }

    public static int setArg(int n, Object object) {
        return BaseContextHelper.setArg(n, object);
    }

    public static void clear() {
        BaseContextHelper.clear();
    }
}

