/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.cluster.ext.wcm.ClusterProxyFilter;
import com.trs.cluster.ext.wcm.MemberServiceChecker;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.util.AtomicInteger;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.TRSMailer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemberShipNotifier
implements MemberListener {
    private static final Logger LOG = Logger.getLogger(MemberShipNotifier.class);
    private AtomicInteger m_oCounter = new AtomicInteger();
    private static final long WAIT_CYCLE = 120000L;
    private Map m_oNotifiers;
    private Member localMember;

    public MemberShipNotifier(Member member) {
        this.localMember = member;
        this.m_oNotifiers = new ConcurrentHashMap(4);
    }

    public void memberFailed(Member member) {
        this.proxyIfNeed(member);
        Notifier notifier = new Notifier(member);
        this.m_oNotifiers.put(member._guid(), notifier);
        new Thread(notifier).start();
    }

    private void proxyIfNeed(Member member) {
        if (MemberServiceChecker.isAlive(member)) {
            this.m_oCounter.incrementAndGet();
            ClusterProxyFilter.setProxyAll(true);
        }
    }

    private void sendNotifyMail(Member member) {
        CMyEmail cMyEmail = new CMyEmail();
        cMyEmail.setMailFormat(0);
        cMyEmail.setFromUser("wcm-alert");
        cMyEmail.setSubject("[\u96c6\u7fa4\u8b66\u62a5]\u53d1\u73b0\u8282\u70b9\u6210\u5458\u5de5\u4f5c\u4e0d\u6b63\u5e38,\u8bf7\u68c0\u67e5.");
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\u96c6\u7fa4\u6210\u5458[");
        stringBuffer.append(this.localMember);
        stringBuffer.append("]\u53d1\u73b0\u65e0\u6cd5\u4e0e\u6210\u5458[");
        stringBuffer.append(member);
        stringBuffer.append("]\u6b63\u5e38\u901a\u4fe1,\u8bf7\u68c0\u67e5.\n\u672c\u90ae\u4ef6\u4e0d\u9700\u8981\u56de\u590d,\u8c22\u8c22.");
        stringBuffer.append("\n\n" + CMyDateTime.now());
        cMyEmail.setBody(stringBuffer.toString());
        String string = this.getEmailList();
        if (string.length() == 0) {
            LOG.warn((Object)"No admin user to notify?.");
            return;
        }
        cMyEmail.setTo(string);
        TRSMailer tRSMailer = new TRSMailer();
        try {
            tRSMailer.send(cMyEmail);
        }
        catch (CMyMailException cMyMailException) {
            LOG.error((Object)"failed to notify the administrators.", (Throwable)cMyMailException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmailList() {
        String string;
        try {
            string = ConfigServer.getServer().getSysConfigValue("cluster.extra.maillist", null);
            if (string != null && string.trim().length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = "select u.email from wcmuser u, wcmroleuser ru where ru.roleid=1 and ru.userid=u.userid";
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        try {
            connection = dBManager.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                stringBuffer.append(';').append(string2);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Failed to query administrators.", (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    dBManager.freeConnection(connection);
                }
                catch (Exception exception) {}
            }
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.substring(1).intern();
    }

    public void memberJoined(Member member) {
        Notifier notifier;
        int n = this.m_oCounter.get();
        if (n > 0 && (n = this.m_oCounter.decrementAndGet()) == 0) {
            ClusterProxyFilter.setProxyAll(false);
        }
        if ((notifier = (Notifier)this.m_oNotifiers.remove(member._guid())) != null) {
            notifier.cancle();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cancle a failed notify for: " + member));
            }
        }
    }

    public void memberLeft(Member member) {
    }

    private class Notifier
    implements Runnable {
        private Member member = null;
        private boolean cancled = false;

        public Notifier(Member member) {
            this.member = member;
        }

        public synchronized void run() {
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                this.cancled = true;
            }
            if (!this.cancled) {
                MemberShipNotifier.this.sendNotifyMail(this.member);
            }
        }

        public synchronized void cancle() {
            this.cancled = true;
            this.notifyAll();
        }
    }
}

