/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import com.trs.DreamFactory;
import com.trs.cluster.ext.wcm.ClusterProxyFilter;
import com.trs.cluster.ext.wcm.MemberServiceChecker;
import com.trs.components.common.job.JobScheduleServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.TokenEvent;
import com.trs.infra.cluster.TokenListener;
import com.trs.infra.cluster.locks.tokenevent.TokenOwnedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenReceivedEvent;
import com.trs.infra.cluster.locks.tokenevent.TokenSuspectEvent;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class MasterTokenListener
implements TokenListener {
    private static final Logger LOG = Logger.getLogger(MasterTokenListener.class);

    public boolean actionPerformed(TokenEvent tokenEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("performe token action: " + tokenEvent));
        }
        if (tokenEvent instanceof TokenSuspectEvent) {
            return this.doSuspect((TokenSuspectEvent)tokenEvent);
        }
        if (tokenEvent instanceof TokenOwnedEvent) {
            return this.doOwned((TokenOwnedEvent)tokenEvent);
        }
        if (tokenEvent instanceof TokenReceivedEvent) {
            return this.doReceived(tokenEvent);
        }
        return true;
    }

    private boolean doReceived(TokenEvent tokenEvent) {
        ClusterProxyFilter.setMasterProxy(tokenEvent.getSource());
        return true;
    }

    private boolean doSuspect(TokenSuspectEvent tokenSuspectEvent) {
        Member member = tokenSuspectEvent.getSource();
        boolean bl = MemberServiceChecker.isAlive(member);
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOwned(TokenOwnedEvent tokenOwnedEvent) {
        JobScheduleServer jobScheduleServer;
        tokenOwnedEvent.getContext().getConfig().setMaster(true);
        IPublishTaskDispatcher iPublishTaskDispatcher = (IPublishTaskDispatcher)DreamFactory.createObjectById("IPublishTaskDispatcher");
        try {
            iPublishTaskDispatcher.startup();
        }
        catch (WCMException wCMException) {
            LOG.error((Object)"master token owned faield.", (Throwable)wCMException);
            return false;
        }
        JobScheduleServer jobScheduleServer2 = jobScheduleServer = (JobScheduleServer)DreamFactory.createObjectById("JobScheduleServer");
        synchronized (jobScheduleServer2) {
            if (!jobScheduleServer.isStarted()) {
                if (!jobScheduleServer.startup()) {
                    return false;
                }
            } else if (!jobScheduleServer.restart()) {
                return false;
            }
            LOG.info((Object)"\u8ba1\u5212\u8c03\u5ea6\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6210.");
        }
        PageDestroyer.reinit();
        ClusterProxyFilter.setMasterProxy(null);
        LOG.info((Object)"Master token owned success.");
        return true;
    }
}

