/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxy {
    private static final String HEAD_XFORWARDED = "X-Forwarded-For";
    private static final int BUFF_SIZE = 20480;
    private int m_nBuffSize = 20480;
    private String m_sProxyHost;
    private int m_nProxyPort;
    private Set m_oIgnoreHeaders = new HashSet();

    public HttpProxy() {
        this.initIgnoreHeaders();
    }

    private void initIgnoreHeaders() {
        this.m_oIgnoreHeaders.add("proxy-connection");
        this.m_oIgnoreHeaders.add("connection");
        this.m_oIgnoreHeaders.add("keep-alive");
        this.m_oIgnoreHeaders.add("transfer-encoding");
        this.m_oIgnoreHeaders.add("te");
        this.m_oIgnoreHeaders.add("trailer");
        this.m_oIgnoreHeaders.add("proxy-authorization");
        this.m_oIgnoreHeaders.add("proxy-authenticate");
        this.m_oIgnoreHeaders.add("upgrade");
    }

    public void proxy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Object object;
        String string2;
        String string3 = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            string3 = string3 + "?" + httpServletRequest.getQueryString();
        }
        URL uRL = new URL(httpServletRequest.getScheme(), this.m_sProxyHost, this.m_nProxyPort, string3);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setRequestMethod(httpServletRequest.getMethod());
        httpURLConnection.setInstanceFollowRedirects(false);
        String string4 = httpServletRequest.getHeader("Connection");
        if (string4 != null && ((string4 = string4.toLowerCase()).equals("keep-alive") || string4.equals("close"))) {
            string4 = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object = string2.toLowerCase();
            if (this.m_oIgnoreHeaders.contains(object) || string4 != null && string4.indexOf((String)object) >= 0) continue;
            if ("content-type".equals(object)) {
                bl2 = true;
            }
            Enumeration enumeration2 = httpServletRequest.getHeaders(string2);
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                if (string == null) continue;
                httpURLConnection.addRequestProperty(string2, string);
                bl |= HEAD_XFORWARDED.equalsIgnoreCase(string2);
            }
        }
        if (!bl) {
            httpURLConnection.addRequestProperty(HEAD_XFORWARDED, httpServletRequest.getRemoteAddr());
        }
        if ((string2 = httpServletRequest.getHeader("Cache-Control")) != null && ((string2 = string2.toLowerCase()).indexOf("no-cache") >= 0 || string2.indexOf("no-store") >= 0)) {
            httpURLConnection.setUseCaches(false);
        }
        httpURLConnection.setDoInput(true);
        if (bl2) {
            object = httpServletRequest.getInputStream();
            httpURLConnection.setDoOutput(true);
            this.copyStream((InputStream)object, httpURLConnection.getOutputStream());
        }
        httpURLConnection.connect();
        object = null;
        object = httpURLConnection.getErrorStream();
        httpServletResponse.setStatus(httpURLConnection.getResponseCode());
        if (object == null) {
            try {
                object = httpURLConnection.getInputStream();
            }
            catch (Exception exception) {
                object = httpURLConnection.getErrorStream();
            }
        }
        int n = 0;
        string = httpURLConnection.getHeaderFieldKey(n);
        String string5 = httpURLConnection.getHeaderField(n);
        while (string != null || string5 != null) {
            if (string != null && string5 != null && !this.m_oIgnoreHeaders.contains(string.toLowerCase()) && !httpServletResponse.containsHeader(string)) {
                httpServletResponse.setHeader(string, string5);
            }
            string = httpURLConnection.getHeaderFieldKey(++n);
            string5 = httpURLConnection.getHeaderField(n);
        }
        httpServletResponse.addHeader("WcmClusterRespProxy", this.m_sProxyHost + ":" + this.m_nProxyPort);
        if (object != null) {
            this.copyStream((InputStream)object, (OutputStream)httpServletResponse.getOutputStream());
            ((InputStream)object).close();
        }
        httpURLConnection.disconnect();
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.m_nBuffSize];
        int n = -1;
        while ((n = inputStream.read(byArray, 0, this.m_nBuffSize)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public String getHost() {
        return this.m_sProxyHost;
    }

    public void setHost(String string) {
        this.m_sProxyHost = string;
    }

    public int getPort() {
        return this.m_nProxyPort;
    }

    public void setPort(int n) {
        this.m_nProxyPort = n;
    }

    public void setBuffSize(int n) {
        if (n > 0) {
            this.m_nBuffSize = n;
        }
    }

    public void addIgnoreHeader(String string) {
        if (string == null) {
            return;
        }
        this.m_oIgnoreHeaders.add(string.toLowerCase().intern());
    }

    public void clear() {
        this.m_oIgnoreHeaders.clear();
    }
}

