/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import com.trs.cluster.ext.wcm.HttpProxy;
import com.trs.cluster.ext.wcm.MemberInfo;
import com.trs.infra.cluster.Member;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClusterProxyFilter
implements Filter {
    private static boolean m_zAllProxyed = false;
    private static boolean m_zProxyed = false;
    private static HttpProxy m_oProxy = new HttpProxy();

    public void destroy() {
        m_zProxyed = false;
        m_oProxy.clear();
        m_oProxy = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (m_zProxyed && m_zAllProxyed) {
            m_oProxy.proxy((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String string = filterConfig.getInitParameter("IgnoreHeaders");
        if (string != null && string.trim().length() == 0) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            for (int i = n - 1; i >= 0; --i) {
                m_oProxy.addIgnoreHeader(stringArray[i]);
                stringArray[i] = null;
            }
        }
        int n = 0;
        try {
            n = Integer.parseInt(filterConfig.getInitParameter("BufferSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            m_oProxy.setBuffSize(n);
        }
    }

    static synchronized void setMasterProxy(Member member) {
        MemberInfo memberInfo;
        if (member != null && (memberInfo = (MemberInfo)member.getAttribute("cluster.extra.MemberInfo")) != null) {
            m_oProxy.setHost(memberInfo.getHost());
            m_oProxy.setPort(memberInfo.getPort());
            m_zProxyed = true;
            return;
        }
        m_zProxyed = false;
    }

    static synchronized void setProxyAll(boolean bl) {
        m_zAllProxyed = bl;
    }

    static HttpProxy getProxy() {
        if (m_zProxyed) {
            return m_oProxy;
        }
        return null;
    }
}

