/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.cluster.ClusterConfigHelper;
import com.trs.cluster.TRSClusterExtensionImpl;
import com.trs.cluster.ext.wcm.ActionMessage;
import com.trs.cluster.ext.wcm.ActionMessages;
import com.trs.cluster.ext.wcm.MasterTokenListener;
import com.trs.cluster.ext.wcm.MemberInfo;
import com.trs.cluster.ext.wcm.MemberShipNotifier;
import com.trs.infra.BaseServer;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.ExtensionManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.TokenListener;
import com.trs.infra.cluster.impl.ClusterContextImpl;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.io.FilterStreamWriter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TRSWCMClusterServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(TRSWCMClusterServer.class);
    private static final String GUID_TRSWCM_CLUSTER = "TRSWCMClustorEx1.0";
    private ClusterContextImpl m_oClusterContextImpl = null;

    protected void doShutdown() {
        if (this.m_oClusterContextImpl == null) {
            return;
        }
        this.m_oClusterContextImpl.close();
        this.m_oClusterContextImpl = null;
    }

    protected boolean doStart() throws WCMException {
        if (this.m_oClusterContextImpl != null) {
            return true;
        }
        ClusterConfig clusterConfig = ClusterConfigHelper.getConfig();
        if (!clusterConfig.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not a cluster member.");
            }
            return true;
        }
        ClusterContextImpl clusterContextImpl = new ClusterContextImpl();
        clusterContextImpl.setConfig(clusterConfig);
        ExtensionManager extensionManager = clusterContextImpl.getExtensionManager();
        TRSClusterExtensionImpl tRSClusterExtensionImpl = new TRSClusterExtensionImpl(GUID_TRSWCM_CLUSTER);
        extensionManager.addExtension((Extension)tRSClusterExtensionImpl);
        clusterContextImpl.start();
        this.setAfterStarted(clusterContextImpl);
        this.m_oClusterContextImpl = clusterContextImpl;
        new Redo().start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAfterStarted(ClusterContextImpl clusterContextImpl) {
        Member member = clusterContextImpl.getMemberManager().member();
        clusterContextImpl.getMemberManager().addListener((MemberListener)new MemberShipNotifier(member));
        MemberInfo memberInfo = new MemberInfo();
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = this.getClass().getResourceAsStream("/trswcmcluster.properties");
            properties.load(inputStream);
            String string = properties.getProperty("cluster.extra.serviceAddress");
            if (CMyString.isEmpty(string)) {
                logger.warn((Object)"cluster.extra.serviceAddress has not config properly!");
                string = member.getTCPAddress().getHostAddress();
            }
            memberInfo.setHost(string);
            string = properties.getProperty("cluster.extra.servicePort", "8080");
            memberInfo.setPort(Integer.parseInt(string));
            string = properties.getProperty("cluster.extra.serviceCheckURL");
            memberInfo.setCheckURL(string);
            member.setAttribute("cluster.extra.MemberInfo", (Object)memberInfo);
        }
        catch (Exception exception) {
            logger.warn((Object)"init member extra attributes failed.", (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            properties.clear();
        }
        clusterContextImpl.getTokenManager().addListener("cluster.token.MasterNode", (TokenListener)new MasterTokenListener());
    }

    public void sendMsg(Serializable serializable) {
        if (this.m_oClusterContextImpl == null || !this.m_oClusterContextImpl.getConfig().isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Not a cluster member.");
            }
            return;
        }
        this.m_oClusterContextImpl.getExtensionManager().sendToCluster(GUID_TRSWCM_CLUSTER, serializable);
    }

    public void sendMsg(Serializable serializable, boolean bl) {
        if (bl) {
            Member member = this.m_oClusterContextImpl.getMemberManager().member();
            try {
                String string = TRSWCMClusterServer.serializeMessage(serializable);
                ActionMessage actionMessage = new ActionMessage();
                actionMessage.setBody(string);
                actionMessage.setHashValue(string.hashCode());
                actionMessage.setSourceGUID(member._guid());
                actionMessage.save();
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to persistent the message.", (Throwable)exception);
            }
        }
        this.sendMsg(serializable);
    }

    public ClusterContext getContext() {
        return this.m_oClusterContextImpl;
    }

    public String getGUID() {
        return GUID_TRSWCM_CLUSTER;
    }

    public static String serializeMessage(Serializable serializable) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        FilterStreamWriter filterStreamWriter = new FilterStreamWriter((OutputStream)byteArrayOutputStream);
        filterStreamWriter.write_object(serializable);
        return byteArrayOutputStream.toString("ISO-8859-1");
    }

    public static Object deserializeMessage(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterStreamReader filterStreamReader = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("ISO-8859-1"));
            filterStreamReader = new FilterStreamReader((InputStream)byteArrayInputStream);
            return filterStreamReader.read_object();
        }
        catch (Exception exception) {
            logger.warn((Object)"Failed to deserialize cluster message.", (Throwable)exception);
            return null;
        }
    }

    private class Redo
    extends Thread {
        private static final int HALF_MINUTE = 30000;

        public Redo() {
            super("ClusterActionMsgRedo");
        }

        public void run() {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                WCMFilter wCMFilter = new WCMFilter("", "MSGDATE=?", "XWCMCLUSTERACTIONMSGID asc");
                wCMFilter.addSearchValues(CMyDateTime.now().toString("yyyyMMdd"));
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.open(wCMFilter);
                ClusterContext clusterContext = TRSWCMClusterServer.this.getContext();
                Extension extension = clusterContext.getExtensionManager().getExtension(TRSWCMClusterServer.GUID_TRSWCM_CLUSTER);
                MemberManager memberManager = clusterContext.getMemberManager();
                Member member = memberManager.member();
                String string = member._guid();
                HashSet<String> hashSet = new HashSet<String>();
                int n = actionMessages.size();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    ActionMessage actionMessage = (ActionMessage)actionMessages.getAt(i);
                    if (actionMessage == null || string.equals(actionMessage.getSourceGUID()) || hashSet.contains(String.valueOf(actionMessage.getHashValue())) || (object = TRSWCMClusterServer.deserializeMessage(actionMessage.getBody())) == null) continue;
                    Member member2 = memberManager.find(actionMessage.getSourceGUID());
                    if (member2 == null) {
                        member2 = member;
                    }
                    extension.callByCluster(object, member2);
                    hashSet.add(String.valueOf(actionMessage.getHashValue()));
                }
                hashSet.clear();
                actionMessages.clear();
            }
            catch (Exception exception) {
                logger.warn((Object)"Failed to redo the message.", (Throwable)exception);
            }
        }
    }
}

