/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cluster.IClusterMsgReceiver;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cms.ObjectTypeServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ClusterMsgCenterImpl
implements IClusterMsgCenter {
    private static Logger logger = Logger.getLogger(ClusterMsgCenterImpl.class);
    private HashMap m_hReceiversOfWCMObjOnAdd = null;
    private HashMap m_hReceiversOfWCMObjOnModify = null;
    private HashMap m_hReceiversOfWCMObjOnDel = null;
    private HashMap m_hReceiversOfMessage = null;
    private TRSWCMClusterServer m_oClusterServer = null;
    private boolean m_bStartCluster = true;

    public void receive(int n, int n2, int n3) throws Exception {
        Serializable serializable;
        if (logger.isDebugEnabled()) {
            serializable = new StringBuffer(128);
            ((StringBuffer)serializable).append("Cluster Msg Received: ObjType=");
            ((StringBuffer)serializable).append(n);
            ((StringBuffer)serializable).append(", ObjId=");
            ((StringBuffer)serializable).append(n2);
            ((StringBuffer)serializable).append(", Event=");
            ((StringBuffer)serializable).append(n3);
            logger.debug((Object)serializable);
            ((StringBuffer)serializable).setLength(0);
        }
        if (this.m_hReceiversOfWCMObjOnAdd == null) {
            this.loadConfigs();
        }
        if ((serializable = ObjectTypeServer.get(n)) == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + n + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        boolean bl = iCachedPOMgr.isCached((Class)serializable);
        BaseObj baseObj = this.makeCurrPOObject((Class)serializable, n2, n3);
        if (bl) {
            switch (n3) {
                case 1: {
                    iCachedPOMgr.notifyOnAddObj(baseObj);
                    break;
                }
                case 3: {
                    iCachedPOMgr.notifyOnDelObj(baseObj, 4);
                }
            }
        }
        IClusterMsgReceiver[] iClusterMsgReceiverArray = this.findReceiversByWCMObj(n, n3);
        for (int i = 0; iClusterMsgReceiverArray != null && i < iClusterMsgReceiverArray.length; ++i) {
            iClusterMsgReceiverArray[i].receive(baseObj, n3);
        }
        if (bl && n3 == 2) {
            Hashtable hashtable = baseObj.getProperties();
            hashtable.clear();
            Hashtable hashtable2 = baseObj.getNewProperties();
            hashtable.putAll(hashtable2);
            hashtable2.clear();
        }
    }

    public void receive(int n, int n2, int n3, Hashtable hashtable) throws Exception {
        Serializable serializable;
        if (logger.isDebugEnabled()) {
            serializable = new StringBuffer(256);
            ((StringBuffer)serializable).append("Cluster Msg Received: ObjType=");
            ((StringBuffer)serializable).append(n);
            ((StringBuffer)serializable).append(", ObjId=");
            ((StringBuffer)serializable).append(n2);
            ((StringBuffer)serializable).append(", Event=");
            ((StringBuffer)serializable).append(n3);
            ((StringBuffer)serializable).append(". ObjProps=");
            ((StringBuffer)serializable).append(hashtable);
            logger.debug((Object)serializable);
            ((StringBuffer)serializable).setLength(0);
        }
        if (this.m_hReceiversOfWCMObjOnDel == null) {
            this.loadConfigs();
        }
        if (hashtable == null) {
            throw new WCMException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u5bf9\uff01");
        }
        serializable = ObjectTypeServer.get(n);
        if (serializable == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + n + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        BaseObj baseObj = this.makeCurrPOFromProperties((Class)serializable, n2, n3, hashtable);
        IClusterMsgReceiver[] iClusterMsgReceiverArray = this.findReceiversByWCMObj(n, n3);
        for (int i = 0; iClusterMsgReceiverArray != null && i < iClusterMsgReceiverArray.length; ++i) {
            iClusterMsgReceiverArray[i].receive(baseObj, n3);
        }
        if (2 == n3) {
            baseObj.getProperties().clear();
            baseObj.setProperties(baseObj.getNewProperties());
            baseObj.getNewProperties().clear();
        }
    }

    public void receive(String string, String[] stringArray) throws Exception {
        int n;
        Object object;
        if (logger.isDebugEnabled()) {
            object = new StringBuffer(128);
            ((StringBuffer)object).append("Cluster Msg Received: MsgType=");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(", Params=");
            if (stringArray != null && stringArray.length > 0) {
                ((StringBuffer)object).append(stringArray[0]);
                int n2 = stringArray.length;
                for (n = 1; n < n2; ++n) {
                    ((StringBuffer)object).append(", ").append(stringArray[n]);
                }
            } else {
                ((StringBuffer)object).append("None");
            }
            logger.debug(object);
            ((StringBuffer)object).setLength(0);
        }
        object = this.findReceiversByMessage(string);
        for (n = 0; object != null && n < ((Object)object).length; ++n) {
            object[n].receive(string, stringArray);
        }
    }

    private void send(int n, int n2, int n3) throws Exception {
        if (!this.m_bStartCluster) {
            return;
        }
        if (this.m_oClusterServer == null) {
            this.initClusterServer();
        }
        if (!this.isNeedSendMsg(n, n3)) {
            return;
        }
        int[] nArray = new int[]{n, n2, n3};
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Cluster Msg Send: ObjType=");
            stringBuffer.append(n);
            stringBuffer.append(", ObjId=");
            stringBuffer.append(n2);
            stringBuffer.append(", Event=");
            stringBuffer.append(n3);
            logger.debug((Object)stringBuffer, (Throwable)new Exception("For call stack inspect."));
            stringBuffer.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)nArray);
    }

    public void send(int n, int n2, int n3, Hashtable hashtable) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        if (hashtable == null || this.isCached(n)) {
            this.send(n, n2, n3);
            return;
        }
        if (this.findReceiversByWCMObj(n, n3) == null) {
            return;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = new Integer(n);
        objectArray[1] = new Integer(n2);
        objectArray[2] = new Integer(n3);
        Hashtable hashtable2 = new Hashtable(hashtable.size());
        hashtable2.putAll(hashtable);
        objectArray[3] = hashtable2;
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Cluster Msg Send: ObjType=");
            stringBuffer.append(n);
            stringBuffer.append(", ObjId=");
            stringBuffer.append(n2);
            stringBuffer.append(", Event=");
            stringBuffer.append(n3);
            stringBuffer.append(". ObjProps=");
            stringBuffer.append(hashtable);
            logger.debug((Object)stringBuffer, (Throwable)new Exception("For call stack inspect."));
            stringBuffer.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)objectArray);
    }

    private boolean initClusterServer() {
        this.m_oClusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        if (this.m_oClusterServer == null || this.m_oClusterServer.getContext() == null) {
            this.m_bStartCluster = false;
            return false;
        }
        this.m_bStartCluster = this.m_oClusterServer.getContext().getConfig().isEnabled();
        return this.m_bStartCluster;
    }

    private boolean isNeedSendMsg(int n, int n2) throws Exception {
        if (this.isCached(n)) {
            return true;
        }
        return this.findReceiversByWCMObj(n, n2) != null;
    }

    private boolean isCached(int n) throws WCMException {
        Class clazz = ObjectTypeServer.get(n);
        if (clazz == null) {
            return false;
        }
        ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        return iCachedPOMgr.isCached(clazz);
    }

    public void send(String string, String[] stringArray) throws Exception {
        this.send(string, stringArray, false);
    }

    public void send(String string, String[] stringArray, boolean bl) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        if (this.findReceiversByMessage(string) == null) {
            return;
        }
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        if (logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Cluster Msg Send: MsgType=");
            stringBuffer.append(string);
            stringBuffer.append(", Params=");
            if (stringArray != null && stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
                int n = stringArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(", ").append(stringArray[i]);
                }
            } else {
                stringBuffer.append("None");
            }
            logger.debug((Object)stringBuffer, (Throwable)new Exception("For call stack inspect."));
            stringBuffer.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)stringArray2, bl);
    }

    public synchronized void loadConfigs() throws Exception {
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(IClusterMsgReceiver.class.getName());
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Class<?> clazz = Class.forName(string);
            IClusterMsgReceiver iClusterMsgReceiver = (IClusterMsgReceiver)clazz.newInstance();
            this.registerReceiversOfWCMObj(iClusterMsgReceiver, iClusterMsgReceiver.registerMoniterWCMObjTypesOnAdd(), hashMap);
            this.registerReceiversOfWCMObj(iClusterMsgReceiver, iClusterMsgReceiver.registerMoniterWCMObjTypesOnModify(), hashMap2);
            this.registerReceiversOfWCMObj(iClusterMsgReceiver, iClusterMsgReceiver.registerMoniterWCMObjTypesOnDel(), hashMap3);
            this.registerReceiversOfMessage(iClusterMsgReceiver, hashMap4);
        }
        if (this.m_hReceiversOfWCMObjOnAdd != null) {
            this.m_hReceiversOfWCMObjOnAdd.clear();
            this.m_hReceiversOfWCMObjOnAdd = null;
        }
        this.m_hReceiversOfWCMObjOnAdd = hashMap;
        if (this.m_hReceiversOfWCMObjOnModify != null) {
            this.m_hReceiversOfWCMObjOnModify.clear();
            this.m_hReceiversOfWCMObjOnModify = null;
        }
        this.m_hReceiversOfWCMObjOnModify = hashMap2;
        if (this.m_hReceiversOfWCMObjOnDel != null) {
            this.m_hReceiversOfWCMObjOnDel.clear();
            this.m_hReceiversOfWCMObjOnDel = null;
        }
        this.m_hReceiversOfWCMObjOnDel = hashMap3;
        if (this.m_hReceiversOfMessage != null) {
            this.m_hReceiversOfMessage.clear();
        }
        this.m_hReceiversOfMessage = null;
        this.m_hReceiversOfMessage = hashMap4;
    }

    IClusterMsgReceiver[] findReceiversByWCMObj(int n, int n2) throws Exception {
        HashMap hashMap = null;
        switch (n2) {
            case 1: {
                hashMap = this.m_hReceiversOfWCMObjOnAdd;
                break;
            }
            case 3: {
                hashMap = this.m_hReceiversOfWCMObjOnDel;
                break;
            }
            case 2: {
                hashMap = this.m_hReceiversOfWCMObjOnModify;
            }
        }
        if (hashMap == null) {
            this.loadConfigs();
        }
        if (hashMap == null) {
            return null;
        }
        Integer n3 = new Integer(n);
        return (IClusterMsgReceiver[])hashMap.get(n3);
    }

    IClusterMsgReceiver[] findReceiversByMessage(String string) throws Exception {
        if (this.m_hReceiversOfMessage == null) {
            this.loadConfigs();
        }
        return (IClusterMsgReceiver[])this.m_hReceiversOfMessage.get(string.toUpperCase());
    }

    private void registerReceiversOfWCMObj(IClusterMsgReceiver iClusterMsgReceiver, int[] nArray, HashMap hashMap) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = new Integer(nArray[i]);
            Class clazz = ObjectTypeServer.get(n);
            if (clazz == null) {
                logger.error((Object)("\u6307\u5b9a\u7c7b\u578b[" + n + "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u6ce8\u518c\u6d88\u606f\u76d1\u542c\u5668[" + iClusterMsgReceiver.getClass().getName() + "]\u5931\u8d25\uff01"));
                continue;
            }
            IClusterMsgReceiver[] iClusterMsgReceiverArray = (IClusterMsgReceiver[])hashMap.get(n);
            if (iClusterMsgReceiverArray == null) {
                iClusterMsgReceiverArray = new IClusterMsgReceiver[1];
            } else {
                IClusterMsgReceiver[] iClusterMsgReceiverArray2 = new IClusterMsgReceiver[iClusterMsgReceiverArray.length + 1];
                System.arraycopy(iClusterMsgReceiverArray, 0, iClusterMsgReceiverArray2, 0, iClusterMsgReceiverArray.length);
                iClusterMsgReceiverArray = iClusterMsgReceiverArray2;
            }
            iClusterMsgReceiverArray[iClusterMsgReceiverArray.length - 1] = iClusterMsgReceiver;
            hashMap.put(n, iClusterMsgReceiverArray);
        }
    }

    private void registerReceiversOfMessage(IClusterMsgReceiver iClusterMsgReceiver, HashMap hashMap) {
        String[] stringArray = iClusterMsgReceiver.registerMoniterMessages();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toUpperCase();
            IClusterMsgReceiver[] iClusterMsgReceiverArray = (IClusterMsgReceiver[])hashMap.get(string);
            if (iClusterMsgReceiverArray == null) {
                iClusterMsgReceiverArray = new IClusterMsgReceiver[1];
            } else {
                IClusterMsgReceiver[] iClusterMsgReceiverArray2 = new IClusterMsgReceiver[iClusterMsgReceiverArray.length + 1];
                System.arraycopy(iClusterMsgReceiverArray, 0, iClusterMsgReceiverArray2, 0, iClusterMsgReceiverArray.length);
                iClusterMsgReceiverArray = iClusterMsgReceiverArray2;
            }
            iClusterMsgReceiverArray[iClusterMsgReceiverArray.length - 1] = iClusterMsgReceiver;
            hashMap.put(string, iClusterMsgReceiverArray);
        }
    }

    private BaseObj makeCurrPOObject(Class clazz, int n, int n2) throws InstantiationException, IllegalAccessException, WCMException {
        BaseObj baseObj = null;
        switch (n2) {
            case 1: {
                baseObj = (BaseObj)clazz.newInstance();
                baseObj.loadById(n, "*");
                break;
            }
            case 2: {
                baseObj = BaseObj.findById(clazz, n);
                if (baseObj == null) break;
                baseObj.loadById(n, "*", true);
                break;
            }
            case 3: {
                baseObj = BaseObj.findById(clazz, n);
                break;
            }
            default: {
                throw new WCMException("unkown the message type![ID=" + n2 + "]");
            }
        }
        if (baseObj == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bf9\u8c61\u5728DB\u4e2d\u4e0d\u5b58\u5728\uff01[Class=" + clazz + ", ID=" + n + "]");
        }
        return baseObj;
    }

    private BaseObj makeCurrPOFromProperties(Class clazz, int n, int n2, Hashtable hashtable) throws InstantiationException, IllegalAccessException, WCMException {
        BaseObj baseObj = null;
        switch (n2) {
            case 1: 
            case 3: {
                baseObj = (BaseObj)clazz.newInstance();
                baseObj.setId(n);
                baseObj.setProperties(hashtable);
                break;
            }
            case 2: {
                baseObj = BaseObj.findById(clazz, n);
                if (baseObj == null) break;
                baseObj.setNewProperties(baseObj.getProperties());
                baseObj.setProperties(hashtable);
                break;
            }
            default: {
                throw new WCMException("unkown the message type![ID=" + n2 + "]");
            }
        }
        if (baseObj == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bf9\u8c61\u5728DB\u4e2d\u4e0d\u5b58\u5728\uff01[Class=" + clazz + ", ID=" + n + "]");
        }
        return baseObj;
    }

    public boolean isStarted() {
        return this.m_bStartCluster;
    }

    public void send(BaseObj baseObj, int n) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        int n2 = baseObj.getWCMType();
        int n3 = baseObj.getId();
        if (baseObj.isCached()) {
            this.send(n2, n3, n);
        } else {
            if (this.findReceiversByWCMObj(n2, n) == null) {
                return;
            }
            if (n == 2 && !baseObj.isModified(true)) {
                return;
            }
            Hashtable hashtable = baseObj.getProperties();
            if (hashtable == null) {
                hashtable = new Hashtable(2);
            }
            this.send(n2, n3, n, hashtable);
        }
    }

    protected boolean isClusterRunning() {
        if (!this.m_bStartCluster) {
            return false;
        }
        return this.m_oClusterServer != null || this.initClusterServer();
    }
}

