/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ViewDocumentToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ViewDocumentToXML.class);
    private static final int DOCCHANNEL = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCHTMLCON = 3;
    private static final int DOCTYPE = 4;
    private static final int DOCSOURCE = 5;
    private static final int CHNLID = 6;

    public ViewDocumentToXML() {
        this.m_bToXMLDependsOnSelectFields = false;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCHANNEL", 1);
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCHTMLCON", 3);
        this.registerHostSpecialProperty("DOCTYPE", 4);
        this.registerHostSpecialProperty("DOCSOURCE", 5);
        this.registerHostSpecialProperty("CHNLID", 6);
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        ViewDocument viewDocument = (ViewDocument)baseObj;
        try {
            switch (n) {
                case 1: {
                    return this.makeChannelValue(viewDocument.getDocChannel());
                }
                case 2: {
                    return this.makeStatus(viewDocument.getStatus());
                }
                case 3: {
                    return this.makeHTMLCon(viewDocument);
                }
                case 4: {
                    return new String[][]{{"Type", object.toString()}, {"Name", viewDocument.getTypeString()}};
                }
                case 5: {
                    return this.makeDocSource(viewDocument.getSource(), object);
                }
                case 6: {
                    if (viewDocument.getChannel() == null) {
                        return new String[][]{{"Name", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
                    }
                    return new String[][]{{"Name", viewDocument.getChannel().getDispDesc()}};
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label2", "\u8f6c\u6362\u5bf9\u8c61[") + baseObj + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label3", "]\u6570\u636e[") + n + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label4", "]\u5931\u8d25\uff01")), (Throwable)exception);
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label5", "\u8f6c\u6362\u6570\u636e[") + n + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label4", "]\u5931\u8d25\uff01"), exception);
        }
        return null;
    }

    private String[][] makeDocSource(Source source, Object object) {
        if (source == null) {
            return new String[][]{{"Id", object.toString()}, {"Name", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
        }
        return new String[][]{{"Id", String.valueOf(source.getId())}, {"Name", source.getName()}};
    }

    private String[][] makeHTMLCon(ViewDocument viewDocument) throws WCMException {
        switch (viewDocument.getPropertyAsInt("DOCTYPE", 0)) {
            case 20: {
                return new String[][]{{viewDocument.getHtmlContentWithImgFilter(null, false)}};
            }
            case 10: {
                return new String[][]{{CMyString.transDisplay(viewDocument.getContent(), false)}};
            }
            case 40: {
                return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label6", "\u5916\u90e8\u6587\u4ef6")}};
            }
            case 30: {
                return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label7", "\u94fe\u63a5\u6587\u6863")}};
            }
        }
        return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label8", "\u672a\u77e5\u7c7b\u578b\u6587\u6863[Type=") + viewDocument.getType() + "]"}};
    }

    private String[][] makeStatus(Status status) {
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeChannelValue(Channel channel) throws WCMException {
        if (channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}, {"RIGHTVALUE", "0"}, {"CHANNELTYPE", "0"}};
        }
        String string = "";
        User user = ContextHelper.getLoginUser();
        string = user.isAdministrator() || user.equals(channel.getCrUser()) ? RightValue.getAdministratorValues() : AuthServer.getRightValue((CMSObj)channel, user).toString();
        return new String[][]{{"ID", channel.getKey().toString()}, {"NAME", channel.getDispDesc()}, {"RIGHTVALUE", string}, {"CHANNELTYPE", String.valueOf(channel.getType())}};
    }

    public String[] registerTargetClassName() {
        return new String[]{ViewDocuments.class.getName(), ViewDocument.class.getName()};
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) throws ConvertException {
        ViewDocuments viewDocuments = (ViewDocuments)baseObjs;
        try {
            return new String[][]{{"CanSort", String.valueOf(viewDocuments.canSort())}};
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), exception);
        }
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        ViewDocument viewDocument = (ViewDocument)baseObj;
        try {
            return new String[][]{{"CanEdit", String.valueOf(viewDocument.hasRight(ContextHelper.getLoginUser(), 32))}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), wCMException);
        }
    }

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        String[] stringArray;
        ViewDocument viewDocument = (ViewDocument)baseObj;
        String[] stringArray2 = null;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                stringArray = ContextHelper.getLoginUser();
                stringArray2 = new String[]{"Right", viewDocument.getRightValue((User)stringArray).toString()};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label10", "\u6784\u9020[") + viewDocument + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label11", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        stringArray = null;
        try {
            stringArray = new String[]{"Topped", String.valueOf(viewDocument.isTopped())};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new String[][]{stringArray, stringArray2};
    }

    protected Hashtable[] getPropertiesArray(BaseObj baseObj, boolean bl) {
        ViewDocument viewDocument = (ViewDocument)baseObj;
        Hashtable hashtable = bl ? viewDocument.getAllProperty() : viewDocument.getProperties();
        Hashtable hashtable2 = viewDocument.getChnlDocProperties();
        if (hashtable2 == null) {
            return new Hashtable[]{hashtable};
        }
        if (hashtable2.containsKey("CRUSER")) {
            Hashtable hashtable3 = (Hashtable)hashtable2.clone();
            Object v = hashtable3.get("CRUSER");
            hashtable3.remove("CRUSER");
            hashtable3.put("CHNLDOCCRUSER", v);
            return new Hashtable[]{hashtable, hashtable3};
        }
        return new Hashtable[]{hashtable, hashtable2};
    }

    protected Element makeElementFromBaseObj(MethodContext methodContext, String string, BaseObj baseObj, boolean bl, String[] stringArray) throws ConvertException {
        boolean bl2 = bl || methodContext.getValue("LoadText", false);
        return super.makeElementFromBaseObj(methodContext, string, baseObj, bl2, stringArray);
    }
}

