/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.TemplateAuthHelper;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;

public class TemplateToXML
extends BaseWCMObjectToXML {
    private static final int FOLDER_TYPE = 1;
    private static final int TEMP_TYPE = 2;

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        Template template = (Template)baseObj;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                User user = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                if (user.isAdministrator() || user.getName().equals(template.getCrUserName())) {
                    rightValue = new RightValue(RightValue.VALUE_ADMINISTRATOR);
                } else {
                    IPublishFolder iPublishFolder = (IPublishFolder)methodContext.getContextCacheData("Host");
                    rightValue = TemplateAuthHelper.makeTemplateRightValue(methodContext, user, template, iPublishFolder);
                }
                return new String[][]{{"Right", rightValue.toString()}};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(TemplateToXML.class, "TemplateToXML.label1", "\u6784\u9020[") + template + I18NMessage.get(TemplateToXML.class, "TemplateToXML.label2", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        return null;
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        Template template = (Template)baseObj;
        switch (n) {
            case 1: {
                IPublishFolder iPublishFolder = this.findHost(template);
                return new String[][]{{"Type", String.valueOf(template.getFolderType())}, {"TypeDesc", iPublishFolder.isRoot() ? I18NMessage.get(TemplateToXML.class, "TemplateToXML.label3", "\u7ad9\u70b9") : I18NMessage.get(TemplateToXML.class, "TemplateToXML.label4", "\u680f\u76ee")}, {"Id", String.valueOf(template.getFolderId())}, {"Name", iPublishFolder.getInfo()}, {"RootId", String.valueOf(template.getRootId())}, {"RootType", String.valueOf(template.getRootType())}};
            }
            case 2: {
                return new String[][]{{"Name", this.makeTemplateTypeName(template.getType())}, {"Id", String.valueOf(template.getType())}};
            }
        }
        return null;
    }

    private String makeTemplateTypeName(int n) {
        switch (n) {
            case 0: {
                return I18NMessage.get(TemplateToXML.class, "TemplateToXML.label5", "\u5d4c\u5957");
            }
            case 1: {
                return I18NMessage.get(TemplateToXML.class, "TemplateToXML.label6", "\u6982\u89c8");
            }
            case 2: {
                return I18NMessage.get(TemplateToXML.class, "TemplateToXML.label7", "\u7ec6\u89c8");
            }
        }
        return I18NMessage.get(TemplateToXML.class, "TemplateToXML.label8", "\u672a\u77e5[") + n + "]";
    }

    private IPublishFolder findHost(Template template) throws ConvertException {
        IPublishFolder iPublishFolder = null;
        try {
            iPublishFolder = template.getFolder();
        }
        catch (WCMException wCMException) {
            throw new ConvertException(102101, I18NMessage.get(TemplateToXML.class, "TemplateToXML.label9", "\u83b7\u53d6\u6a21\u677f\u6240\u5904\u7684\u7ad9\u70b9/\u680f\u76ee\u53d1\u751f\u5f02\u5e38\uff01"), wCMException);
        }
        return iPublishFolder;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("FolderType", 1, "Folder");
        this.registerHostSpecialProperty("TempType", 2);
    }

    public String[] registerTargetClassName() {
        return new String[]{Template.class.getName(), Templates.class.getName()};
    }
}

