/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class TemplateEmployerToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(TemplateEmployerToXML.class);
    private static final int EMPLOYER_ID = 1;

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        try {
            IPublishElement iPublishElement = templateEmploy.getEmployer();
            switch (n) {
                case 1: {
                    if (iPublishElement != null) {
                        return new String[][]{{"Name", iPublishElement.getInfo()}, {"Id", String.valueOf(iPublishElement.getId())}, {"Type", String.valueOf(iPublishElement.getType())}, {"Path", this.getAdaptedPath(iPublishElement)}};
                    }
                    return new String[][]{{"Name", I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label1", "\u672a\u77e5\u5bf9\u8c61")}, {"Id", String.valueOf(templateEmploy.getEmployerId())}, {"Type", String.valueOf(templateEmploy.getEmployerType())}};
                }
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label2", "\u8f6c\u6362\u5c5e\u6027[") + n + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label3", "]\u5931\u8d25\uff01"), exception);
        }
        return null;
    }

    private String getAdaptedPath(IPublishElement iPublishElement) {
        String string = iPublishElement.getInfo();
        try {
            CMSObj cMSObj = iPublishElement.getSubstance();
            if (cMSObj != null && cMSObj instanceof Channel) {
                Channel channel = (Channel)cMSObj;
                StringBuffer stringBuffer = new StringBuffer(channel.getDesc() + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label4", "[\u680f\u76ee-") + channel.getId() + "]");
                for (Channel channel2 = channel.getParent(); channel2 != null && channel2 != null; channel2 = channel2.getParent()) {
                    stringBuffer.insert(0, " > ");
                    stringBuffer.insert(0, channel2.getDesc() + I18NMessage.get(TemplateEmployerToXML.class, "TemplateEmployerToXML.label4", "[\u680f\u76ee-") + channel2.getId() + "]");
                }
                string = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
        }
        catch (WCMException wCMException) {
            logger.warn((Object)"failed to get the path of channel!", (Throwable)wCMException);
        }
        return string;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) {
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("EmployerId", 1, "EMPLOYER");
    }

    public String[] registerTargetClassName() {
        return new String[]{TemplateEmploys.class.getName(), TemplateEmploy.class.getName()};
    }
}

